/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.animation;

import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFlying;
import java.util.HashSet;
import java.util.Locale;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.world.entity.Mob;

public class AnimationHolder {
    private final NavigableMap<Double, AnimationInfo> animations = new TreeMap<Double, AnimationInfo>();
    private final NavigableMap<Double, AnimationInfo> babyAnimations = new TreeMap<Double, AnimationInfo>();
    private final NavigableMap<Double, AnimationInfo> waterAnimations = new TreeMap<Double, AnimationInfo>();
    private final NavigableMap<Double, AnimationInfo> airAnimations = new TreeMap<Double, AnimationInfo>();
    private final Set<String> lookup = new HashSet<String>();

    public void add(AnimationInfo animation) {
        String name = animation.animation.animationName.toLowerCase(Locale.ROOT);
        String[] parts = name.split("_");
        int weight = 1;
        if (parts.length >= 3) {
            try {
                Integer.parseInt(parts[parts.length - 2]);
                weight = Integer.parseInt(parts[parts.length - 1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (name.contains("_baby")) {
            AnimationHolder.addAnimation(this.babyAnimations, animation, weight);
        } else if (name.contains("_water")) {
            AnimationHolder.addAnimation(this.waterAnimations, animation, weight);
        } else if (name.contains("_air")) {
            AnimationHolder.addAnimation(this.airAnimations, animation, weight);
        } else {
            AnimationHolder.addAnimation(this.animations, animation, weight);
        }
        this.lookup.add(animation.animation.animationName);
    }

    private static void addAnimation(NavigableMap<Double, AnimationInfo> map, AnimationInfo animation, double weight) {
        if (!map.isEmpty()) {
            map.put((Double)map.lastKey() + weight, animation);
        } else {
            map.put(weight, animation);
        }
    }

    public boolean hasAnimation(String animationName) {
        return this.lookup.contains(animationName);
    }

    public AnimationInfo getRandomAnimation(Mob entity) {
        if (!this.babyAnimations.isEmpty() && entity.m_6162_()) {
            return AnimationHolder.getRandomAnimation(this.babyAnimations, entity.m_21187_());
        }
        if (!this.waterAnimations.isEmpty() && entity.m_20069_()) {
            return AnimationHolder.getRandomAnimation(this.waterAnimations, entity.m_21187_());
        }
        if (entity instanceof PrehistoricFlying) {
            PrehistoricFlying flying = (PrehistoricFlying)entity;
            if (!this.airAnimations.isEmpty() && flying.m_142592_()) {
                return AnimationHolder.getRandomAnimation(this.airAnimations, entity.m_21187_());
            }
        }
        return AnimationHolder.getRandomAnimation(this.animations, entity.m_21187_());
    }

    private static AnimationInfo getRandomAnimation(NavigableMap<Double, AnimationInfo> map, Random random) {
        return map.higherEntry(random.nextDouble((Double)map.lastKey())).getValue();
    }
}

