/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.animation;

import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategory;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.animation.ClientAnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.animation.PausableAnimationController;
import com.github.teamfossilsarcheology.fossil.entity.animation.ServerAnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricAnimatable;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFish;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFlying;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricLeaping;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricSwimming;
import com.github.teamfossilsarcheology.fossil.entity.util.Util;
import com.github.teamfossilsarcheology.fossil.network.MessageHandler;
import com.github.teamfossilsarcheology.fossil.network.S2CSyncActiveAnimationMessage;
import com.github.teamfossilsarcheology.fossil.network.debug.S2CCancelAnimationMessage;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.Animation;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;

public class AnimationLogic<T extends Mob> {
    public static final String IDLE_CTRL = "Movement/Idle";
    public static final String EAT_CTRL = "Eat";
    public static final String ATTACK_CTRL = "Attack";
    private final Map<String, ActiveAnimationInfo> activeAnimations = new Object2ObjectOpenHashMap();
    private final Map<ActiveAnimationInfo, BooleanSupplier> additionalLogic = new Object2ObjectOpenHashMap();
    private final Map<String, ActiveAnimationInfo> nextAnimations = new Object2ObjectOpenHashMap();
    private final Map<String, Float> prevAnimationSpeeds = new Object2FloatOpenHashMap();
    protected final T entity;

    public AnimationLogic(T entity) {
        this.entity = entity;
    }

    public Optional<ActiveAnimationInfo> getActiveAnimation(String controller) {
        return Optional.ofNullable(this.activeAnimations.get(controller));
    }

    private ActiveAnimationInfo putActiveAnimation(String controller, ActiveAnimationInfo info) {
        this.additionalLogic.remove(this.activeAnimations.put(controller, info));
        return info;
    }

    public void triggerAnimation(String controller, AnimationInfo animationInfo, AnimationCategory category) {
        if (animationInfo != null && !((Mob)this.entity).f_19853_.f_46443_) {
            ActiveAnimationInfo activeAnimationInfo = new Builder(animationInfo.animation, ((Mob)this.entity).f_19853_.m_46467_(), category).forced().transitionLength(5.0).loop(false).build();
            TargetingConditions conditions = TargetingConditions.m_148353_().m_148355_().m_26883_(30.0);
            List players = ((ServerLevel)((Mob)this.entity).f_19853_).m_8795_(serverPlayer -> conditions.m_26885_((LivingEntity)serverPlayer, this.entity));
            MessageHandler.SYNC_CHANNEL.sendToPlayers((Iterable)players, (Object)new S2CSyncActiveAnimationMessage((Entity)this.entity, controller, activeAnimationInfo));
        }
    }

    public ActiveAnimationInfo forceAnimation(String controller, AnimationInfo animationInfo, AnimationCategory category, double speed, double transitionLength, boolean loop) {
        if (animationInfo != null) {
            ActiveAnimationInfo activeAnimationInfo = new Builder(animationInfo.animation, ((Mob)this.entity).f_19853_.m_46467_(), category).forced().transitionLength(transitionLength).speed(speed).loop(loop).build();
            this.addNextAnimation(controller, activeAnimationInfo);
            if (!((Mob)this.entity).f_19853_.f_46443_) {
                TargetingConditions conditions = TargetingConditions.m_148353_().m_148355_().m_26883_(30.0);
                List players = ((ServerLevel)((Mob)this.entity).f_19853_).m_8795_(serverPlayer -> conditions.m_26885_((LivingEntity)serverPlayer, this.entity));
                MessageHandler.SYNC_CHANNEL.sendToPlayers((Iterable)players, (Object)new S2CSyncActiveAnimationMessage((Entity)this.entity, controller, activeAnimationInfo));
            }
            return activeAnimationInfo;
        }
        return null;
    }

    public ActiveAnimationInfo addActiveAnimation(String controller, AnimationCategory category) {
        return this.addActiveAnimation(controller, ((PrehistoricAnimatable)this.entity).getAnimation((AnimationCategory)category).animation, category, false);
    }

    public ActiveAnimationInfo addActiveAnimation(String controller, AnimationCategory category, boolean keepActive) {
        return this.addActiveAnimation(controller, ((PrehistoricAnimatable)this.entity).getAnimation((AnimationCategory)category).animation, category, keepActive);
    }

    public ActiveAnimationInfo addActiveAnimation(String controller, Animation animation, AnimationCategory category, boolean keepActive) {
        if (animation == null) {
            return null;
        }
        ActiveAnimationInfo active = this.getActiveAnimation(controller).orElse(null);
        if (active == null) {
            return this.putActiveAnimation(controller, new Builder(animation, ((Mob)this.entity).f_19853_.m_46467_(), category).keepActive(keepActive).build());
        }
        boolean replaceAnim = false;
        if (active.category == category && this.isAnimationDone(active)) {
            replaceAnim = !active.loop || this.entity.m_21187_().nextFloat() < category.chance();
        } else if (active.category != category) {
            boolean bl = replaceAnim = active.loop && (!active.keepActive || this.additionalLogic.getOrDefault(active, () -> false).getAsBoolean()) || this.isAnimationDone(active);
        }
        if (replaceAnim) {
            int transitionLength = Math.max(category.transitionLength(), active.category.transitionLength());
            return this.putActiveAnimation(controller, new Builder(animation, ((Mob)this.entity).f_19853_.m_46467_(), category).transitionLength(transitionLength).keepActive(keepActive).build());
        }
        return null;
    }

    public void addNextAnimation(String controller, ActiveAnimationInfo activeAnimationInfo) {
        this.nextAnimations.put(controller, activeAnimationInfo);
    }

    public void cancelAnimation(String controller) {
        if (((Mob)this.entity).f_19853_.f_46443_) {
            this.getActiveAnimation(controller).ifPresent(this.additionalLogic::remove);
            this.activeAnimations.remove(controller);
        } else {
            TargetingConditions conditions = TargetingConditions.m_148353_().m_148355_().m_26883_(30.0);
            List players = ((ServerLevel)((Mob)this.entity).f_19853_).m_8795_(serverPlayer -> conditions.m_26885_((LivingEntity)serverPlayer, this.entity));
            MessageHandler.DEBUG_CHANNEL.sendToPlayers((Iterable)players, (Object)new S2CCancelAnimationMessage(this.entity.m_142049_(), controller));
        }
    }

    public boolean isAnimationDone(String controller) {
        Optional<ActiveAnimationInfo> opt = this.getActiveAnimation(controller);
        return opt.isEmpty() || this.isAnimationDone(opt.get());
    }

    public boolean isAnimationDone(ActiveAnimationInfo activeAnimation) {
        return (double)((Mob)this.entity).f_19853_.m_46467_() >= activeAnimation.endTick;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isBlocked() {
        PrehistoricSwimming swimming;
        T t = this.entity;
        if (t instanceof PrehistoricSwimming && (swimming = (PrehistoricSwimming)t).isDoingGrabAttack()) {
            return true;
        }
        t = this.entity;
        if (!(t instanceof Prehistoric)) return false;
        Prehistoric prehistoric = (Prehistoric)t;
        if (((Mob)this.entity).f_19853_.m_46467_() >= prehistoric.getEntityHitboxData().getAttackBoxData().attackBoxEndTime()) return false;
        return true;
    }

    public double getActionDelay(String controller) {
        if (this.activeAnimations.containsKey(controller)) {
            ActiveAnimationInfo activeAnimation = this.activeAnimations.get(controller);
            Map<String, ServerAnimationInfo> animationData = ((PrehistoricAnimatable)this.entity).getServerAnimationInfos();
            if (animationData.containsKey(activeAnimation.animationName)) {
                return animationData.get((Object)activeAnimation.animationName).actionDelay;
            }
        }
        return 0.0;
    }

    public PlayState waterPredicate(AnimationEvent<PrehistoricSwimming> event) {
        if (this.isBlocked()) {
            return PlayState.STOP;
        }
        AnimationController controller = event.getController();
        if (this.tryNextAnimation(controller)) {
            return PlayState.CONTINUE;
        }
        Optional<ActiveAnimationInfo> activeAnimation = this.getActiveAnimation(controller.getName());
        if (activeAnimation.isPresent() && this.tryForcedAnimation(event, activeAnimation.get())) {
            return PlayState.CONTINUE;
        }
        double animationSpeed = 1.0;
        if (((PrehistoricSwimming)event.getAnimatable()).isBeached()) {
            this.addActiveAnimation(controller.getName(), AnimationCategory.BEACHED);
        } else if (this.entity.m_5803_()) {
            this.addActiveAnimation(controller.getName(), AnimationCategory.SLEEP);
        } else if (event.isMoving()) {
            if (this.entity.m_20069_()) {
                if (this.entity.m_20142_()) {
                    this.addActiveAnimation(controller.getName(), AnimationCategory.SWIM_FAST);
                } else {
                    this.addActiveAnimation(controller.getName(), AnimationCategory.SWIM);
                }
            } else {
                animationSpeed = this.addMovementAnimation(event, true);
            }
        } else if (((PrehistoricSwimming)event.getAnimatable()).isWeak()) {
            this.addActiveAnimation(controller.getName(), AnimationCategory.KNOCKOUT);
        } else {
            this.addActiveAnimation(controller.getName(), AnimationCategory.IDLE);
        }
        this.prevAnimationSpeeds.put(controller.getName(), Float.valueOf((float)animationSpeed));
        AnimationLogic.setAnimationSpeed(controller, animationSpeed, event.getAnimationTick());
        Optional<ActiveAnimationInfo> newAnimation = this.getActiveAnimation(controller.getName());
        if (newAnimation.isPresent()) {
            controller.setAnimation(new AnimationBuilder().addAnimation(newAnimation.get().animationName, (ILoopType)(newAnimation.get().loop ? ILoopType.EDefaultLoopTypes.LOOP : ILoopType.EDefaultLoopTypes.PLAY_ONCE)));
        }
        return PlayState.CONTINUE;
    }

    public static void setAnimationSpeed(AnimationController<?> controller, double animationSpeed, double animationTick) {
        if (controller instanceof PausableAnimationController) {
            PausableAnimationController pausableAnimationController = (PausableAnimationController)controller;
            pausableAnimationController.setAnimationSpeed(animationSpeed, animationTick);
        }
    }

    public boolean tryNextAnimation(AnimationController<?> controller) {
        if (!this.nextAnimations.containsKey(controller.getName())) {
            return false;
        }
        ActiveAnimationInfo next = this.nextAnimations.remove(controller.getName());
        this.putActiveAnimation(controller.getName(), next);
        controller.transitionLengthTicks = next.transitionLength;
        controller.markNeedsReload();
        controller.setAnimation(new AnimationBuilder().addAnimation(next.animationName, (ILoopType)(next.loop ? ILoopType.EDefaultLoopTypes.LOOP : null)));
        return true;
    }

    public boolean tryForcedAnimation(AnimationEvent<?> event, ActiveAnimationInfo activeAnimation) {
        if (activeAnimation.forced && (activeAnimation.loop || !this.isAnimationDone(activeAnimation))) {
            AnimationController controller = event.getController();
            AnimationLogic.setAnimationSpeed(controller, activeAnimation.speed, event.getAnimationTick());
            controller.transitionLengthTicks = activeAnimation.transitionLength;
            controller.setAnimation(new AnimationBuilder().addAnimation(activeAnimation.animationName, (ILoopType)(activeAnimation.loop ? ILoopType.EDefaultLoopTypes.LOOP : ILoopType.EDefaultLoopTypes.PLAY_ONCE)));
            return true;
        }
        return false;
    }

    public double addMovementAnimation(AnimationEvent<? extends Prehistoric> event, boolean canSprint) {
        double scaleMult;
        AnimationController controller = event.getController();
        ClientAnimationInfo walkAnim = (ClientAnimationInfo)((PrehistoricAnimatable)this.entity).nextWalkingAnimation();
        double animationSpeed = scaleMult = (double)(1.0f / ((Prehistoric)event.getAnimatable()).m_6134_());
        double f = this.entity.m_20096_() ? (double)(((Mob)this.entity).f_19853_.m_8055_(this.entity.m_142538_().m_7495_()).m_60734_().m_49958_() * 0.91f) : (double)0.91f;
        double mobSpeed = this.entity.m_20184_().m_165924_() / f * 20.0;
        mobSpeed = Math.min(Util.attributeToSpeed(this.entity.m_21133_(Attributes.f_22279_), ((Prehistoric)event.getAnimatable()).attributes().sprintMod(), this.entity.m_20142_()), mobSpeed);
        if (walkAnim.blocksPerSecond > 0.0) {
            animationSpeed *= mobSpeed / walkAnim.blocksPerSecond;
        }
        if (animationSpeed <= 0.1) {
            this.addActiveAnimation(controller.getName(), AnimationCategory.IDLE);
        } else {
            if (animationSpeed < (double)(this.prevAnimationSpeeds.getOrDefault(controller.getName(), Float.valueOf(0.0f)).floatValue() - 1.0E-5f)) {
                animationSpeed = Mth.m_14121_((float)this.prevAnimationSpeeds.get(controller.getName()).floatValue(), (float)((float)animationSpeed), (float)0.05f);
            }
            if (canSprint && (animationSpeed > 2.75 || this.entity.m_20142_())) {
                ClientAnimationInfo sprintAnim = (ClientAnimationInfo)((PrehistoricAnimatable)this.entity).nextSprintingAnimation();
                animationSpeed = scaleMult;
                if (sprintAnim.blocksPerSecond > 0.0) {
                    animationSpeed *= mobSpeed / sprintAnim.blocksPerSecond;
                }
                this.addActiveAnimation(controller.getName(), sprintAnim.animation, AnimationCategory.SPRINT, false);
            } else {
                this.addActiveAnimation(controller.getName(), walkAnim.animation, AnimationCategory.WALK, false);
            }
        }
        return animationSpeed;
    }

    public PlayState leapingPredicate(AnimationEvent<PrehistoricLeaping> event) {
        AnimationController controller = event.getController();
        if (this.tryNextAnimation(controller)) {
            return PlayState.CONTINUE;
        }
        Optional<ActiveAnimationInfo> activeAnimation = this.getActiveAnimation(controller.getName());
        if (activeAnimation.isPresent() && this.tryForcedAnimation(event, activeAnimation.get())) {
            return PlayState.CONTINUE;
        }
        double animationSpeed = 1.0;
        PrehistoricLeaping entity = (PrehistoricLeaping)event.getAnimatable();
        if (entity.getLeapSystem().isAttackRiding()) {
            AnimationLogic.setAnimationSpeed(controller, 1.0, event.getAnimationTick());
            controller.transitionLengthTicks = 10.0;
            controller.setAnimation(new AnimationBuilder().loop(entity.getLeapAttackAnimationName()));
            return PlayState.CONTINUE;
        }
        if (entity.getLeapSystem().hasLeapStarted() || entity.getLeapSystem().isLeapFlying()) {
            AnimationLogic.setAnimationSpeed(controller, 1.0, event.getAnimationTick());
            if (controller.getCurrentAnimation() != null && entity.getAnimations().get(AnimationCategory.FALL).hasAnimation(controller.getCurrentAnimation().animationName) && entity.m_20096_()) {
                controller.transitionLengthTicks = 0.0;
                controller.setAnimation(new AnimationBuilder().playOnce(entity.getLandAnimationName()));
            } else {
                controller.setAnimation(new AnimationBuilder().playOnce(entity.getLeapStartAnimationName()).loop(entity.getAnimation((AnimationCategory)AnimationCategory.FALL).animation.animationName));
            }
            return PlayState.CONTINUE;
        }
        if (entity.getLeapSystem().isLanding()) {
            AnimationLogic.setAnimationSpeed(controller, 1.0, event.getAnimationTick());
            controller.transitionLengthTicks = 0.0;
            controller.setAnimation(new AnimationBuilder().playOnce(entity.getLandAnimationName()));
            return PlayState.CONTINUE;
        }
        if (entity.m_5803_()) {
            this.addActiveAnimation(controller.getName(), AnimationCategory.SLEEP);
        } else if (entity.sitSystem.isSitting()) {
            this.addActiveAnimation(controller.getName(), AnimationCategory.SIT);
        } else if (entity.isClimbing()) {
            this.addActiveAnimation(controller.getName(), AnimationCategory.CLIMB);
            animationSpeed = 2.0;
        } else if (event.isMoving()) {
            if (entity.m_20069_()) {
                ActiveAnimationInfo info = this.addActiveAnimation(controller.getName(), AnimationCategory.SWIM, true);
                if (info != null) {
                    this.additionalLogic.put(info, () -> ((PrehistoricLeaping)entity).m_20096_());
                }
            } else {
                animationSpeed = this.addMovementAnimation(event, true);
            }
        } else if (entity.m_20069_()) {
            this.addActiveAnimation(controller.getName(), AnimationCategory.SWIM);
        } else {
            this.addActiveAnimation(controller.getName(), AnimationCategory.IDLE);
        }
        AnimationLogic.setAnimationSpeed(controller, animationSpeed, event.getAnimationTick());
        Optional<ActiveAnimationInfo> newAnimation = this.getActiveAnimation(controller.getName());
        if (newAnimation.isPresent()) {
            controller.transitionLengthTicks = newAnimation.get().transitionLength;
            controller.setAnimation(new AnimationBuilder().addAnimation(newAnimation.get().animationName, (ILoopType)(newAnimation.get().loop ? ILoopType.EDefaultLoopTypes.LOOP : ILoopType.EDefaultLoopTypes.PLAY_ONCE)));
        }
        return PlayState.CONTINUE;
    }

    public PlayState landPredicate(AnimationEvent<Prehistoric> event) {
        if (this.isBlocked()) {
            return PlayState.STOP;
        }
        AnimationController controller = event.getController();
        if (this.tryNextAnimation(controller)) {
            return PlayState.CONTINUE;
        }
        Optional<ActiveAnimationInfo> activeAnimation = this.getActiveAnimation(controller.getName());
        if (activeAnimation.isPresent() && this.tryForcedAnimation(event, activeAnimation.get())) {
            return PlayState.CONTINUE;
        }
        double animationSpeed = 1.0;
        if (((Prehistoric)event.getAnimatable()).isWeak()) {
            this.addActiveAnimation(controller.getName(), AnimationCategory.KNOCKOUT);
        } else if (this.entity.m_5803_()) {
            this.addActiveAnimation(controller.getName(), AnimationCategory.SLEEP);
        } else if (((Prehistoric)event.getAnimatable()).sitSystem.isSitting()) {
            this.addActiveAnimation(controller.getName(), AnimationCategory.SIT);
        } else if (this.entity.m_20069_()) {
            ActiveAnimationInfo info = this.addActiveAnimation(controller.getName(), AnimationCategory.SWIM, true);
            if (info != null) {
                this.additionalLogic.put(info, () -> this.entity.m_20096_());
            }
        } else if (event.isMoving()) {
            animationSpeed = this.addMovementAnimation(event, true);
        } else {
            this.addActiveAnimation(controller.getName(), AnimationCategory.IDLE);
        }
        this.prevAnimationSpeeds.put(controller.getName(), Float.valueOf((float)animationSpeed));
        AnimationLogic.setAnimationSpeed(controller, animationSpeed, event.getAnimationTick());
        Optional<ActiveAnimationInfo> newAnimation = this.getActiveAnimation(controller.getName());
        if (newAnimation.isPresent()) {
            controller.transitionLengthTicks = newAnimation.get().transitionLength;
            controller.setAnimation(new AnimationBuilder().addAnimation(newAnimation.get().animationName, (ILoopType)(newAnimation.get().loop ? ILoopType.EDefaultLoopTypes.LOOP : ILoopType.EDefaultLoopTypes.PLAY_ONCE)));
        }
        return PlayState.CONTINUE;
    }

    public PlayState attackPredicate(AnimationEvent<Prehistoric> event) {
        AnimationController controller = event.getController();
        if (this.tryNextAnimation(controller)) {
            return PlayState.CONTINUE;
        }
        if (!this.isAnimationDone(controller.getName())) {
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public PlayState grabAttackPredicate(AnimationEvent<PrehistoricSwimming> event) {
        AnimationController controller = event.getController();
        if (this.tryNextAnimation(controller)) {
            return PlayState.CONTINUE;
        }
        if (((PrehistoricSwimming)event.getAnimatable()).isDoingGrabAttack()) {
            this.addActiveAnimation(controller.getName(), ((PrehistoricSwimming)event.getAnimatable()).nextGrabbingAnimation().animation, AnimationCategory.ATTACK, false);
        } else if (this.isAnimationDone(controller.getName())) {
            this.activeAnimations.remove(controller.getName());
        }
        Optional<ActiveAnimationInfo> newAnimation = this.getActiveAnimation(controller.getName());
        if (newAnimation.isPresent()) {
            controller.setAnimation(new AnimationBuilder().addAnimation(newAnimation.get().animationName()));
            return PlayState.CONTINUE;
        }
        event.getController().markNeedsReload();
        return PlayState.STOP;
    }

    public PlayState fishPredicate(AnimationEvent<PrehistoricFish> event) {
        AnimationController controller = event.getController();
        if (!this.entity.m_20069_()) {
            this.addActiveAnimation(controller.getName(), AnimationCategory.BEACHED);
        } else if (event.isMoving()) {
            this.addActiveAnimation(controller.getName(), AnimationCategory.SWIM);
        } else {
            this.addActiveAnimation(controller.getName(), AnimationCategory.IDLE);
        }
        Optional<ActiveAnimationInfo> newAnimation = this.getActiveAnimation(controller.getName());
        newAnimation.ifPresent(newInfo -> controller.setAnimation(new AnimationBuilder().addAnimation(newInfo.animationName(), (ILoopType)(newInfo.loop ? ILoopType.EDefaultLoopTypes.LOOP : ILoopType.EDefaultLoopTypes.PLAY_ONCE))));
        return PlayState.CONTINUE;
    }

    public PlayState flyingPredicate(AnimationEvent<PrehistoricFlying> event) {
        AnimationController controller = event.getController();
        if (this.tryNextAnimation(controller)) {
            return PlayState.CONTINUE;
        }
        Optional<ActiveAnimationInfo> activeAnimation = this.getActiveAnimation(controller.getName());
        if (activeAnimation.isPresent() && this.tryForcedAnimation(event, activeAnimation.get())) {
            return PlayState.CONTINUE;
        }
        controller.transitionLengthTicks = 5.0;
        double animationSpeed = 1.0;
        if (!((PrehistoricFlying)event.getAnimatable()).isTakingOff()) {
            if (((PrehistoricFlying)event.getAnimatable()).m_142592_()) {
                if (this.entity.m_20142_()) {
                    this.addActiveAnimation(controller.getName(), AnimationCategory.FLY_FAST);
                } else {
                    this.addActiveAnimation(controller.getName(), AnimationCategory.FLY);
                }
            } else if (this.entity.m_5803_()) {
                this.addActiveAnimation(controller.getName(), AnimationCategory.SLEEP);
            } else if (((PrehistoricFlying)event.getAnimatable()).sitSystem.isSitting()) {
                this.addActiveAnimation(controller.getName(), AnimationCategory.SIT);
            } else if (((PrehistoricFlying)event.getAnimatable()).isClimbing()) {
                this.addActiveAnimation(controller.getName(), AnimationCategory.CLIMB);
            } else if (this.entity.m_20069_()) {
                ActiveAnimationInfo info = this.addActiveAnimation(controller.getName(), AnimationCategory.SWIM, true);
                if (info != null) {
                    this.additionalLogic.put(info, () -> this.entity.m_20096_());
                }
            } else if (!this.entity.m_20096_()) {
                this.addActiveAnimation(controller.getName(), AnimationCategory.FLY);
                controller.transitionLengthTicks = 10.0;
                animationSpeed = 0.5;
            } else if (event.isMoving()) {
                animationSpeed = this.addMovementAnimation(event, false);
            } else {
                this.addActiveAnimation(controller.getName(), AnimationCategory.IDLE);
            }
        }
        AnimationLogic.setAnimationSpeed(controller, animationSpeed, event.getAnimationTick());
        Optional<ActiveAnimationInfo> newAnimation = this.getActiveAnimation(controller.getName());
        newAnimation.ifPresent(newInfo -> controller.setAnimation(new AnimationBuilder().addAnimation(newInfo.animationName(), (ILoopType)(newInfo.loop ? ILoopType.EDefaultLoopTypes.LOOP : ILoopType.EDefaultLoopTypes.PLAY_ONCE))));
        return PlayState.CONTINUE;
    }

    public record ActiveAnimationInfo(String animationName, double endTick, AnimationCategory category, boolean forced, double transitionLength, double speed, boolean loop, boolean keepActive) {
    }

    public static class Builder {
        private final String animationName;
        private final double endTick;
        private final AnimationCategory category;
        private boolean forced;
        private double transitionLength = 5.0;
        private double speed = 1.0;
        private boolean loop;
        private boolean keepActive;

        public Builder(Animation animation, long currentTime, AnimationCategory category) {
            this.animationName = animation.animationName;
            this.endTick = (double)currentTime + animation.animationLength;
            this.category = category;
            this.transitionLength = category.transitionLength();
            this.loop = animation.loop.isRepeatingAfterEnd();
        }

        public Builder(String animationName, double endTick, AnimationCategory category) {
            this.animationName = animationName;
            this.endTick = endTick;
            this.category = category;
            this.transitionLength = category.transitionLength();
        }

        public Builder forced() {
            this.forced = true;
            return this;
        }

        public Builder transitionLength(double length) {
            this.transitionLength = length;
            return this;
        }

        public Builder speed(double speed) {
            this.speed = speed;
            return this;
        }

        public Builder loop(boolean loop) {
            this.loop = loop;
            return this;
        }

        public Builder loop() {
            this.loop = true;
            return this;
        }

        public Builder keepActive(boolean keepActive) {
            this.keepActive = keepActive;
            return this;
        }

        public ActiveAnimationInfo build() {
            return new ActiveAnimationInfo(this.animationName, this.endTick, this.category, this.forced, this.transitionLength, this.speed, this.loop, this.keepActive);
        }
    }
}

