/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.base;

import com.github.teamfossilsarcheology.fossil.entity.ModEntities;
import com.github.teamfossilsarcheology.fossil.entity.data.EntityDataLoader;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.EntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.InfoFlag;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricMobType;
import com.github.teamfossilsarcheology.fossil.item.BirdEggItem;
import com.github.teamfossilsarcheology.fossil.item.CustomSpawnEggItem;
import com.github.teamfossilsarcheology.fossil.item.DNAItem;
import com.github.teamfossilsarcheology.fossil.item.DinoBoneItem;
import com.github.teamfossilsarcheology.fossil.item.DinoEggItem;
import com.github.teamfossilsarcheology.fossil.item.FishEggItem;
import com.github.teamfossilsarcheology.fossil.item.MammalEmbryoItem;
import com.github.teamfossilsarcheology.fossil.item.MeatItem;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import com.github.teamfossilsarcheology.fossil.item.ModTabs;
import com.github.teamfossilsarcheology.fossil.item.NautilusMeatItem;
import com.github.teamfossilsarcheology.fossil.tags.ModEntityTypeTags;
import com.github.teamfossilsarcheology.fossil.util.TimePeriod;
import dev.architectury.core.item.ArchitecturyMobBucketItem;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum PrehistoricEntityInfo implements EntityInfo
{
    ALLIGATOR_GAR(ModEntities.ALLIGATOR_GAR, PrehistoricMobType.FISH, TimePeriod.MESOZOIC, 4408874, 11485745, InfoFlag.bucketable()),
    ALLOSAURUS(ModEntities.ALLOSAURUS, PrehistoricMobType.DINOSAUR, TimePeriod.MESOZOIC, 9468780, 6242861),
    ANKYLOSAURUS(ModEntities.ANKYLOSAURUS, PrehistoricMobType.DINOSAUR, TimePeriod.MESOZOIC, 9067337, 2169619),
    AQUILOLAMNA(ModEntities.AQUILOLAMNA, PrehistoricMobType.DINOSAUR_AQUATIC, TimePeriod.MESOZOIC, 10257016, 2629408, InfoFlag.bucketable()),
    ARTHROPLEURA(ModEntities.ARTHROPLEURA, PrehistoricMobType.ARTHROPOD, TimePeriod.PALEOZOIC, 2763052, 9917215),
    BRACHIOSAURUS(ModEntities.BRACHIOSAURUS, PrehistoricMobType.DINOSAUR, TimePeriod.MESOZOIC, 5395006, 0x222114),
    CERATOSAURUS(ModEntities.CERATOSAURUS, PrehistoricMobType.DINOSAUR, TimePeriod.MESOZOIC, 11842727, 0x776446),
    CITIPATI(ModEntities.CITIPATI, PrehistoricMobType.DINOSAUR, TimePeriod.MESOZOIC, 6179390, 0x667373),
    COELACANTH(ModEntities.COELACANTH, PrehistoricMobType.FISH, TimePeriod.MESOZOIC, 3553601, 10199465, InfoFlag.bucketable()),
    COMPSOGNATHUS(ModEntities.COMPSOGNATHUS, PrehistoricMobType.DINOSAUR, TimePeriod.MESOZOIC, 13354948, 3813676),
    CONFUCIUSORNIS(ModEntities.CONFUCIUSORNIS, PrehistoricMobType.BIRD, TimePeriod.MESOZOIC, 14345705, 0x8B8B8D),
    CRASSIGYRINUS(ModEntities.CRASSIGYRINUS, PrehistoricMobType.DINOSAUR_FISH, TimePeriod.PALEOZOIC, 13268794, 9390893, InfoFlag.bucketable()),
    DEINONYCHUS(ModEntities.DEINONYCHUS, PrehistoricMobType.DINOSAUR, TimePeriod.MESOZOIC, 0x2B2424, 0xC8C8C8),
    DICRANURUS(ModEntities.DICRANURUS, PrehistoricMobType.ARTHROPOD, TimePeriod.PALEOZOIC, 10059842, 0x1D1D1D, InfoFlag.bucketable()),
    DILOPHOSAURUS(ModEntities.DILOPHOSAURUS, PrehistoricMobType.DINOSAUR, TimePeriod.MESOZOIC, 5134641, 15880980),
    DIMETRODON(ModEntities.DIMETRODON, PrehistoricMobType.DINOSAUR, TimePeriod.PALEOZOIC, 4337187, 9519912),
    DIMORPHODON(ModEntities.DIMORPHODON, PrehistoricMobType.DINOSAUR, TimePeriod.MESOZOIC, 0xD6D6D6, 0x3B3B3B),
    DIPLOCAULUS(ModEntities.DIPLOCAULUS, PrehistoricMobType.DINOSAUR_FISH, TimePeriod.PALEOZOIC, 11576192, 8165012, InfoFlag.bucketable()),
    DIPLODOCUS(ModEntities.DIPLODOCUS, PrehistoricMobType.DINOSAUR, TimePeriod.MESOZOIC, 0x937373, 14342343),
    DODO(ModEntities.DODO, PrehistoricMobType.BIRD, TimePeriod.CENOZOIC, 7359526, 12959898),
    DRYOSAURUS(ModEntities.DRYOSAURUS, PrehistoricMobType.DINOSAUR, TimePeriod.MESOZOIC, 6641489, 12493947),
    EDAPHOSAURUS(ModEntities.EDAPHOSAURUS, PrehistoricMobType.DINOSAUR, TimePeriod.PALEOZOIC, 6580029, 11898435),
    ELASMOTHERIUM(ModEntities.ELASMOTHERIUM, PrehistoricMobType.MAMMAL, TimePeriod.CENOZOIC, 7025179, 0x666666),
    GALLIMIMUS(ModEntities.GALLIMIMUS, PrehistoricMobType.DINOSAUR, TimePeriod.MESOZOIC, 6701355, 6169880),
    GASTORNIS(ModEntities.GASTORNIS, PrehistoricMobType.BIRD, TimePeriod.CENOZOIC, 3435614, 0xC8C8C8),
    HENODUS(ModEntities.HENODUS, PrehistoricMobType.DINOSAUR_AQUATIC, TimePeriod.MESOZOIC, 6372391, 10256480, InfoFlag.bucketable()),
    ICHTHYOSAURUS(ModEntities.ICHTHYOSAURUS, PrehistoricMobType.DINOSAUR_AQUATIC, TimePeriod.MESOZOIC, 2762290, 13550230, InfoFlag.bucketable()),
    KELENKEN(ModEntities.KELENKEN, PrehistoricMobType.BIRD, TimePeriod.CENOZOIC, 3747620, 15920085),
    LIOPLEURODON(ModEntities.LIOPLEURODON, PrehistoricMobType.DINOSAUR_AQUATIC, TimePeriod.MESOZOIC, 12568514, 1909022),
    LONCHODOMAS(ModEntities.LONCHODOMAS, PrehistoricMobType.ARTHROPOD, TimePeriod.PALEOZOIC, 9453878, 15970984, InfoFlag.bucketable()),
    MAMMOTH(ModEntities.MAMMOTH, PrehistoricMobType.MAMMAL, TimePeriod.CENOZOIC, 4009497, 2365195),
    MEGALANIA(ModEntities.MEGALANIA, PrehistoricMobType.DINOSAUR, TimePeriod.CENOZOIC, 7164989, 14462579),
    MEGALOCEROS(ModEntities.MEGALOCEROS, PrehistoricMobType.MAMMAL, TimePeriod.CENOZOIC, 6041114, 9329211),
    MEGALODON(ModEntities.MEGALODON, PrehistoricMobType.DINOSAUR_AQUATIC, TimePeriod.CENOZOIC, 6912894, 0xD0D5D5),
    MEGALOGRAPTUS(ModEntities.MEGALOGRAPTUS, PrehistoricMobType.ARTHROPOD, TimePeriod.PALEOZOIC, 11693893, 7419673, InfoFlag.bucketable()),
    MEGANEURA(ModEntities.MEGANEURA, PrehistoricMobType.ARTHROPOD, TimePeriod.PALEOZOIC, 6966335, 14726234),
    MOSASAURUS(ModEntities.MOSASAURUS, PrehistoricMobType.DINOSAUR_AQUATIC, TimePeriod.MESOZOIC, 8949136, 3820626),
    NAUTILUS(ModEntities.NAUTILUS, PrehistoricMobType.FISH, TimePeriod.MESOZOIC, 12934983, 0xF5F5F5, InfoFlag.bucketable()),
    ORNITHOLESTES(ModEntities.ORNITHOLESTES, PrehistoricMobType.DINOSAUR, TimePeriod.MESOZOIC, 3088922, 12859428),
    PACHYCEPHALOSAURUS(ModEntities.PACHYCEPHALOSAURUS, PrehistoricMobType.DINOSAUR, TimePeriod.MESOZOIC, 11970953, 8216122),
    PACHYRHINOSAURUS(ModEntities.PACHYRHINOSAURUS, PrehistoricMobType.DINOSAUR, TimePeriod.MESOZOIC, 11961450, 8890204),
    PARASAUROLOPHUS(ModEntities.PARASAUROLOPHUS, PrehistoricMobType.DINOSAUR, TimePeriod.MESOZOIC, 8949136, 3820626),
    PHORUSRHACOS(ModEntities.PHORUSRHACOS, PrehistoricMobType.BIRD, TimePeriod.CENOZOIC, 6245950, 0xD4D4D4),
    PLATYBELODON(ModEntities.PLATYBELODON, PrehistoricMobType.MAMMAL, TimePeriod.CENOZOIC, 9135441, 6440762),
    PLESIOSAURUS(ModEntities.PLESIOSAURUS, PrehistoricMobType.DINOSAUR_AQUATIC, TimePeriod.MESOZOIC, 14985326, 14776608, InfoFlag.bucketable()),
    POSTOSUCHUS(ModEntities.POSTOSUCHUS, PrehistoricMobType.DINOSAUR, TimePeriod.MESOZOIC, 4933929, 13947551),
    PROTOCERATOPS(ModEntities.PROTOCERATOPS, PrehistoricMobType.DINOSAUR, TimePeriod.MESOZOIC, 14931887, 11847394),
    PSITTACOSAURUS(ModEntities.PSITTACOSAURUS, PrehistoricMobType.DINOSAUR, TimePeriod.MESOZOIC, 10448997, 4467747),
    PTERANODON(ModEntities.PTERANODON, PrehistoricMobType.DINOSAUR, TimePeriod.MESOZOIC, 0xD6D6D6, 0x3B3B3B),
    QUAGGA(ModEntities.QUAGGA, PrehistoricMobType.MAMMAL, TimePeriod.CENOZOIC, 7748644, 13875627),
    QUETZALCOATLUS(ModEntities.QUETZALCOATLUS, PrehistoricMobType.DINOSAUR, TimePeriod.MESOZOIC, 1970956, 7521994),
    SARCOSUCHUS(ModEntities.SARCOSUCHUS, PrehistoricMobType.DINOSAUR, TimePeriod.MESOZOIC, 4933929, 9276517),
    SCOTOHARPES(ModEntities.SCOTOHARPES, PrehistoricMobType.ARTHROPOD, TimePeriod.PALEOZOIC, 0x844343, 0x2F2424, InfoFlag.bucketable()),
    SMILODON(ModEntities.SMILODON, PrehistoricMobType.MAMMAL, TimePeriod.CENOZOIC, 12094564, 15523790),
    SPINOSAURUS(ModEntities.SPINOSAURUS, PrehistoricMobType.DINOSAUR, TimePeriod.MESOZOIC, 8671530, 5648160),
    STEGOSAURUS(ModEntities.STEGOSAURUS, PrehistoricMobType.DINOSAUR, TimePeriod.MESOZOIC, 10256696, 6625303),
    STURGEON(ModEntities.STURGEON, PrehistoricMobType.FISH, TimePeriod.MESOZOIC, 6643035, 0xE6E3E3, InfoFlag.bucketable()),
    THERIZINOSAURUS(ModEntities.THERIZINOSAURUS, PrehistoricMobType.DINOSAUR, TimePeriod.MESOZOIC, 0x322212, 13278322),
    TIKTAALIK(ModEntities.TIKTAALIK, PrehistoricMobType.DINOSAUR_FISH, TimePeriod.PALEOZOIC, 6969882, 14143385, InfoFlag.bucketable()),
    TITANIS(ModEntities.TITANIS, PrehistoricMobType.BIRD, TimePeriod.CENOZOIC, 0x484848, 0xEFEFEF),
    TRICERATOPS(ModEntities.TRICERATOPS, PrehistoricMobType.DINOSAUR, TimePeriod.MESOZOIC, 6567213, 2431511),
    TYRANNOSAURUS(ModEntities.TYRANNOSAURUS, PrehistoricMobType.DINOSAUR, TimePeriod.MESOZOIC, 10324596, 4993302),
    VELOCIRAPTOR(ModEntities.VELOCIRAPTOR, PrehistoricMobType.DINOSAUR, TimePeriod.MESOZOIC, 4852996, 0xC9C9C9),
    WALLISEROPS(ModEntities.WALLISEROPS, PrehistoricMobType.ARTHROPOD, TimePeriod.PALEOZOIC, 5257000, 12424006, InfoFlag.bucketable());

    private static List<PrehistoricEntityInfo> boneCache;
    public final PrehistoricMobType mobType;
    public final TimePeriod timePeriod;
    public final String resourceName;
    public final Supplier<Component> displayName;
    @NotNull
    public final RegistrySupplier<? extends EntityType<? extends Mob>> entitySupplier;
    public final int backgroundEggColor;
    public final int highlightEggColor;
    public final boolean bucketable;
    public Item dnaItem;
    public Item eggItem;
    public Item embryoItem;
    public Item birdEggItem;
    public Item cultivatedBirdEggItem;
    public Item armBoneItem;
    public Item footBoneItem;
    public Item legBoneItem;
    public Item ribcageBoneItem;
    public Item skullBoneItem;
    public Item tailBoneItem;
    public Item uniqueBoneItem;
    public Item vertebraeBoneItem;
    public Item foodItem;
    public Item cookedFoodItem;
    public Item spawnEggItem;
    public Item bucketItem;

    private PrehistoricEntityInfo(RegistrySupplier<? extends EntityType<? extends Mob>> entity, PrehistoricMobType mobType, TimePeriod timePeriod, int backgroundEggColor, int highlightEggColor) {
        this(entity, mobType, timePeriod, backgroundEggColor, highlightEggColor, EnumSet.noneOf(InfoFlag.class));
    }

    private PrehistoricEntityInfo(RegistrySupplier<? extends EntityType<? extends Mob>> entity, PrehistoricMobType mobType, TimePeriod timePeriod, int backgroundEggColor, int highlightEggColor, EnumSet<InfoFlag> flags) {
        this.entitySupplier = entity;
        this.mobType = mobType;
        this.timePeriod = timePeriod;
        this.resourceName = this.name().toLowerCase(Locale.ROOT);
        this.displayName = () -> new TranslatableComponent("entity.fossil." + this.resourceName);
        this.backgroundEggColor = backgroundEggColor;
        this.highlightEggColor = highlightEggColor;
        this.bucketable = flags.contains((Object)InfoFlag.BUCKETABLE);
    }

    public static void register() {
        for (PrehistoricEntityInfo info : PrehistoricEntityInfo.values()) {
            ModItems.ITEMS.register(info.resourceName + "_dna", () -> new DNAItem(info)).listen(item -> {
                info.dnaItem = item;
            });
            if (info.hasBones()) {
                DinoBoneItem.registerItem("bone_arm", info, item -> {
                    info.armBoneItem = item;
                });
                DinoBoneItem.registerItem("bone_foot", info, item -> {
                    info.footBoneItem = item;
                });
                DinoBoneItem.registerItem("bone_leg", info, item -> {
                    info.legBoneItem = item;
                });
                DinoBoneItem.registerItem("bone_ribcage", info, item -> {
                    info.ribcageBoneItem = item;
                });
                DinoBoneItem.registerItem("bone_skull", info, item -> {
                    info.skullBoneItem = item;
                });
                DinoBoneItem.registerItem("bone_tail", info, item -> {
                    info.tailBoneItem = item;
                });
                DinoBoneItem.registerItem("bone_unique", info, item -> {
                    info.uniqueBoneItem = item;
                });
                DinoBoneItem.registerItem("bone_vertebrae", info, item -> {
                    info.vertebraeBoneItem = item;
                });
            } else if (info == MEGALODON) {
                DinoBoneItem.registerItem("bone_unique", info, item -> {
                    info.uniqueBoneItem = item;
                });
            }
            if (info.mobType == PrehistoricMobType.FISH || info.mobType == PrehistoricMobType.DINOSAUR_FISH) {
                PrehistoricEntityInfo.registerItem("egg_item", info, properties -> new FishEggItem(info), item -> {
                    info.eggItem = item;
                });
            } else if (info.mobType == PrehistoricMobType.DINOSAUR || info.mobType == PrehistoricMobType.DINOSAUR_AQUATIC || info.mobType == PrehistoricMobType.ARTHROPOD) {
                PrehistoricEntityInfo.registerItem("egg_item", info, p -> new DinoEggItem(info), item -> {
                    info.eggItem = item;
                });
            } else if (info.mobType == PrehistoricMobType.MAMMAL) {
                PrehistoricEntityInfo.registerItem("syringe", info, properties -> new MammalEmbryoItem(info), item -> {
                    info.embryoItem = item;
                });
            } else if (info.mobType == PrehistoricMobType.BIRD) {
                PrehistoricEntityInfo.registerItem("egg", info, properties -> new BirdEggItem((EntityInfo)info, false), item -> {
                    info.birdEggItem = item;
                });
                PrehistoricEntityInfo.registerItem("egg_item", info, properties -> new BirdEggItem((EntityInfo)info, true), item -> {
                    info.cultivatedBirdEggItem = item;
                });
            }
            if (info == NAUTILUS) {
                PrehistoricEntityInfo.registerItem("meat", info, properties -> new NautilusMeatItem(info), item -> {
                    info.foodItem = item;
                });
                PrehistoricEntityInfo.registerItem("cooked", info, properties -> new NautilusMeatItem((EntityInfo)info, 2.0f), item -> {
                    info.cookedFoodItem = item;
                });
            } else {
                PrehistoricEntityInfo.registerItem("meat", info, properties -> new MeatItem((EntityInfo)info, false), item -> {
                    info.foodItem = item;
                });
                PrehistoricEntityInfo.registerItem("cooked", info, properties -> new MeatItem((EntityInfo)info, true), item -> {
                    info.cookedFoodItem = item;
                });
            }
            PrehistoricEntityInfo.registerItem("spawn_egg", info, properties -> new CustomSpawnEggItem(info), item -> {
                info.spawnEggItem = item;
            });
            if (!info.bucketable) continue;
            PrehistoricEntityInfo.registerItem("bucket_item", info, properties -> new ArchitecturyMobBucketItem(info.entitySupplier, () -> Fluids.f_76193_, () -> SoundEvents.f_11779_, new Item.Properties().m_41487_(1).m_41491_(ModTabs.FA_MOB_ITEM_TAB)), item -> {
                info.bucketItem = item;
            });
        }
    }

    private static void registerItem(String name, PrehistoricEntityInfo info, Function<Item.Properties, Item> item, Consumer<Item> listener) {
        ModItems.ITEMS.register(name + "_" + info.resourceName, () -> (Item)item.apply(new Item.Properties().m_41491_(ModTabs.FA_MOB_ITEM_TAB))).listen(listener);
    }

    public static List<PrehistoricEntityInfo> getTimePeriodList(TimePeriod ... periods) {
        return Arrays.stream(PrehistoricEntityInfo.values()).filter(info -> Arrays.stream(periods).anyMatch(timePeriod -> info.timePeriod == timePeriod)).toList();
    }

    public static List<PrehistoricEntityInfo> entitiesWithBones() {
        if (boneCache == null) {
            boneCache = Arrays.stream(PrehistoricEntityInfo.values()).filter(PrehistoricEntityInfo::hasBones).toList();
        }
        return boneCache;
    }

    public static List<PrehistoricEntityInfo> entitiesWithSkeleton(TimePeriod ... periods) {
        return Arrays.stream(PrehistoricEntityInfo.values()).filter(info -> {
            if (info.mobType == PrehistoricMobType.FISH || info == QUAGGA) {
                return false;
            }
            return Arrays.stream(periods).anyMatch(timePeriod -> timePeriod == info.timePeriod);
        }).toList();
    }

    public static boolean isMammal(Mob mob) {
        if (mob.m_6095_().m_204039_(ModEntityTypeTags.MAMMAL)) {
            return true;
        }
        String className = "";
        try {
            className = mob.getClass().getSimpleName();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return !className.isEmpty() && (mob instanceof AbstractHorse || className.contains("Cow") || className.contains("Sheep") || className.contains("Pig") || className.contains("Rabbit") || className.contains("Goat") || className.contains("Ferret") || className.contains("Hedgehog") || className.contains("Sow") || className.contains("Hog"));
    }

    @Override
    public EntityType<? extends Entity> entityType() {
        return (EntityType)this.entitySupplier.get();
    }

    @Override
    public PrehistoricMobType mobType() {
        return this.mobType;
    }

    @Override
    @Nullable
    public Item getDNAResult() {
        if (this.eggItem != null) {
            return this.eggItem;
        }
        if (this.embryoItem != null) {
            return this.embryoItem;
        }
        if (this.cultivatedBirdEggItem != null) {
            return this.cultivatedBirdEggItem;
        }
        return null;
    }

    @Override
    public Supplier<Component> displayName() {
        return this.displayName;
    }

    @Override
    public Item dnaItem() {
        return this.dnaItem;
    }

    public EntityDataLoader.Data data() {
        return EntityDataLoader.INSTANCE.getData(this.resourceName);
    }

    public boolean hasBones() {
        return this.timePeriod != TimePeriod.CURRENT && this.mobType != PrehistoricMobType.FISH && this.mobType != PrehistoricMobType.ARTHROPOD && this != MEGALODON && this != AQUILOLAMNA;
    }

    public boolean isViviparousAquatic() {
        return this.mobType == PrehistoricMobType.DINOSAUR_AQUATIC || this.mobType == PrehistoricMobType.ARTHROPOD;
    }
}

