/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.variant;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.variant.VariantCondition;
import com.github.teamfossilsarcheology.fossil.entity.variant.VariantRegistry;
import com.github.teamfossilsarcheology.fossil.util.Gender;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;

public record Variant(String variantId, String textureName, boolean hasBabyTexture, boolean hasTeenTexture, boolean hasGenderTextures, VariantCondition[] conditions) {
    public static Variant readBuf(FriendlyByteBuf buf) {
        VariantCondition[] conditions = new VariantCondition[buf.m_130242_()];
        for (int i = 0; i < conditions.length; ++i) {
            conditions[i] = VariantRegistry.fromNetwork(buf);
        }
        return new Variant(buf.m_130277_(), buf.m_130277_(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), conditions);
    }

    public static void writeBuf(FriendlyByteBuf buf, Variant variant) {
        buf.m_130130_(variant.conditions.length);
        for (VariantCondition condition : variant.conditions) {
            VariantRegistry.toNetwork(buf, condition);
        }
        buf.m_130070_(variant.variantId);
        buf.m_130070_(variant.textureName);
        buf.writeBoolean(variant.hasBabyTexture);
        buf.writeBoolean(variant.hasTeenTexture);
        buf.writeBoolean(variant.hasGenderTextures);
    }

    public void appendTextureString(StringBuilder builder, Prehistoric entity) {
        builder.append("_");
        builder.append(this.textureName);
        if (this.hasBabyTexture && entity.m_6162_()) {
            builder.append("_baby");
        }
        if (this.hasTeenTexture && entity.isTeen()) {
            builder.append("_teen");
        }
        if (this.hasGenderTextures && (!this.hasTeenTexture && entity.isTeen() || entity.isAdult())) {
            if (entity.getGender() == Gender.MALE) {
                builder.append("_male");
            } else {
                builder.append("_female");
            }
        }
    }

    public String getVariantId() {
        return this.variantId;
    }

    static class Deserializer
    implements JsonDeserializer<Variant> {
        Deserializer() {
        }

        public Variant deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject root = json.getAsJsonObject();
            String variantId = GsonHelper.m_13906_((JsonObject)root, (String)"variantId");
            String textureName = GsonHelper.m_13851_((JsonObject)root, (String)"textureName", (String)"");
            JsonArray conditionArray = GsonHelper.m_13832_((JsonObject)root, (String)"conditions", (JsonArray)new JsonArray());
            ArrayList<VariantCondition> conditions = new ArrayList<VariantCondition>();
            for (JsonElement condition : conditionArray) {
                try {
                    conditions.add(VariantCondition.deserialize(condition.getAsJsonObject()));
                }
                catch (JsonSyntaxException e) {
                    FossilMod.LOGGER.error("Could not parse {} condition for variant {}.", (Object)condition, (Object)variantId);
                }
            }
            boolean hasBabyTexture = GsonHelper.m_13855_((JsonObject)root, (String)"hasBabyTexture", (boolean)false);
            boolean hasTeenTexture = GsonHelper.m_13855_((JsonObject)root, (String)"hasTeenTexture", (boolean)false);
            boolean hasGenderTextures = GsonHelper.m_13855_((JsonObject)root, (String)"hasGenderTextures", (boolean)false);
            return new Variant(variantId, textureName, hasBabyTexture, hasTeenTexture, hasGenderTextures, (VariantCondition[])conditions.toArray(VariantCondition[]::new));
        }
    }
}

