/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.variant;

import com.github.teamfossilsarcheology.fossil.entity.variant.Variant;
import com.github.teamfossilsarcheology.fossil.entity.variant.VariantRegistry;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;

public abstract class VariantCondition {
    protected final double chance;

    protected VariantCondition(double chance) {
        this.chance = Mth.m_14008_((double)chance, (double)0.0, (double)1.0);
    }

    public static VariantCondition deserialize(JsonObject object) {
        if (!object.has("type")) {
            throw new JsonSyntaxException("Missing type entry");
        }
        String type = object.get("type").getAsString();
        return VariantRegistry.get(type).fromJson(object);
    }

    public static interface Serializer<T extends VariantCondition>
    extends JsonDeserializer<T> {
        public void save(CompoundTag var1, T var2);

        public T load(CompoundTag var1);

        public void toNetwork(FriendlyByteBuf var1, T var2);

        public T fromNetwork(FriendlyByteBuf var1);
    }

    public record WithVariant<T extends VariantCondition>(T condition, Variant variant) {
        public static <T extends VariantCondition> WithVariant<T> of(T condition, Variant variant) {
            return new WithVariant<T>(condition, variant);
        }
    }
}

