/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.event;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.advancements.ModTriggers;
import com.github.teamfossilsarcheology.fossil.block.ModBlocks;
import com.github.teamfossilsarcheology.fossil.capabilities.ModCapabilities;
import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.github.teamfossilsarcheology.fossil.entity.Quagga;
import com.github.teamfossilsarcheology.fossil.entity.ThrownBirdEgg;
import com.github.teamfossilsarcheology.fossil.entity.ai.AnimalFearGoal;
import com.github.teamfossilsarcheology.fossil.entity.monster.AnuBoss;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.EntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.VanillaEntityInfo;
import com.github.teamfossilsarcheology.fossil.food.FoodType;
import com.github.teamfossilsarcheology.fossil.item.MammalEmbryoItem;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import com.github.teamfossilsarcheology.fossil.recipe.ModRecipes;
import com.github.teamfossilsarcheology.fossil.sounds.ModSounds;
import com.github.teamfossilsarcheology.fossil.tags.ModEntityTypeTags;
import com.github.teamfossilsarcheology.fossil.world.dimension.ModDimensions;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import java.util.Locale;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class ModEvents {
    private static final Component ANU_BREAK_BLOCK = new TranslatableComponent("entity.fossil.anu.break_block");

    public static void init() {
        EntityEvent.ADD.register((entity, level) -> {
            PathfinderMob mob;
            if (entity instanceof PathfinderMob && ModEvents.isLivestock(mob = (PathfinderMob)entity) && FossilConfig.isEnabled("animalsFearDinos")) {
                mob.f_21345_.m_25352_(1, (Goal)new AnimalFearGoal(mob, Prehistoric.class, 12.0f, 1.15, 1.25, living -> {
                    Prehistoric prehistoric;
                    return living instanceof Prehistoric && (prehistoric = (Prehistoric)living).data().diet().canEat(FoodType.MEAT);
                }));
            }
            return EventResult.pass();
        });
        BlockEvent.BREAK.register((level, pos, state, player, xp) -> {
            if (level.m_46472_() == ModDimensions.ANU_LAIR && level instanceof ServerLevel) {
                AnuBoss.AnuLair anuLair;
                ServerLevel serverLevel = (ServerLevel)level;
                if (!(ModEvents.isBreakableInAnuLair(state) || player.m_7500_() || serverLevel.m_142572_().m_129944_(player.m_36316_()) >= serverLevel.m_142572_().m_7022_() || (anuLair = (AnuBoss.AnuLair)serverLevel.m_8895_().m_164858_(c -> new AnuBoss.AnuLair(), "anu_lair")) != null && anuLair.isAnuKilled())) {
                    player.m_5661_(ANU_BREAK_BLOCK, true);
                    return EventResult.interruptFalse();
                }
            }
            return EventResult.pass();
        });
        LifecycleEvent.SETUP.register(() -> {
            ModRecipes.initRecipes();
            for (PrehistoricEntityInfo prehistoricEntityInfo : PrehistoricEntityInfo.values()) {
                if (prehistoricEntityInfo.birdEggItem != null) {
                    DispenserBlock.m_52672_((ItemLike)prehistoricEntityInfo.birdEggItem, (DispenseItemBehavior)ThrownBirdEgg.getProjectile(prehistoricEntityInfo, false));
                }
                if (prehistoricEntityInfo.cultivatedBirdEggItem == null) continue;
                DispenserBlock.m_52672_((ItemLike)prehistoricEntityInfo.cultivatedBirdEggItem, (DispenseItemBehavior)ThrownBirdEgg.getProjectile(prehistoricEntityInfo, true));
            }
            for (Enum enum_ : VanillaEntityInfo.values()) {
                if (((VanillaEntityInfo)enum_).cultivatedBirdEggItem == null) continue;
                DispenserBlock.m_52672_((ItemLike)((VanillaEntityInfo)enum_).cultivatedBirdEggItem, (DispenseItemBehavior)ThrownBirdEgg.getProjectile((EntityInfo)((Object)enum_), true));
            }
            DispenserBlock.m_52672_((ItemLike)((ItemLike)ModItems.TAR_BUCKET.get()), (DispenseItemBehavior)new DefaultDispenseItemBehavior(){
                private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

                @NotNull
                public ItemStack m_7498_(BlockSource source, ItemStack stack) {
                    DispensibleContainerItem dispensibleContainerItem = (DispensibleContainerItem)ModItems.TAR_BUCKET.get();
                    BlockPos blockPos = source.m_7961_().m_142300_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                    if (dispensibleContainerItem.m_142073_(null, (Level)source.m_7727_(), blockPos, null)) {
                        dispensibleContainerItem.m_142131_(null, (Level)source.m_7727_(), stack, blockPos);
                        return new ItemStack((ItemLike)Items.f_42446_);
                    }
                    return this.defaultDispenseItemBehavior.m_6115_(source, stack);
                }
            });
        });
        InteractionEvent.INTERACT_ENTITY.register((player, entity, hand) -> {
            ItemStack stack = player.m_21120_(hand);
            Item patt6478$temp = stack.m_41720_();
            if (patt6478$temp instanceof MammalEmbryoItem) {
                Animal animal;
                MammalEmbryoItem embryoItem = (MammalEmbryoItem)patt6478$temp;
                if (entity instanceof Animal && PrehistoricEntityInfo.isMammal((Mob)(animal = (Animal)entity)) && !animal.m_6162_()) {
                    if (ModCapabilities.hasEmbryo(animal)) {
                        return EventResult.interruptFalse();
                    }
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        ModTriggers.IMPLANT_EMBRYO_TRIGGER.trigger(serverPlayer, stack);
                        ModCapabilities.startPregnancy(animal, embryoItem.getInfo());
                        if (!player.m_150110_().f_35937_) {
                            stack.m_41774_(1);
                        }
                    } else {
                        Random random = player.m_21187_();
                        for (int i = 0; i < 7; ++i) {
                            double x = animal.m_20185_() + (double)(random.nextFloat() * animal.m_20205_() * 2.0f) - (double)animal.m_20205_();
                            double y = animal.m_20186_() + 0.5 + (double)(random.nextFloat() * animal.m_20206_());
                            double z = animal.m_20189_() + (double)(random.nextFloat() * animal.m_20205_() * 2.0f) - (double)animal.m_20205_();
                            player.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, random.nextGaussian() * 0.02, random.nextGaussian() * 0.02, random.nextGaussian() * 0.02);
                        }
                    }
                    return EventResult.interruptTrue();
                }
            } else if (stack.m_150930_((Item)ModItems.WHIP.get())) {
                if (!player.f_19853_.f_46443_ && player.m_20159_() && player.m_20202_() == entity) {
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                    player.m_5496_((SoundEvent)ModSounds.WHIP.get(), 1.0f, 1.0f);
                    return EventResult.interruptTrue();
                }
                player.m_5496_((SoundEvent)ModSounds.WHIP.get(), 1.0f, 1.0f);
                return EventResult.pass();
            }
            return EventResult.pass();
        });
    }

    private static boolean isBreakableInAnuLair(BlockState state) {
        return state.m_60734_().m_7705_().toLowerCase(Locale.ROOT).contains("grave") || state.m_60713_((Block)ModBlocks.FAKE_OBSIDIAN.get()) || state.m_204336_(BlockTags.f_13076_);
    }

    private static boolean isLivestock(PathfinderMob mob) {
        if (mob.m_6095_().m_204039_(ModEntityTypeTags.LIVESTOCK)) {
            return true;
        }
        String className = "";
        try {
            className = mob.getClass().getSimpleName();
        }
        catch (Exception e) {
            FossilMod.LOGGER.debug(e.getMessage());
        }
        return !className.isEmpty() && (className.contains("Cow") || className.contains("Sheep") || className.contains("Pig") && !className.contains("piglin") || className.contains("Chicken") || className.contains("Rabbit") || className.contains("Peacock") || className.contains("Goat") || className.contains("Ferret") || className.contains("Hedgehog") || className.contains("Peahen") || className.contains("Peafowl") || className.contains("Sow") || className.contains("Hog"));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void growEntity(EntityInfo embryo, LivingEntity parent) {
        Entity newEntity;
        ServerLevel level;
        block17: {
            block15: {
                AbstractHorse newHorse;
                block16: {
                    Random random = parent.f_19853_.f_46441_;
                    if (parent.f_19853_.f_46443_) {
                        int i = 0;
                        while (true) {
                            if (i >= 7) {
                                return;
                            }
                            double d = random.nextGaussian() * 0.02;
                            double e = random.nextGaussian() * 0.02;
                            double f = random.nextGaussian() * 0.02;
                            parent.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123750_, parent.m_20208_(1.0), parent.m_20187_() + 0.5, parent.m_20262_(1.0), d, e, f);
                            ++i;
                        }
                    }
                    level = (ServerLevel)parent.f_19853_;
                    newEntity = embryo.entityType().m_20615_((Level)level);
                    int result = random.nextInt(100);
                    if (!(newEntity instanceof AbstractHorse)) break block15;
                    newHorse = (AbstractHorse)newEntity;
                    if (!(parent instanceof AbstractHorse)) break block16;
                    AbstractHorse parentHorse = (AbstractHorse)parent;
                    if (!parent.getClass().equals(newEntity.getClass())) break block16;
                    if (result < 10) {
                        if (parentHorse.m_30615_() != null) {
                            newHorse.m_30586_(parentHorse.m_30615_());
                            newHorse.m_30651_(true);
                        }
                        break block17;
                    } else {
                        newEntity = parentHorse.m_142606_(level, (AgeableMob)parentHorse);
                    }
                    break block17;
                }
                newHorse.m_6518_((ServerLevelAccessor)level, level.m_6436_(newHorse.m_142538_()), MobSpawnType.BREEDING, null, null);
                break block17;
            }
            if (newEntity instanceof Quagga) {
                Quagga newQuagga = (Quagga)newEntity;
                double health = parent.m_21051_(Attributes.f_22276_).m_22115_() + newQuagga.m_21051_(Attributes.f_22276_).m_22115_() + newQuagga.m_21051_(Attributes.f_22276_).m_22115_();
                newQuagga.m_21051_(Attributes.f_22276_).m_22100_(health / 3.0);
                double speed = parent.m_21051_(Attributes.f_22279_).m_22115_() + newQuagga.m_21051_(Attributes.f_22279_).m_22115_() + newQuagga.m_21051_(Attributes.f_22279_).m_22115_();
                newQuagga.m_21051_(Attributes.f_22279_).m_22100_(speed / 3.0);
            } else if (newEntity instanceof AgeableMob) {
                AgeableMob ageableMob = (AgeableMob)newEntity;
                if (parent.getClass().equals(newEntity.getClass())) {
                    newEntity = ((AgeableMob)parent).m_142606_(level, (AgeableMob)parent);
                } else {
                    ageableMob.m_6518_((ServerLevelAccessor)level, level.m_6436_(parent.m_142538_()), MobSpawnType.BREEDING, null, null);
                }
            }
        }
        if (newEntity instanceof Prehistoric) {
            Prehistoric prehistoric = (Prehistoric)newEntity;
            Player player = level.m_45930_((Entity)parent, 15.0);
            if (player != null) {
                prehistoric.m_21828_(player);
            }
            prehistoric.setAgeInDays(0);
        } else if (newEntity instanceof Animal) {
            ((Animal)newEntity).m_6863_(true);
        }
        newEntity.m_7678_(parent.m_20185_(), parent.m_20186_(), parent.m_20189_(), parent.m_146908_(), parent.m_146909_());
        level.m_7967_(newEntity);
    }
}

