/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.food;

import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.github.teamfossilsarcheology.fossil.food.Diet;
import com.github.teamfossilsarcheology.fossil.food.FoodMappingsManager;
import com.github.teamfossilsarcheology.fossil.food.FoodType;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public abstract class FoodMappings {
    public static int getFoodAmount(ItemLike itemLike, FoodType diet) {
        return FoodMappingsManager.INSTANCE.getItemValues(diet).getOrDefault(itemLike.m_5456_(), 0);
    }

    public static int getFoodAmount(ItemLike itemLike, Diet diet) {
        Set<FoodType> valid = diet.flags();
        for (FoodType type : valid) {
            if (!FoodMappingsManager.INSTANCE.getItemValues(type).containsKey(itemLike.m_5456_())) continue;
            return FoodMappingsManager.INSTANCE.getItemValues(type).get(itemLike.m_5456_());
        }
        return 0;
    }

    public static int getMobFoodPoints(LivingEntity entity, Diet diet) {
        String namespace;
        if (entity == null) {
            return 0;
        }
        EntityType entityType = entity.m_6095_();
        if (!(FossilConfig.isEnabled("dinosEatModdedMobs") || (namespace = Registry.f_122826_.m_7981_((Object)entityType).m_135827_()).equals("fossil") || namespace.equals("minecraft"))) {
            return 0;
        }
        Set<FoodType> valid = diet.flags();
        if (FoodMappingsManager.INSTANCE.hasEntityEntry(entityType)) {
            for (FoodType type1 : valid) {
                if (!FoodMappingsManager.INSTANCE.getEntityValues(type1).containsKey(entityType)) continue;
                int mappingPoints = FoodMappingsManager.INSTANCE.getEntityValues(type1).get(entityType);
                if (mappingPoints > 0) {
                    float scale = entity.m_20205_() / entityType.m_20680_().f_20377_ * entity.m_20206_() / entityType.m_20680_().f_20378_;
                    return Math.round((float)mappingPoints * scale);
                }
                return Math.round(entity.m_20205_() * entity.m_20206_() * 10.0f);
            }
        } else {
            if (valid.contains((Object)FoodType.MEAT) && entity instanceof Animal && !FoodMappings.isAquaticMob(entity)) {
                return Math.round(entity.m_20205_() * entity.m_20206_() * 10.0f);
            }
            if (valid.contains((Object)FoodType.FISH) && FoodMappings.isAquaticMob(entity)) {
                return Math.round(entity.m_20205_() * entity.m_20206_() * 10.0f);
            }
            return 0;
        }
        return 0;
    }

    private static boolean isAquaticMob(LivingEntity entity) {
        Mob mob;
        return entity.m_6040_() || entity instanceof WaterAnimal || entity instanceof Mob && (mob = (Mob)entity).m_21573_() instanceof WaterBoundPathNavigation;
    }

    public static void addMeat(EntityType<?> entity, int food) {
        FoodMappingsManager.INSTANCE.addEntity(FoodType.MEAT, entity, food);
    }

    public static void addMeat(ItemLike itemLike) {
        int food = itemLike.m_5456_().m_41473_() != null ? itemLike.m_5456_().m_41473_().m_38744_() * 7 : 20;
        FoodMappings.addMeat(itemLike, food);
    }

    public static void addMeat(ItemLike itemLike, int food) {
        FoodMappingsManager.INSTANCE.addItem(FoodType.MEAT, itemLike.m_5456_(), food);
    }

    public static void addFish(EntityType<?> entity, int food) {
        FoodMappingsManager.INSTANCE.addEntity(FoodType.FISH, entity, food);
    }

    public static void addFish(Item item) {
        int food = item.m_41473_() != null ? item.m_41473_().m_38744_() * 7 : 10;
        FoodMappings.addFish(item, food);
    }

    public static void addFish(Item item, int food) {
        FoodMappingsManager.INSTANCE.addItem(FoodType.FISH, item, food);
    }

    public static void addEgg(Item item) {
        int food = item.m_41473_() != null ? item.m_41473_().m_38744_() * 7 : 15;
        FoodMappings.addEgg(item, food);
    }

    public static void addEgg(Item item, int food) {
        FoodMappingsManager.INSTANCE.addItem(FoodType.EGG, item, food);
    }

    public static void addPlant(Block block, int food) {
        FoodMappingsManager.INSTANCE.addItem(FoodType.PLANT, block.m_5456_(), food);
    }

    public static void addPlant(Item item) {
        int food = item.m_41473_() != null ? item.m_41473_().m_38744_() * 5 : 17;
        FoodMappings.addPlant(item, food);
    }

    public static void addPlant(Item item, int food) {
        FoodMappingsManager.INSTANCE.addItem(FoodType.PLANT, item, food);
    }
}

