/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.food;

import com.github.teamfossilsarcheology.fossil.food.FoodType;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import org.slf4j.Logger;

public abstract class FoodValueProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator generator;
    protected final boolean keepOldFiles;
    private final Path basePath;
    protected Map<FoodType, FoodAppender> builders;

    protected FoodValueProvider(DataGenerator generator, boolean keepOldFiles) {
        this.generator = generator;
        this.keepOldFiles = keepOldFiles;
        this.basePath = generator.m_123916_().resolve("data/fossil/food");
        this.builders = Arrays.stream(FoodType.values()).collect(Collectors.toMap(Function.identity(), type -> new FoodAppender()));
    }

    private Path getPath(FoodType type) {
        return this.basePath.resolve(type.name().toLowerCase(Locale.ENGLISH) + ".json");
    }

    public void m_6865_(HashCache cache) throws IOException {
        this.buildFoodValues();
        if (this.keepOldFiles) {
            cache.f_123930_.entrySet().stream().filter(entry -> ((Path)entry.getKey()).startsWith(this.basePath)).forEach(entry -> cache.m_123940_((Path)entry.getKey(), (String)entry.getValue()));
        }
        this.builders.forEach((type, foodAppender) -> {
            Path path = this.getPath((FoodType)((Object)type));
            if (foodAppender.items.isEmpty() && foodAppender.entities.isEmpty()) {
                if (this.keepOldFiles && cache.f_123930_.containsKey(path)) {
                    cache.m_123940_(path, (String)cache.f_123930_.get(path));
                }
                return;
            }
            JsonObject jsonobject = foodAppender.serializeToJson();
            try {
                String jsonString = GSON.toJson((JsonElement)jsonobject);
                String hash = f_123918_.hashUnencodedChars((CharSequence)jsonString).toString();
                if (!Objects.equals(cache.m_123938_(path), hash) || !Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                        bufferedWriter.write(jsonString);
                    }
                }
                cache.m_123940_(path, hash);
            }
            catch (IOException var14) {
                LOGGER.error("Couldn't save food values to {}", (Object)path, (Object)var14);
            }
        });
    }

    protected abstract void buildFoodValues();

    protected FoodAppender type(FoodType type) {
        return this.builders.get((Object)type);
    }

    protected static class FoodAppender {
        private final List<Entry> items = new ObjectArrayList();
        private final List<Entry> entities = new ObjectArrayList();

        public void itemTag(TagKey<Item> tag) {
            this.items.add(new Entry(tag.f_203868_(), -1, "tag"));
        }

        public void item(ItemLike item) {
            this.item(item, -1);
        }

        public void item(ItemLike item, int value) {
            this.items.add(new Entry(Registry.f_122827_.m_7981_((Object)item.m_5456_()), value, "item"));
        }

        public void entityTag(TagKey<EntityType<?>> tag) {
            this.entities.add(new Entry(tag.f_203868_(), -1, "tag"));
        }

        public void entity(EntityType<?> entityType) {
            this.entity(entityType, -1);
        }

        public void entity(EntityType<?> entityType, int value) {
            this.entity(Registry.f_122826_.m_7981_(entityType), value);
        }

        public void entity(ResourceLocation location, int value) {
            this.entities.add(new Entry(location, value, "entity"));
        }

        public JsonObject serializeToJson() {
            JsonObject root = new JsonObject();
            JsonArray itemArray = new JsonArray();
            JsonArray entityArray = new JsonArray();
            root.add("items", (JsonElement)itemArray);
            root.add("entities", (JsonElement)entityArray);
            this.items.stream().sorted(FoodAppender::compare).forEach(entry -> itemArray.add((JsonElement)entry.serialize()));
            this.entities.stream().sorted(FoodAppender::compare).forEach(entry -> entityArray.add((JsonElement)entry.serialize()));
            return root;
        }

        private static int compare(Entry one, Entry other) {
            int i = one.id.m_135827_().compareTo(other.id.m_135827_());
            if (i == 0) {
                i = one.id.m_135815_().compareTo(other.id.m_135815_());
            }
            return i;
        }

        private record Entry(ResourceLocation id, int value, String key) {
            public JsonObject serialize() {
                JsonObject object = new JsonObject();
                object.addProperty(this.key, this.id.toString());
                if (this.value >= 0) {
                    object.addProperty("value", (Number)this.value);
                }
                return object;
            }
        }
    }
}

