/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.forge.data.loot;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.entity.ModEntities;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricMobType;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import com.github.teamfossilsarcheology.fossil.loot.CustomizeToDinoFunction;
import java.util.List;
import net.minecraft.data.loot.EntityLoot;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.jetbrains.annotations.NotNull;

public class ModEntityLootTables
extends EntityLoot {
    protected void addTables() {
        for (PrehistoricEntityInfo info : PrehistoricEntityInfo.values()) {
            LootPoolSingletonContainer.Builder meat;
            if (info.hasBones()) {
                this.m_124380_(FossilMod.location("entities/" + info.resourceName), this.defaultLoot(info));
                continue;
            }
            if (info.uniqueBoneItem != null) {
                meat = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)info.foodItem).m_5577_(CustomizeToDinoFunction.apply(LootContext.EntityTarget.THIS)).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))));
                LootPool.Builder unique = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)info.uniqueBoneItem).m_79707_(50)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(50));
                this.m_124380_(FossilMod.location("entities/" + info.resourceName), LootTable.m_79147_().m_79161_((LootPool.Builder)meat).m_79161_(unique));
                continue;
            }
            if (info.foodItem == null) continue;
            meat = LootItem.m_79579_((ItemLike)info.foodItem).m_5577_(CustomizeToDinoFunction.apply(LootContext.EntityTarget.THIS));
            if (info.mobType != PrehistoricMobType.FISH) {
                meat = meat.m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f)));
            }
            this.m_124380_(FossilMod.location("entities/" + info.resourceName), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)meat)));
        }
        LootPool.Builder wool = this.uniformLoot(Items.f_41935_, 6, 8);
        this.m_124380_(FossilMod.location("entities/" + PrehistoricEntityInfo.MAMMOTH.resourceName), this.defaultLoot(PrehistoricEntityInfo.MAMMOTH).m_79161_(wool));
        LootPool.Builder shell = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)PrehistoricEntityInfo.NAUTILUS.foodItem).m_79707_(95)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.MAGIC_CONCH.get())).m_79707_(5));
        this.m_124380_(FossilMod.location("entities/" + PrehistoricEntityInfo.NAUTILUS.resourceName), LootTable.m_79147_().m_79161_(shell));
        this.m_124371_((EntityType)ModEntities.FAILURESAURUS.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.FAILURESAURUS_FLESH.get())))));
    }

    private LootTable.Builder defaultLoot(PrehistoricEntityInfo info) {
        LootPool.Builder meat = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)info.foodItem).m_5577_(CustomizeToDinoFunction.apply(LootContext.EntityTarget.THIS)).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))));
        LootPool.Builder arm = this.uniformLoot(info.armBoneItem, 0, 2);
        LootPool.Builder foot = this.uniformLoot(info.footBoneItem, 0, 2);
        LootPool.Builder leg = this.uniformLoot(info.legBoneItem, 0, 2);
        LootPool.Builder rib = this.uniformLoot(info.ribcageBoneItem, 0, 1);
        LootPool.Builder skull = this.uniformLoot(info.skullBoneItem, 0, 1);
        LootPool.Builder tail = this.uniformLoot(info.tailBoneItem, 0, 1);
        LootPool.Builder unique = this.uniformLoot(info.uniqueBoneItem, 0, 2);
        LootPool.Builder vertebrae = this.uniformLoot(info.vertebraeBoneItem, 0, 5);
        return LootTable.m_79147_().m_79161_(meat).m_79161_(arm).m_79161_(foot).m_79161_(leg).m_79161_(rib).m_79161_(skull).m_79161_(tail).m_79161_(unique).m_79161_(vertebrae);
    }

    private LootPool.Builder uniformLoot(Item item, int min, int max) {
        return LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max))));
    }

    @NotNull
    protected Iterable<EntityType<?>> getKnownEntities() {
        return List.of();
    }
}

