/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.forge.data.loot;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.block.ModBlocks;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import com.github.teamfossilsarcheology.fossil.tags.ModItemTags;
import com.google.common.collect.Maps;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.DynamicLoot;
import net.minecraft.world.level.storage.loot.entries.EntryGroup;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class ModGenericLootTables
implements Consumer<BiConsumer<ResourceLocation, LootTable.Builder>> {
    private final Map<ResourceLocation, LootTable.Builder> map = Maps.newHashMap();
    private int scarab;
    private int broken;
    private int skullBlock;
    private int mobFossil;
    private Item mobFossilItem;
    private int plantFossil;
    private int relic;
    private int bone;

    protected void addTables() {
        EntryGroup.Builder defaultList = this.scarab(1).broken(5).skullBlock(34).mobFossil(ModItems.BIO_FOSSIL, 275).plant(110).relic(200).bone(440).group(6, 6, 3, 3, 3, 3, 3, 3);
        EntryGroup.Builder archList1 = this.scarab(6).broken(9).skullBlock(64).mobFossil(ModItems.BIO_FOSSIL, 225).plant(85).relic(475).bone(200).group(3, 3, 3, 3, 3, 3, 3, 3);
        EntryGroup.Builder archList2 = this.scarab(11).broken(11).skullBlock(110).mobFossil(ModItems.BIO_FOSSIL, 132).plant(50).relic(715).bone(36).group(3, 3, 3, 3, 3, 3, 3, 3);
        EntryGroup.Builder archList3 = this.scarab(16).broken(13).skullBlock(144).mobFossil(ModItems.BIO_FOSSIL, 50).plant(20).relic(820).bone(0).group(3, 3, 3, 3, 3, 3, 3, 3);
        EntryGroup.Builder paleList1 = this.scarab(1).broken(5).skullBlock(55).mobFossil(ModItems.BIO_FOSSIL, 375).plant(145).relic(20).bone(440).group(9, 9, 6, 6, 6, 6, 6, 6);
        EntryGroup.Builder paleList2 = this.scarab(1).broken(5).skullBlock(30).mobFossil(ModItems.BIO_FOSSIL, 470).plant(175).relic(0).bone(326).group(13, 13, 10, 10, 12, 10, 10, 10);
        EntryGroup.Builder paleList3 = this.scarab(1).broken(5).skullBlock(36).mobFossil(ModItems.BIO_FOSSIL, 510).plant(205).relic(0).bone(210).group(18, 18, 15, 15, 17, 15, 15, 15);
        this.map.put(FossilMod.location("regular_fossil"), this.basic((LootPoolEntryContainer.Builder<?>)defaultList));
        this.map.put(FossilMod.location("regular_fossil_arch_1"), this.basic((LootPoolEntryContainer.Builder<?>)archList1));
        this.map.put(FossilMod.location("regular_fossil_arch_2"), this.basic((LootPoolEntryContainer.Builder<?>)archList2));
        this.map.put(FossilMod.location("regular_fossil_arch_3"), this.basic((LootPoolEntryContainer.Builder<?>)archList3));
        this.map.put(FossilMod.location("regular_fossil_paleo_1"), this.basic((LootPoolEntryContainer.Builder<?>)paleList1));
        this.map.put(FossilMod.location("regular_fossil_paleo_2"), this.basic((LootPoolEntryContainer.Builder<?>)paleList2));
        this.map.put(FossilMod.location("regular_fossil_paleo_3"), this.basic((LootPoolEntryContainer.Builder<?>)paleList3));
        defaultList = this.scarab(1).broken(5).skullBlock(34).mobFossil(ModItems.SHALE_FOSSIL, 300).plant(85).relic(200).bone(440).group(new int[0]);
        archList1 = this.scarab(6).broken(9).skullBlock(64).mobFossil(ModItems.SHALE_FOSSIL, 255).plant(55).relic(475).bone(200).group(new int[0]);
        archList2 = this.scarab(11).broken(11).skullBlock(80).mobFossil(ModItems.SHALE_FOSSIL, 192).plant(20).relic(715).bone(36).group(new int[0]);
        archList3 = this.scarab(16).broken(13).skullBlock(110).mobFossil(ModItems.SHALE_FOSSIL, 120).plant(0).relic(820).bone(0).group(new int[0]);
        paleList1 = this.scarab(1).broken(5).skullBlock(55).mobFossil(ModItems.SHALE_FOSSIL, 405).plant(115).relic(20).bone(440).group(new int[0]);
        paleList2 = this.scarab(1).broken(5).skullBlock(30).mobFossil(ModItems.SHALE_FOSSIL, 480).plant(175).relic(0).bone(326).group(new int[0]);
        paleList3 = this.scarab(1).broken(5).skullBlock(36).mobFossil(ModItems.SHALE_FOSSIL, 540).plant(200).relic(0).bone(210).group(new int[0]);
        this.map.put(FossilMod.location("deep_fossil"), this.basic((LootPoolEntryContainer.Builder<?>)defaultList));
        this.map.put(FossilMod.location("deep_fossil_arch_1"), this.basic((LootPoolEntryContainer.Builder<?>)archList1));
        this.map.put(FossilMod.location("deep_fossil_arch_2"), this.basic((LootPoolEntryContainer.Builder<?>)archList2));
        this.map.put(FossilMod.location("deep_fossil_arch_3"), this.basic((LootPoolEntryContainer.Builder<?>)archList3));
        this.map.put(FossilMod.location("deep_fossil_paleo_1"), this.basic((LootPoolEntryContainer.Builder<?>)paleList1));
        this.map.put(FossilMod.location("deep_fossil_paleo_2"), this.basic((LootPoolEntryContainer.Builder<?>)paleList2));
        this.map.put(FossilMod.location("deep_fossil_paleo_3"), this.basic((LootPoolEntryContainer.Builder<?>)paleList3));
    }

    @Override
    public void accept(BiConsumer<ResourceLocation, LootTable.Builder> biConsumer) {
        this.addTables();
        for (Map.Entry<ResourceLocation, LootTable.Builder> entry : this.map.entrySet()) {
            biConsumer.accept(entry.getKey(), entry.getValue());
        }
    }

    private LootTable.Builder basic(LootPoolEntryContainer.Builder<?> builder) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(builder));
    }

    private ModGenericLootTables scarab(int weight) {
        this.scarab = weight;
        return this;
    }

    private ModGenericLootTables broken(int weight) {
        this.broken = weight;
        return this;
    }

    private ModGenericLootTables skullBlock(int weight) {
        this.skullBlock = weight;
        return this;
    }

    private ModGenericLootTables relic(int weight) {
        this.relic = weight;
        return this;
    }

    private ModGenericLootTables mobFossil(RegistrySupplier<Item> fossil, int weight) {
        this.mobFossilItem = (Item)fossil.get();
        this.mobFossil = weight;
        return this;
    }

    private ModGenericLootTables plant(int weight) {
        this.plantFossil = weight;
        return this;
    }

    private ModGenericLootTables bone(int weight) {
        this.bone = weight;
        return this;
    }

    private EntryGroup.Builder group(int ... weights) {
        EntryGroup.Builder builder = EntryGroup.m_165137_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{this.lootItem((ItemLike)ModItems.SCARAB_GEM.get(), this.scarab), this.lootItem((ItemLike)ModItems.BROKEN_SWORD.get(), this.broken), this.lootItem((ItemLike)ModItems.BROKEN_HELMET.get(), this.broken), this.lootItem((ItemLike)ModBlocks.SKULL_BLOCK.get(), this.skullBlock), this.lootItem((ItemLike)this.mobFossilItem, this.mobFossil), this.lootItem((ItemLike)ModItems.RELIC_SCRAP.get(), this.relic), this.lootItem((ItemLike)Items.f_42500_, this.bone), this.lootItem((ItemLike)ModItems.PlANT_FOSSIL.get(), this.plantFossil)});
        if (weights.length == 8) {
            builder.m_142719_((LootPoolEntryContainer.Builder)DynamicLoot.m_79483_((ResourceLocation)ModItemTags.LEG_BONES.f_203868_()).m_79707_(weights[0]));
            builder.m_142719_((LootPoolEntryContainer.Builder)DynamicLoot.m_79483_((ResourceLocation)ModItemTags.ARM_BONES.f_203868_()).m_79707_(weights[1]));
            builder.m_142719_((LootPoolEntryContainer.Builder)DynamicLoot.m_79483_((ResourceLocation)ModItemTags.FOOT_BONES.f_203868_()).m_79707_(weights[2]));
            builder.m_142719_((LootPoolEntryContainer.Builder)DynamicLoot.m_79483_((ResourceLocation)ModItemTags.SKULL_BONES.f_203868_()).m_79707_(weights[3]));
            builder.m_142719_((LootPoolEntryContainer.Builder)DynamicLoot.m_79483_((ResourceLocation)ModItemTags.RIBCAGE_BONES.f_203868_()).m_79707_(weights[4]));
            builder.m_142719_((LootPoolEntryContainer.Builder)DynamicLoot.m_79483_((ResourceLocation)ModItemTags.VERTEBRAE_BONES.f_203868_()).m_79707_(weights[5]));
            builder.m_142719_((LootPoolEntryContainer.Builder)DynamicLoot.m_79483_((ResourceLocation)ModItemTags.UNIQUE_BONES.f_203868_()).m_79707_(weights[6]));
            builder.m_142719_((LootPoolEntryContainer.Builder)DynamicLoot.m_79483_((ResourceLocation)ModItemTags.TAIL_BONES.f_203868_()).m_79707_(weights[7]));
        }
        return builder;
    }

    private LootPoolSingletonContainer.Builder<?> lootItem(ItemLike item, int weight) {
        return LootItem.m_79579_((ItemLike)item).m_79707_(weight);
    }
}

