/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.inventory;

import com.github.teamfossilsarcheology.fossil.inventory.ModMenus;
import com.github.teamfossilsarcheology.fossil.recipe.CultureVatRecipe;
import com.github.teamfossilsarcheology.fossil.recipe.ModRecipes;
import com.github.teamfossilsarcheology.fossil.recipe.WithFuelRecipe;
import com.github.teamfossilsarcheology.fossil.util.Version;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CultureVatMenu
extends AbstractContainerMenu {
    public static final int INPUT_SLOT_ID = 0;
    public static final int FUEL_SLOT_ID = 1;
    public static final int OUTPUT_SLOT_ID = 2;
    public static final int CULTIVATION_DURATION = Version.debugEnabled() ? 100 : 6000;
    private final Container container;
    private final ContainerData containerData;
    private final Level level;

    public CultureVatMenu(int id, Inventory playerInventory) {
        this(id, playerInventory, (Container)new SimpleContainer(3), (ContainerData)new SimpleContainerData(4));
    }

    public CultureVatMenu(int id, Inventory playerInventory, Container container, ContainerData containerData) {
        super((MenuType)ModMenus.CULTURE_VAT.get(), id);
        this.container = container;
        this.containerData = containerData;
        this.level = playerInventory.f_35978_.f_19853_;
        this.m_38897_(new Slot(container, 0, 45, 21){

            public boolean m_5857_(ItemStack stack) {
                return super.m_5857_(stack) && CultureVatMenu.this.canPutStackInInput(stack);
            }
        });
        this.m_38897_(new Slot(container, 1, 80, 54){

            public boolean m_5857_(ItemStack stack) {
                return super.m_5857_(stack) && CultureVatMenu.getItemFuelTime(stack) > 0;
            }
        });
        this.m_38897_(new Slot(container, 2, 115, 21){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        });
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)playerInventory, x + y * 9 + 9, 8 + x * 18, 84 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)playerInventory, x, 8 + x * 18, 142));
        }
        this.m_38884_(containerData);
    }

    public static int getItemFuelTime(ItemStack stack) {
        return 40;
    }

    public boolean canPutStackInInput(ItemStack stack) {
        if (stack != null && !stack.m_41619_()) {
            CultureVatRecipe recipe = ModRecipes.getCultureVatRecipeForItem(new WithFuelRecipe.ContainerWithAnyFuel(true, stack), this.level);
            return recipe != null;
        }
        return false;
    }

    @NotNull
    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack current = slot.m_7993_();
            itemStack = current.m_41777_();
            int inventorySlots = 36;
            int worktableSlots = 3;
            int bottomRowEnd = 39;
            int bottomRowStart = 30;
            if (index == 2 ? !this.m_38903_(current, 3, 39, true) : (index == 0 || index == 1 ? !this.m_38903_(current, 3, 39, false) : (ModRecipes.getCultureVatRecipeForItem(new WithFuelRecipe.ContainerWithAnyFuel(true, itemStack), player.f_19853_) != null ? !this.m_38903_(current, 0, 1, false) : (ModRecipes.isCultureVatFuel((ItemLike)current.m_41720_()) ? !this.m_38903_(current, 1, 2, false) : (index < 30 ? !this.m_38903_(current, 30, 39, false) : index < 39 && !this.m_38903_(current, 3, 30, false)))))) {
                return ItemStack.f_41583_;
            }
            if (current.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (current.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, current);
        }
        return itemStack;
    }

    public int getFuelTime() {
        return this.containerData.m_6413_(0);
    }

    public int getTotalFuelTime() {
        return this.containerData.m_6413_(1);
    }

    public int getCultivationTime() {
        return this.containerData.m_6413_(2);
    }

    public int getStoredEnergy() {
        return this.containerData.m_6413_(3);
    }

    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }
}

