/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.item;

import com.github.teamfossilsarcheology.fossil.client.particle.ModParticles;
import com.github.teamfossilsarcheology.fossil.entity.LaserPointEntity;
import com.github.teamfossilsarcheology.fossil.entity.ModEntities;
import java.util.UUID;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class LaserPointerItem
extends Item {
    private static final double LASER_RANGE = 50.0;
    private static final String TAG_LASER_ENTITY_UUID = "LaserEntityUUID";
    private static final String TAG_USE_START_TIME = "UseStartTime";
    private static final float LASER_ACTIVE_LIFESPAN_MINUTES = 15.0f;

    public LaserPointerItem(Item.Properties properties) {
        super(properties.m_41503_(900));
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.m_5776_()) {
            LaserPointEntity laserPoint = new LaserPointEntity((EntityType<? extends LivingEntity>)((EntityType)ModEntities.LASER_POINT.get()), level);
            laserPoint.setOwner(player);
            laserPoint.m_6034_(player.m_20185_(), player.m_20188_(), player.m_20189_());
            level.m_7967_((Entity)laserPoint);
            stack.m_41784_().m_128362_(TAG_LASER_ENTITY_UUID, laserPoint.m_142081_());
            stack.m_41784_().m_128356_(TAG_USE_START_TIME, level.m_46467_());
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity living, int timeCharged) {
        if (!level.m_5776_() && living instanceof Player) {
            CompoundTag tag = stack.m_41783_();
            if (tag != null && tag.m_128403_(TAG_LASER_ENTITY_UUID)) {
                UUID entityUUID = tag.m_128342_(TAG_LASER_ENTITY_UUID);
                Entity entity = ((ServerLevel)level).m_8791_(entityUUID);
                if (entity instanceof LaserPointEntity) {
                    entity.m_146870_();
                }
                tag.m_128473_(TAG_LASER_ENTITY_UUID);
            }
            if (tag != null && tag.m_128441_(TAG_USE_START_TIME)) {
                long startTime = tag.m_128454_(TAG_USE_START_TIME);
                long useDuration = level.m_46467_() - startTime;
                int damageToApply = (int)(useDuration / 20L);
                if (damageToApply > 0) {
                    stack.m_41622_(damageToApply, living, p -> p.m_21190_(living.m_7655_()));
                }
                tag.m_128473_(TAG_USE_START_TIME);
            }
        }
    }

    public void m_5929_(Level level, LivingEntity living, ItemStack stack, int remainingUseDuration) {
        Entity entity;
        CompoundTag tag;
        CompoundTag tag2;
        if (!(living instanceof Player)) {
            return;
        }
        Player player = (Player)living;
        if (!level.m_5776_() && level.m_46467_() % 20L == 0L && (tag2 = stack.m_41783_()) != null && tag2.m_128441_(TAG_USE_START_TIME)) {
            long startTime = tag2.m_128454_(TAG_USE_START_TIME);
            long useDuration = level.m_46467_() - startTime;
            int damageToApply = (int)(useDuration / 20L);
            if (stack.m_41773_() + damageToApply >= stack.m_41776_()) {
                UUID entityUUID;
                Entity entity2;
                player.m_5810_();
                player.m_21190_(player.m_7655_());
                stack.m_41774_(1);
                if (tag2.m_128403_(TAG_LASER_ENTITY_UUID) && (entity2 = ((ServerLevel)level).m_8791_(entityUUID = tag2.m_128342_(TAG_LASER_ENTITY_UUID))) instanceof LaserPointEntity) {
                    entity2.m_146870_();
                }
                return;
            }
        }
        Vec3 eyePos = player.m_20299_(1.0f);
        Vec3 lookVec = player.m_20154_();
        Vec3 endVec = eyePos.m_82549_(lookVec.m_82490_(50.0));
        BlockHitResult hit = level.m_45547_(new ClipContext(eyePos, endVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        Vec3 hitPos = hit.m_82450_();
        if (!level.m_5776_() && (tag = stack.m_41783_()) != null && tag.m_128403_(TAG_LASER_ENTITY_UUID) && (entity = ((ServerLevel)level).m_8791_(tag.m_128342_(TAG_LASER_ENTITY_UUID))) instanceof LaserPointEntity) {
            LaserPointEntity laserPoint = (LaserPointEntity)entity;
            laserPoint.updatePosition(hitPos.m_7096_(), hitPos.m_7098_(), hitPos.m_7094_());
        }
        if (level.f_46443_ && hit.m_6662_() == HitResult.Type.BLOCK) {
            Vec3 normal = Vec3.m_82528_((Vec3i)hit.m_82434_().m_122436_());
            this.spawnLaserParticles(level, hitPos.m_82549_(normal.m_82490_((double)0.06f)), 3);
        }
    }

    private void spawnLaserParticles(Level level, Vec3 pos, int count) {
        for (int i = 0; i < count; ++i) {
            double x = pos.f_82479_ + (level.f_46441_.nextDouble() - 0.5) * 0.05;
            double y = pos.f_82480_ + (level.f_46441_.nextDouble() - 0.5) * 0.05;
            double z = pos.f_82481_ + (level.f_46441_.nextDouble() - 0.5) * 0.05;
            level.m_6493_((ParticleOptions)ModParticles.LASER_PARTICLE.get(), true, x, y, z, 0.0, 0.0, 0.0);
        }
    }
}

