/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.material;

import com.github.teamfossilsarcheology.fossil.client.particle.ModParticles;
import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.github.teamfossilsarcheology.fossil.entity.ModEntities;
import com.github.teamfossilsarcheology.fossil.entity.monster.TarSlime;
import com.github.teamfossilsarcheology.fossil.sounds.ModSounds;
import dev.architectury.core.fluid.ArchitecturyFlowingFluid;
import dev.architectury.core.fluid.ArchitecturyFluidAttributes;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;

public class TarFluid {
    private static void animateParticle(Level level, BlockPos pos, FluidState state, Random random) {
        if (random.nextInt(5) == 0 && level.m_46859_(pos.m_7494_())) {
            double posX = (double)pos.m_123341_() + random.nextDouble();
            double posY = (double)pos.m_123342_() + 1.0;
            double posZ = (double)pos.m_123343_() + random.nextDouble();
            double speedX = (random.nextDouble() - 0.5) * 0.3;
            double speedY = 0.3 * random.nextDouble() + 0.2;
            double speedZ = (random.nextDouble() - 0.5) * 0.3;
            level.m_7106_((ParticleOptions)ModParticles.TAR_BUBBLE.get(), posX, posY, posZ, speedX, speedY, speedZ);
        }
    }

    private static void trySpawnTarSlime(Level level, BlockPos pos, boolean isSource) {
        int tarSlimeSpawnRate = FossilConfig.getInt("tarSlimesSpawnRate");
        if (level.m_46791_() != Difficulty.PEACEFUL && FossilConfig.isEnabled("spawnTarSlimes") && level.f_46441_.nextInt(isSource ? tarSlimeSpawnRate : tarSlimeSpawnRate * 15) == 0) {
            double spawnRange = 16.0;
            int k = level.m_142425_((EntityTypeTest)ModEntities.TAR_SLIME.get(), new AABB(pos, pos.m_142082_(1, 1, 1)).m_82400_(spawnRange), Entity::m_6084_).size();
            if (k < 6) {
                TarSlime slime = (TarSlime)((EntityType)ModEntities.TAR_SLIME.get()).m_20615_(level);
                slime.m_6518_((ServerLevelAccessor)level, level.m_6436_(pos), MobSpawnType.NATURAL, null, null);
                slime.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
                level.m_7967_((Entity)slime);
            }
        }
    }

    public static class Flowing
    extends ArchitecturyFlowingFluid.Flowing {
        public Flowing(ArchitecturyFluidAttributes attributes) {
            super(attributes);
        }

        protected boolean m_5486_(FluidState state, BlockGetter level, BlockPos pos, Fluid fluid, Direction direction) {
            return direction == Direction.DOWN && this.m_6212_(fluid);
        }

        public void m_6292_(Level level, BlockPos pos, FluidState state) {
            super.m_6292_(level, pos, state);
            TarFluid.trySpawnTarSlime(level, pos, this.m_7444_(state));
        }

        protected void m_7450_(Level level, BlockPos pos, FluidState state, Random random) {
            if (Boolean.FALSE.equals(state.m_61143_((Property)f_75947_)) && random.nextInt(64) == 0) {
                level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (SoundEvent)ModSounds.TAR.get(), SoundSource.BLOCKS, 0.3f, random.nextFloat() * 0.4f + 0.8f, false);
            }
            TarFluid.animateParticle(level, pos, state, random);
        }
    }

    public static class Source
    extends ArchitecturyFlowingFluid.Source {
        public Source(ArchitecturyFluidAttributes attributes) {
            super(attributes);
        }

        public void m_6292_(Level level, BlockPos pos, FluidState state) {
            super.m_6292_(level, pos, state);
            TarFluid.trySpawnTarSlime(level, pos, this.m_7444_(state));
        }

        protected void m_7450_(Level level, BlockPos pos, FluidState state, Random random) {
            TarFluid.animateParticle(level, pos, state, random);
        }
    }
}

