/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.world.feature.structures;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.NotNull;

public class CastleFeature
extends StructureFeature<JigsawConfiguration> {
    public CastleFeature() {
        super(JigsawConfiguration.f_67756_, pContext -> {
            BlockPos blockPos = new BlockPos(pContext.f_197355_().m_45604_(), 63, pContext.f_197355_().m_45605_());
            return CastleFeature.addPieces((PieceGeneratorSupplier.Context<JigsawConfiguration>)pContext, (structureManager, structurePoolElement, pos, groundLevelDelta, rotation, boundingBox) -> new PoolElementStructurePiece(structureManager, structurePoolElement, pos, groundLevelDelta, Rotation.NONE, boundingBox), blockPos);
        });
    }

    private static Optional<PieceGenerator<JigsawConfiguration>> addPieces(PieceGeneratorSupplier.Context<JigsawConfiguration> context2, JigsawPlacement.PieceFactory factory, BlockPos pos) {
        WorldgenRandom worldgenRandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenRandom.m_190068_(context2.f_197354_(), context2.f_197355_().f_45578_, context2.f_197355_().f_45579_);
        JigsawConfiguration jigsawConfiguration = (JigsawConfiguration)context2.f_197356_();
        ChunkGenerator chunkGenerator = context2.f_197352_();
        StructureManager structureManager = context2.f_197359_();
        Registry templatePoolRegistry = context2.f_197360_().m_175515_(Registry.f_122884_);
        Rotation rotation = Rotation.NONE;
        StructureTemplatePool structureTemplatePool = (StructureTemplatePool)jigsawConfiguration.m_204802_().m_203334_();
        StructurePoolElement structurePoolElement = (StructurePoolElement)structureTemplatePool.f_210560_.get(0);
        PoolElementStructurePiece poolElementStructurePiece = factory.m_210300_(structureManager, structurePoolElement, pos, structurePoolElement.m_210540_(), rotation, structurePoolElement.m_207470_(structureManager, pos, rotation));
        BoundingBox boundingBox = poolElementStructurePiece.m_73547_();
        int middleX = (boundingBox.m_162399_() + boundingBox.m_162395_()) / 2;
        int middleZ = (boundingBox.m_162401_() + boundingBox.m_162398_()) / 2;
        int posY = pos.m_123342_();
        if (!context2.f_197358_().test(chunkGenerator.m_203495_(QuartPos.m_175400_((int)middleX), QuartPos.m_175400_((int)posY), QuartPos.m_175400_((int)middleZ)))) {
            return Optional.empty();
        }
        int delta = boundingBox.m_162396_() + poolElementStructurePiece.m_72647_();
        poolElementStructurePiece.m_6324_(0, posY - delta, 0);
        return Optional.of((structurePiecesBuilder, context) -> {
            ArrayList pieces = Lists.newArrayList();
            pieces.add(poolElementStructurePiece);
            Placer placer = new Placer((Registry<StructureTemplatePool>)templatePoolRegistry, jigsawConfiguration.m_67765_(), factory, structureManager, pieces, (Random)worldgenRandom);
            placer.placing.addLast(new PieceState(poolElementStructurePiece, 0));
            while (!placer.placing.isEmpty()) {
                PieceState pieceState = placer.placing.removeFirst();
                placer.tryPlacingChildren(pieceState.piece, pieceState.depth);
            }
            pieces.forEach(arg_0 -> ((StructurePiecesBuilder)structurePiecesBuilder).m_142679_(arg_0));
        });
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    private static final class Placer {
        private final Registry<StructureTemplatePool> pools;
        private final int maxDepth;
        private final JigsawPlacement.PieceFactory factory;
        private final StructureManager structureManager;
        private final List<? super PoolElementStructurePiece> pieces;
        private final Random random;
        private final Deque<PieceState> placing = Queues.newArrayDeque();

        public Placer(Registry<StructureTemplatePool> registry, int i, JigsawPlacement.PieceFactory pieceFactory, StructureManager structureManager, List<? super PoolElementStructurePiece> list, Random random) {
            this.pools = registry;
            this.maxDepth = i;
            this.factory = pieceFactory;
            this.structureManager = structureManager;
            this.pieces = list;
            this.random = random;
        }

        private void tryPlacingChildren(PoolElementStructurePiece baseStructurePiece, int depth) {
            StructurePoolElement structurePoolElement = baseStructurePiece.m_209918_();
            BlockPos baseStructurePosition = baseStructurePiece.m_72646_();
            Rotation baseStructureRotation = baseStructurePiece.m_6830_();
            StructureTemplatePool.Projection projection = structurePoolElement.m_210539_();
            BoundingBox baseStructureBoundingBox = baseStructurePiece.m_73547_();
            block0: for (StructureTemplate.StructureBlockInfo baseStructureJigSaw : structurePoolElement.m_207245_(this.structureManager, baseStructurePosition, baseStructureRotation, this.random)) {
                ResourceLocation poolLocation = new ResourceLocation(baseStructureJigSaw.f_74677_.m_128461_("pool"));
                Optional baseTargetPool = this.pools.m_6612_(poolLocation);
                if (baseTargetPool.isEmpty() || ((StructureTemplatePool)baseTargetPool.get()).m_210590_() == 0 && !Objects.equals(poolLocation, Pools.f_127186_.m_135782_())) {
                    FossilMod.LOGGER.warn("Empty or non-existent pool: {}", (Object)poolLocation);
                    continue;
                }
                ArrayList targetPoolElements = Lists.newArrayList();
                if (depth != this.maxDepth) {
                    targetPoolElements.addAll(((StructureTemplatePool)baseTargetPool.get()).m_210588_(this.random));
                }
                if (targetPoolElements.isEmpty()) continue;
                BlockPos baseJigsawPosition = baseStructureJigSaw.f_74675_;
                Direction baseJigsawDirection = JigsawBlock.m_54250_((BlockState)baseStructureJigSaw.f_74676_);
                BlockPos expectedJigsawPosition = baseJigsawPosition.m_142300_(baseJigsawDirection);
                int baseMinY = baseStructureBoundingBox.m_162396_();
                int baseJigsawOffset = baseJigsawPosition.m_123342_() - baseMinY;
                StructurePoolElement targetElement = (StructurePoolElement)targetPoolElements.get(0);
                List allTargetJigsaws = targetElement.m_207245_(this.structureManager, BlockPos.f_121853_, baseStructureRotation, this.random);
                for (StructureTemplate.StructureBlockInfo targetJigsaw : allTargetJigsaws) {
                    int groundLevelDelta = baseStructurePiece.m_72647_();
                    if (!JigsawBlock.m_54245_((StructureTemplate.StructureBlockInfo)baseStructureJigSaw, (StructureTemplate.StructureBlockInfo)targetJigsaw)) continue;
                    BlockPos targetJigsawPosition = targetJigsaw.f_74675_;
                    BlockPos vecToTargetJigsaw = expectedJigsawPosition.m_141950_((Vec3i)targetJigsawPosition);
                    BoundingBox targetBoundingBox = targetElement.m_207470_(this.structureManager, vecToTargetJigsaw, baseStructureRotation);
                    PoolElementStructurePiece poolElementStructurePiece2 = this.factory.m_210300_(this.structureManager, targetElement, vecToTargetJigsaw, groundLevelDelta, baseStructureRotation, targetBoundingBox);
                    baseStructurePiece.m_209916_(new JigsawJunction(expectedJigsawPosition.m_123341_(), baseMinY + groundLevelDelta, expectedJigsawPosition.m_123343_(), 0, targetElement.m_210539_()));
                    poolElementStructurePiece2.m_209916_(new JigsawJunction(baseJigsawPosition.m_123341_(), baseMinY + baseJigsawOffset - targetJigsawPosition.m_123342_() + groundLevelDelta, baseJigsawPosition.m_123343_(), 0, projection));
                    this.pieces.add((PoolElementStructurePiece)poolElementStructurePiece2);
                    if (depth + 1 > this.maxDepth) continue block0;
                    this.placing.addLast(new PieceState(poolElementStructurePiece2, depth + 1));
                    continue block0;
                }
            }
        }
    }

    private static final class PieceState {
        private final PoolElementStructurePiece piece;
        private final int depth;

        public PieceState(PoolElementStructurePiece poolElementStructurePiece, int i) {
            this.piece = poolElementStructurePiece;
            this.depth = i;
        }
    }
}

