/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.world.feature.structures;

import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.github.teamfossilsarcheology.fossil.world.feature.structures.HellBoatPiece;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RangeConfiguration;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import org.jetbrains.annotations.NotNull;

public class HellBoatFeature
extends StructureFeature<RangeConfiguration> {
    public HellBoatFeature() {
        super(RangeConfiguration.f_191320_, PieceGeneratorSupplier.m_197349_(HellBoatFeature::checkLocation, HellBoatFeature::generatePieces));
    }

    private static boolean checkLocation(PieceGeneratorSupplier.Context<RangeConfiguration> context) {
        return FossilConfig.isEnabled("generateHellShips") && context.f_197358_().test(context.f_197352_().m_203495_(QuartPos.m_175400_((int)context.f_197355_().m_151390_()), QuartPos.m_175400_((int)64), QuartPos.m_175400_((int)context.f_197355_().m_151393_())));
    }

    private static void generatePieces(StructurePiecesBuilder builder, PieceGenerator.Context<RangeConfiguration> context) {
        BlockPos origin = context.f_192705_().m_151394_(0);
        NoiseColumn noiseColumn = context.f_192703_().m_141914_(origin.m_123341_(), origin.m_123343_(), context.f_192707_());
        if (noiseColumn.m_183556_(31).m_60734_() != Blocks.f_49991_) {
            return;
        }
        for (int i = 32; i < 50; ++i) {
            Block block = noiseColumn.m_183556_(i).m_60734_();
            if (block == Blocks.f_50016_ || block == Blocks.f_50627_) continue;
            return;
        }
        WorldgenRandom worldgenRandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        Rotation rotation = Rotation.m_55956_((Random)worldgenRandom);
        builder.m_142679_((StructurePiece)new HellBoatPiece(context.f_192704_(), origin.m_175288_(30), rotation));
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }
}

