/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.client.ResourceLoader;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.file.AnimationFileLoader;
import software.bernie.geckolib3.geo.raw.pojo.Converter;
import software.bernie.geckolib3.geo.raw.pojo.RawGeoModel;
import software.bernie.geckolib3.geo.raw.tree.RawGeometryTree;
import software.bernie.geckolib3.geo.render.GeoBuilder;
import software.bernie.geckolib3.geo.render.built.GeoModel;

public class SkeletonGeoModelLoader
extends ResourceLoader<Map<class_2960, GeoModel>> {
    public static final SkeletonGeoModelLoader INSTANCE = new SkeletonGeoModelLoader();
    private Map<class_2960, GeoModel> geoModels = ImmutableMap.of();

    public SkeletonGeoModelLoader() {
        super(class_3264.field_14188, "fossil", "geo/entity", ".json");
    }

    @NotNull
    protected Map<class_2960, GeoModel> prepare(class_3300 resourceManager, class_3695 profiler) {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        for (class_2960 resourceLocation : this.listResources(resourceManager)) {
            try {
                RawGeoModel rawModel = Converter.fromJsonString((String)AnimationFileLoader.getResourceAsString((class_2960)resourceLocation, (class_3300)resourceManager));
                RawGeometryTree rawGeometryTree = RawGeometryTree.parseHierarchy((RawGeoModel)rawModel);
                map.put(resourceLocation, GeoBuilder.getGeoBuilder((String)"fossil").constructGeoModel(rawGeometryTree));
            }
            catch (IOException e) {
                FossilMod.LOGGER.error(String.format("Error parsing %s", resourceLocation), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return map;
    }

    protected void apply(Map<class_2960, GeoModel> files, class_3300 resourceManager, class_3695 profiler) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        mapBuilder.putAll(files);
        this.geoModels = mapBuilder.build();
        FossilMod.LOGGER.info("Loaded {} skeleton models", (Object)this.geoModels.size());
    }

    public GeoModel getSkeletonModel(class_2960 file) {
        return this.geoModels.get(file);
    }
}

