/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.capabilities.ModCapabilities;
import com.github.teamfossilsarcheology.fossil.client.DinopediaBioLoader;
import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.github.teamfossilsarcheology.fossil.entity.Quagga;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.DinosaurEgg;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.OrderType;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfoAI;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFish;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricShearable;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.MoodSystem;
import com.github.teamfossilsarcheology.fossil.food.FoodMappingsManager;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1160;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5225;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import net.minecraft.class_898;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class DinopediaScreen
extends class_437 {
    private static final class_2960 DINOPEDIA_BACKGROUND = FossilMod.location("textures/gui/dinopedia.png");
    private static final class_2960 MOODS = FossilMod.location("textures/gui/dinopedia_mood.png");
    private static final LoadingCache<UUID, class_2561> USERNAMES = CacheBuilder.newBuilder().expireAfterWrite(24L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<UUID, class_2561>(){

        @NotNull
        public class_2561 load(@NotNull UUID key) {
            class_1657 player = class_310.method_1551().field_1687.method_18470(key);
            if (player != null) {
                return player.method_5477();
            }
            GameProfile gameProfile = new GameProfile(key, null);
            gameProfile = class_310.method_1551().method_1495().fillProfileProperties(gameProfile, true);
            if (gameProfile.isComplete()) {
                return new class_2585(gameProfile.getName());
            }
            return new class_2585("Invalid User");
        }
    });
    private static final class_2561 STUNTED_GROWTH = new class_2588("pedia.fossil.condition.stunted");
    private static final class_2561 SHEARED = new class_2588("pedia.fossil.condition.sheared");
    private static final class_2561 NOT_SHEARED = new class_2588("pedia.fossil.condition.not_sheared");
    private static final int MOOD_FACE_WIDTH = 16;
    private static final int MOOD_FACE_HEIGHT = 15;
    private static final int MOOD_BAR_WIDTH = 206;
    private static final int MOOD_BAR_HEIGHT = 9;
    private static final int PAGE_1 = 0;
    private static final int PAGE_2 = 1;
    private static final int MAX_PAGES = 2;
    private final class_1309 entity;
    private List<String> currentBio;
    private final List<class_2561> toolTipList = new ArrayList<class_2561>();
    private final int xSize = 390;
    private final int ySize = 245;
    private int leftPos;
    private int topPos;
    private DinopediaPageButton backButton;
    private DinopediaPageButton forwardButton;
    private int currentPage;

    public DinopediaScreen(class_1309 entity) {
        super((class_2561)new class_2585(""));
        this.entity = entity;
    }

    public static void renderEntityInDinopedia(int posX, int posY, class_1309 entity) {
        class_4587 poseStack = RenderSystem.getModelViewStack();
        poseStack.method_22903();
        poseStack.method_22904((double)posX, (double)posY, 1050.0);
        poseStack.method_22905(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        class_4587 poseStack2 = new class_4587();
        poseStack2.method_22904(0.0, -10.0, 1000.0);
        int scale = 25;
        if (entity instanceof Prehistoric) {
            scale = (int)(35.0f / entity.method_17681());
        } else if (entity instanceof DinosaurEgg) {
            scale = 110;
        } else if (entity instanceof Quagga) {
            scale = 35;
        }
        poseStack2.method_22905((float)scale, (float)scale, (float)scale);
        poseStack2.method_22907(class_1160.field_20707.method_23214(180.0f));
        class_308.method_34742();
        class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
        entityRenderDispatcher.method_3948(false);
        poseStack2.method_22907(class_1160.field_20703.method_23214(-30.0f));
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        RenderSystem.runAsFancy(() -> {
            float yRotO = entity.field_6283;
            entity.field_6283 = 110.0f;
            entityRenderDispatcher.method_3954((class_1297)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack2, (class_4597)bufferSource, 0xF000F0);
            entity.field_6283 = yRotO;
        });
        bufferSource.method_22993();
        entityRenderDispatcher.method_3948(true);
        poseStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
    }

    protected void method_25426() {
        this.leftPos = (this.field_22789 - 390) / 2;
        this.topPos = (this.field_22790 - 245) / 2;
        this.backButton = (DinopediaPageButton)this.method_37063((class_364)new DinopediaPageButton(this.leftPos + 10, this.topPos + 245 - 45, 200, 100, false, button -> this.pageBack()));
        if (this.entity instanceof Prehistoric || this.entity instanceof Quagga || this.entity instanceof PrehistoricFish) {
            this.forwardButton = (DinopediaPageButton)this.method_37063((class_364)new DinopediaPageButton(this.leftPos + 390 - 43, this.topPos + 245 - 45, 200, 100, true, button -> this.pageForward()));
        }
        this.updateButtonVisibility();
    }

    protected void pageBack() {
        if (this.currentPage > 0) {
            --this.currentPage;
        }
        this.updateButtonVisibility();
    }

    protected void pageForward() {
        if (this.currentPage < this.getMaxPages() - 1) {
            ++this.currentPage;
        }
        this.updateButtonVisibility();
    }

    private void updateButtonVisibility() {
        if (this.forwardButton != null) {
            this.forwardButton.field_22764 = this.currentPage < this.getMaxPages() - 1;
        }
        this.backButton.field_22764 = this.currentPage > 0;
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        this.method_25420(poseStack);
        this.renderBackgroundLayer(poseStack, mouseX, mouseY);
        super.method_25394(poseStack, mouseX, mouseY, partialTick);
        this.renderForegroundLayer(poseStack, mouseX, mouseY, partialTick);
        if (!this.toolTipList.isEmpty()) {
            this.method_30901(poseStack, this.toolTipList, mouseX, mouseY);
            this.toolTipList.clear();
        }
    }

    private void renderBackgroundLayer(class_4587 poseStack, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)DINOPEDIA_BACKGROUND);
        DinopediaScreen.method_25290((class_4587)poseStack, (int)this.leftPos, (int)this.topPos, (float)0.0f, (float)0.0f, (int)390, (int)245, (int)390, (int)390);
        if (this.currentPage == 0) {
            DinopediaScreen.renderEntityInDinopedia(this.leftPos + 100, this.topPos + 80, this.entity);
        }
    }

    private void renderForegroundLayer(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.currentPage == 0) {
            this.renderFirstPage(poseStack, mouseX, mouseY);
        } else if (this.currentPage >= 1) {
            if (this.currentBio == null) {
                this.currentBio = this.loadBio(this.entity);
                this.updateButtonVisibility();
            }
            if (!this.currentBio.isEmpty()) {
                this.renderPrehistoricBio(poseStack);
            }
        }
    }

    private int getMaxPages() {
        if (this.currentBio == null) {
            return 2;
        }
        return 2 + this.currentBio.size() / 42;
    }

    private float getScaledX(boolean left, int width, float scale) {
        return ((float)this.leftPos + (left ? 0.0f : 195.0f) + (195.0f - (float)width * scale) / 2.0f) / scale;
    }

    private static float roundToHalf(double value) {
        return (float)Math.round(value * 2.0) / 2.0f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void renderFirstPage(class_4587 poseStack, int mouseX, int mouseY) {
        class_1309 scale3;
        class_2561 name;
        class_1429 animal;
        float embryoProgress;
        int col = 10321511;
        boolean drawLeftPage = true;
        class_1309 class_13092 = this.entity;
        if (class_13092 instanceof class_1429 && (embryoProgress = (float)ModCapabilities.getEmbryoProgress(animal = (class_1429)class_13092)) > 0.0f) {
            drawLeftPage = false;
            float quot = DinopediaScreen.roundToHalf(embryoProgress / (float)(FossilConfig.getInt("pregnancyDuration") + 1) * 100.0f);
            class_2588 progress = new class_2588("pedia.fossil.pregnantTime", new Object[]{Float.valueOf(quot)});
            this.field_22793.method_30883(poseStack, (class_2561)progress, this.getScaledX(true, this.field_22793.method_27525((class_5348)progress), 1.0f), (float)(this.topPos + 135), col);
            poseStack.method_22903();
            float scale2 = 1.5f;
            poseStack.method_22905(scale2, scale2, scale2);
            class_2588 name2 = new class_2588("pedia.fossil.pregnant", new Object[]{this.entity.method_5864().method_5897()});
            this.field_22793.method_30883(poseStack, (class_2561)name2, this.getScaledX(true, this.field_22793.method_27525((class_5348)name2), scale2), (float)(this.topPos + 85) / scale2, 4337700);
            poseStack.method_22909();
        }
        this.renderFirstPageRight(poseStack, mouseX, mouseY);
        class_1309 quot = this.entity;
        if (quot instanceof Prehistoric) {
            Prehistoric dino = (Prehistoric)quot;
            if (drawLeftPage) {
                poseStack.method_22903();
                float scale3 = 1.5f;
                poseStack.method_22905(scale3, scale3, scale3);
                name = this.entity.method_5864().method_5897();
                this.field_22793.method_30883(poseStack, name, this.getScaledX(true, this.field_22793.method_27525((class_5348)name), scale3), (float)(this.topPos + 85) / scale3, 4337700);
                poseStack.method_22909();
                int x = this.leftPos + 30;
                int y = this.topPos + 85;
                this.field_22793.method_30883(poseStack, (class_2561)new class_2588("pedia.fossil.age", new Object[]{dino.getAgeInDays()}), (float)x, (float)(y + 20), col);
                this.field_22793.method_30883(poseStack, (class_2561)new class_2588("pedia.fossil.health", new Object[]{this.entity.method_6032() + "/" + this.entity.method_6063()}), (float)x, (float)(y + 30), col);
                this.field_22793.method_30883(poseStack, (class_2561)new class_2588("pedia.fossil.hunger", new Object[]{dino.getHunger() + "/" + dino.getMaxHunger()}), (float)x, (float)(y + 40), col);
                class_2561 dietText = dino.data().diet().getName();
                this.renderHoverInfo(poseStack, x, y + 50, mouseX, mouseY, dietText, dino.data().diet().getDescription());
                class_2561 tempText = dino.aiResponseType().getName();
                this.renderHoverInfo(poseStack, x, y + 60, mouseX, mouseY, tempText, dino.aiResponseType().getDescription());
                this.field_22793.method_30883(poseStack, dino.getGender().getName(), (float)x, (float)(y + 70), col);
                if (dino.method_6139() == null) {
                    this.field_22793.method_30883(poseStack, (class_2561)new class_2588("pedia.fossil.untamed"), (float)x, (float)(y + 80), col);
                } else {
                    try {
                        this.field_22793.method_30883(poseStack, (class_2561)new class_2588("pedia.fossil.owner", new Object[]{USERNAMES.get((Object)dino.method_6139())}), (float)x, (float)(y + 80), col);
                    }
                    catch (ExecutionException e) {
                        this.field_22793.method_30883(poseStack, (class_2561)new class_2588("pedia.fossil.owner", new Object[]{"Invalid User"}), (float)x, (float)(y + 80), col);
                    }
                }
                OrderType order = dino.getCurrentOrder();
                this.renderHoverInfo(poseStack, x, y + 90, mouseX, mouseY, order.getName(), order.getDescription());
                this.field_22793.method_30883(poseStack, (class_2561)new class_2588("pedia.fossil.order.item", new Object[]{new class_2588(dino.getOrderItem().method_7876())}), (float)x, (float)(y + 100), col);
                PrehistoricEntityInfoAI.Activity activity = dino.aiActivityType();
                this.renderHoverInfo(poseStack, x, y + 110, mouseX, mouseY, activity.getName(), activity.getDescription());
                this.field_22793.method_30883(poseStack, (class_2561)new class_2588("pedia.fossil.population", new Object[]{dino.data().maxPopulation()}), (float)x, (float)(y + 120), col);
                return;
            }
        }
        if ((scale3 = this.entity) instanceof DinosaurEgg) {
            DinosaurEgg egg = (DinosaurEgg)scale3;
            poseStack.method_22903();
            float scale4 = 1.5f;
            poseStack.method_22905(scale4, scale4, scale4);
            name = new class_2588("pedia.fossil.egg", new Object[]{egg.getPrehistoricEntityInfo().displayName.get()});
            this.field_22793.method_30883(poseStack, name, this.getScaledX(true, this.field_22793.method_27525((class_5348)name), scale4), (float)(this.topPos + 85) / scale4, 4337700);
            poseStack.method_22909();
            int time = class_3532.method_15375((float)((float)egg.getHatchingTime() / (float)egg.getTotalHatchingTime() * 100.0f));
            class_2588 progress = new class_2588("pedia.fossil.egg.time", new Object[]{Math.max(time, 0)});
            this.field_22793.method_30883(poseStack, (class_2561)progress, this.getScaledX(true, this.field_22793.method_27525((class_5348)progress), 1.0f), (float)(this.topPos + 120), 10321511);
            class_5250 status = egg.method_5799() ? new class_2588("pedia.fossil.egg.status.wet").method_27694(style -> style.method_10977(class_124.field_1075)) : (egg.isTooCold() ? new class_2588("pedia.fossil.egg.status.cold").method_27694(style -> style.method_10977(class_124.field_1078)) : new class_2588("pedia.fossil.egg.status.warm").method_27694(style -> style.method_10977(class_124.field_1065)));
            status = new class_2588("pedia.fossil.egg.status", new Object[]{status});
            this.field_22793.method_30883(poseStack, (class_2561)status, this.getScaledX(true, this.field_22793.method_27525((class_5348)status), 1.0f), (float)(this.topPos + 140), 10321511);
            return;
        } else {
            if (!(this.entity instanceof PrehistoricFish) && !(this.entity instanceof Quagga)) return;
            poseStack.method_22903();
            float scale5 = 1.5f;
            poseStack.method_22905(scale5, scale5, scale5);
            name = this.entity.method_5864().method_5897();
            this.field_22793.method_30883(poseStack, name, this.getScaledX(true, this.field_22793.method_27525((class_5348)name), scale5), (float)(this.topPos + 85) / scale5, 4337700);
            poseStack.method_22909();
        }
    }

    private void renderHoverInfo(class_4587 poseStack, int x, int y, int mouseX, int mouseY, class_2561 text, class_2561 hoverText) {
        this.field_22793.method_30883(poseStack, text, (float)x, (float)y, 10321511);
        if (mouseX >= x && mouseY >= y && mouseX < x + this.field_22793.method_27525((class_5348)text)) {
            Objects.requireNonNull(this.field_22793);
            if (mouseY < y + 9) {
                this.toolTipList.add(hoverText);
            }
        }
    }

    private void renderFirstPageRight(class_4587 poseStack, int mouseX, int mouseY) {
        class_1309 class_13092 = this.entity;
        if (class_13092 instanceof Prehistoric) {
            Prehistoric dino = (Prehistoric)class_13092;
            RenderSystem.setShaderTexture((int)0, (class_2960)MOODS);
            poseStack.method_22903();
            float scale = 1.75f;
            poseStack.method_22905(scale, scale, scale);
            int x = (int)this.getScaledX(false, 16, scale);
            int y = (int)((float)(this.topPos + 16) / scale);
            MoodSystem moodSystem = dino.moodSystem;
            this.method_25302(poseStack, x, y, moodSystem.getMoodFace().uOffset, 10, 16, 15);
            poseStack.method_22909();
            x = (int)((float)x * scale);
            y = (int)((float)y * scale);
            if (this.toolTipList.isEmpty() && mouseX >= x && mouseY >= y && (float)mouseX < (float)x + 16.0f * scale && (float)mouseY < (float)y + 15.0f * scale) {
                this.toolTipList.add(moodSystem.getMoodFace().getName());
                this.toolTipList.add(moodSystem.getMoodFace().getDescription());
            }
            poseStack.method_22903();
            scale = 0.75f;
            poseStack.method_22905(scale, scale, scale);
            x = (int)this.getScaledX(false, 206, scale);
            y = (int)((float)(this.topPos + 49) / scale);
            this.method_25302(poseStack, x, y, 0, 0, 206, 9);
            poseStack.method_22909();
            x = (int)((float)x * scale);
            y = (int)((float)y * scale);
            if (this.toolTipList.isEmpty() && mouseX >= x && mouseY >= y && (float)mouseX < (float)x + 206.0f * scale && (float)mouseY < (float)y + 9.0f * scale) {
                class_5250 mood = new class_2585(String.valueOf(moodSystem.getMood())).method_27694(style -> style.method_10977(moodSystem.getMoodFace().color));
                this.toolTipList.add((class_2561)new class_2588("pedia.fossil.mood_status", new Object[]{mood}));
            }
            poseStack.method_22903();
            x = (int)this.getScaledX(false, 4, 1.0f);
            y = this.topPos + 9 + 38;
            this.method_25302(poseStack, x - moodSystem.getMoodPosition(), y, 0, 26, 4, 10);
            poseStack.method_22909();
            TreeSet<class_1792> foodMap = FoodMappingsManager.INSTANCE.getItemCache().get(dino.data().diet());
            List keys = foodMap.stream().limit(64L).toList();
            int itemCount = 0;
            int renderSize = 16;
            for (class_1935 itemLike : keys) {
                x = this.leftPos + 195 + (195 - renderSize * 8) / 2 + renderSize * (itemCount % 8);
                y = this.topPos + 65 + renderSize * (itemCount / 8);
                ++itemCount;
                class_1799 itemStack = new class_1799(itemLike);
                this.field_22788.method_4023(itemStack, x, y);
                if (!this.toolTipList.isEmpty() || mouseX < x || mouseY < y || mouseX >= x + renderSize || mouseY >= y + renderSize) continue;
                this.toolTipList.addAll(this.method_25408(itemStack));
            }
            x = this.leftPos + 4 + 195;
            y = this.topPos + 70 + renderSize * (itemCount / 8);
            if (dino.isAgingDisabled()) {
                this.field_22788.method_4023(new class_1799((class_1935)class_1802.field_8635), x += 16, y);
                if (this.toolTipList.isEmpty() && mouseX >= x && mouseY >= y && mouseX < x + renderSize && mouseY < y + renderSize) {
                    this.toolTipList.add(STUNTED_GROWTH);
                }
            }
            if (dino instanceof PrehistoricShearable) {
                PrehistoricShearable shearable = (PrehistoricShearable)((Object)dino);
                this.field_22788.method_4023(new class_1799((class_1935)class_1802.field_8868), x += 16, y);
                if (shearable.isSheared()) {
                    this.field_22788.method_4023(new class_1799((class_1935)class_2246.field_10499), x, y);
                }
                if (this.toolTipList.isEmpty() && mouseX >= x && mouseY >= y && mouseX < x + renderSize && mouseY < y + renderSize) {
                    this.toolTipList.add(shearable.isSheared() ? SHEARED : NOT_SHEARED);
                }
            }
            if (class_310.method_1551().field_1724.method_7337()) {
                class_2487 tag = dino.getDebugTag();
                if (dino.method_5987() || tag.method_10577("disableGoalAI") || tag.method_10577("disableMoveAI") || tag.method_10577("disableLookAI")) {
                    this.field_22788.method_4023(new class_1799((class_1935)class_1802.field_8688), x += 16, y);
                    if (this.toolTipList.isEmpty() && mouseX >= x && mouseY >= y && mouseX < x + renderSize && mouseY < y + renderSize) {
                        this.toolTipList.add((class_2561)new class_2585(String.format("Disabled AI: %b, Goal: %b, Move: %b, Look: %b", dino.method_5987(), tag.method_10577("disableGoalAI"), tag.method_10577("disableMoveAI"), tag.method_10577("disableLookAI"))));
                    }
                }
                if (!dino.getVariantId().isBlank()) {
                    this.field_22788.method_4023(new class_1799((class_1935)class_1802.field_8264), x += 16, y);
                    if (this.toolTipList.isEmpty() && mouseX >= x && mouseY >= y && mouseX < x + renderSize && mouseY < y + renderSize) {
                        this.toolTipList.add((class_2561)new class_2585("Variant: " + dino.getVariantId()));
                    }
                }
            }
        }
    }

    private List<String> loadBio(class_1309 entity) {
        String name;
        if (entity instanceof Prehistoric) {
            name = ((Prehistoric)entity).info().resourceName;
        } else if (entity instanceof PrehistoricFish) {
            name = ((PrehistoricFish)entity).info().resourceName;
        } else if (entity instanceof Quagga) {
            name = "quagga";
        } else {
            return List.of();
        }
        String bio = DinopediaBioLoader.INSTANCE.getDinopediaBio(name);
        class_5225 stringSplitter = this.field_22793.method_27527();
        ArrayList<String> list = new ArrayList<String>();
        stringSplitter.method_27485(bio, 195, class_2583.field_24360, true, (style, i, j) -> {
            String string2 = bio.substring(i, j);
            list.add(StringUtils.stripEnd((String)string2, (String)" \n"));
        });
        return list;
    }

    private void renderPrehistoricBio(class_4587 poseStack) {
        poseStack.method_22903();
        float scale = 0.75f;
        poseStack.method_22905(scale, scale, scale);
        int right = 0;
        int left = 0;
        int offset = this.currentPage - 1;
        List currentLines = this.currentBio.stream().skip((long)offset * 42L).limit(42L).toList();
        for (int i = 0; i < currentLines.size(); ++i) {
            if (i <= 20) {
                String string = (String)currentLines.get(i);
                float f = this.getScaledX(true, 195, scale);
                Objects.requireNonNull(this.field_22793);
                this.field_22793.method_1729(poseStack, string, f, (float)(this.topPos + 10 + 9 * ++left) / scale, 10321511);
                continue;
            }
            String string = (String)currentLines.get(i);
            float f = this.getScaledX(false, 195, scale);
            Objects.requireNonNull(this.field_22793);
            this.field_22793.method_1729(poseStack, string, f, (float)(this.topPos + 10 + 9 * ++right) / scale, 10321511);
        }
        poseStack.method_22909();
    }

    public boolean method_25421() {
        return false;
    }

    static class DinopediaPageButton
    extends class_4185 {
        private final boolean isForward;

        public DinopediaPageButton(int x, int y, int width, int height, boolean isForward, class_4185.class_4241 onPress) {
            super(x, y, width, height, (class_2561)new class_2585(""), onPress);
            this.isForward = isForward;
        }

        public void method_25359(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)DINOPEDIA_BACKGROUND);
            this.method_25302(poseStack, this.field_22760, this.field_22761, this.isForward ? 0 : 34, 223, 34, 30);
        }
    }
}

