/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugScreen;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugSlider;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugTab;
import com.github.teamfossilsarcheology.fossil.entity.data.EntityDataLoader;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.network.MessageHandler;
import com.github.teamfossilsarcheology.fossil.network.debug.C2STameMessage;
import com.github.teamfossilsarcheology.fossil.network.debug.SyncDebugInfoMessage;
import com.github.teamfossilsarcheology.fossil.util.Gender;
import java.text.DecimalFormat;
import java.util.Arrays;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4064;
import net.minecraft.class_4185;
import net.minecraft.class_4587;

public class InfoTab
extends DebugTab<Prehistoric> {
    private final int maxAgeInTicks;
    private Gender gender;
    private int ageInTicks;
    private double scaleOverride;
    private int matingCooldown;
    private int playingCooldown;
    private int climbingCooldown;
    private int hunger;
    private int mood;
    private DebugSlider ageSlider;
    private DebugSlider scaleSlider;
    private DebugSlider matingSlider;
    private DebugSlider playingSlider;
    private DebugSlider climbingSlider;
    private DebugSlider hungerSlider;
    private DebugSlider moodSlider;

    protected InfoTab(DebugScreen debugScreen, Prehistoric prehistoric) {
        super(debugScreen, prehistoric);
        this.maxAgeInTicks = prehistoric.data().adultAgeInTicks();
        this.gender = prehistoric.getGender();
        this.ageInTicks = prehistoric.method_5618();
        this.matingCooldown = prehistoric.getMatingCooldown();
        this.playingCooldown = prehistoric.moodSystem.getPlayingCooldown();
        this.climbingCooldown = prehistoric.getClimbingCooldown();
        this.hunger = prehistoric.getHunger();
        this.mood = prehistoric.moodSystem.getMood();
    }

    @Override
    protected void init(int width, int height) {
        super.init(width, height);
        int yPos = 0;
        this.ageSlider = new DebugSlider(20, yPos += 30, 150, 20, (class_2561)new class_2585("Age in ticks: "), (class_2561)new class_2585(""), 0.0, this.maxAgeInTicks, this.ageInTicks, 12000.0, 0, true){

            @Override
            protected void method_25344() {
                InfoTab.this.ageInTicks = (int)(this.stepSize * (double)Math.round(class_3532.method_16436((double)this.field_22753, (double)this.minValue, (double)this.maxValue) / this.stepSize));
            }

            public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
                super.method_25394(poseStack, mouseX, mouseY, partialTick);
                int j = this.field_22763 ? 0xFFFFFF : 0xA0A0A0;
                EntityDataLoader.Data data = ((Prehistoric)InfoTab.this.entity).data();
                DecimalFormat format = new DecimalFormat("0.00");
                float step = (data.maxScale() - data.minScale()) / (float)(data.adultAgeInTicks() + 1);
                String min = format.format((double)data.minScale() + (double)step * this.minValue);
                String max = format.format((double)data.minScale() + (double)step * this.maxValue);
                1.method_25303((class_4587)poseStack, (class_327)InfoTab.this.minecraft.field_1772, (String)min, (int)this.field_22760, (int)(this.field_22761 - 8), (int)(j | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24));
                1.method_25303((class_4587)poseStack, (class_327)InfoTab.this.minecraft.field_1772, (String)max, (int)(this.field_22760 + this.field_22758 - InfoTab.this.minecraft.field_1772.method_1727(max)), (int)(this.field_22761 - 8), (int)(j | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24));
            }
        };
        this.addWidget(new class_4185(275, 30, 150, 20, (class_2561)new class_2585("Scale 1"), button -> {
            EntityDataLoader.Data data = ((Prehistoric)this.entity).data();
            this.ageInTicks = (int)((1.0f - data.minScale()) * (float)(data.adultAgeInTicks() + 1) / (data.maxScale() - data.minScale()));
            this.ageSlider.setValue(this.ageInTicks);
        }));
        this.addWidget(new class_4185(275, 55, 50, 20, (class_2561)new class_2585("Tame"), button -> MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new C2STameMessage(((Prehistoric)this.entity).method_5628()))));
        this.scaleSlider = new DebugSlider(20, yPos += 30, 150, 20, (class_2561)new class_2585("Scale: "), (class_2561)new class_2585(""), 0.1, Math.max(2.5, (double)((Prehistoric)this.entity).data().maxScale()), ((Prehistoric)this.entity).method_17825(), 0.05, 2, true){

            @Override
            protected void method_25344() {
                InfoTab.this.scaleOverride = this.stepSize * (double)Math.round(class_3532.method_16436((double)this.field_22753, (double)this.minValue, (double)this.maxValue) / this.stepSize);
                ((Prehistoric)InfoTab.this.entity).setScaleOverride((float)InfoTab.this.scaleOverride);
            }

            public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
                super.method_25394(poseStack, mouseX, mouseY, partialTick);
                int j = this.field_22763 ? 0xFFFFFF : 0xA0A0A0;
                EntityDataLoader.Data data = ((Prehistoric)InfoTab.this.entity).data();
                String min = String.valueOf(0);
                int minX = (int)(((double)data.minScale() - this.minValue) / (this.maxValue - this.minValue) * (double)this.field_22758);
                String max = String.valueOf(((Prehistoric)InfoTab.this.entity).data().adultAgeDays());
                int maxX = (int)(((double)data.maxScale() - this.minValue) / (this.maxValue - this.minValue) * (double)(this.field_22758 - InfoTab.this.minecraft.field_1772.method_1727(max)));
                2.method_25303((class_4587)poseStack, (class_327)InfoTab.this.minecraft.field_1772, (String)min, (int)(this.field_22760 + minX), (int)(this.field_22761 - 8), (int)(j | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24));
                2.method_25303((class_4587)poseStack, (class_327)InfoTab.this.minecraft.field_1772, (String)max, (int)(this.field_22760 + maxX), (int)(this.field_22761 - 8), (int)(j | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24));
            }
        };
        this.matingSlider = new DebugSlider(20, yPos += 30, 150, 20, (class_2561)new class_2585("Seconds till mating: "), (class_2561)new class_2585(""), 0.0, 900.0, (float)this.matingCooldown / 20.0f, 1.0, 0, true){

            @Override
            protected void method_25344() {
                InfoTab.this.matingCooldown = (int)(this.stepSize * (double)Math.round(class_3532.method_16436((double)this.field_22753, (double)this.minValue, (double)this.maxValue) / this.stepSize) * 20.0);
            }
        };
        this.playingSlider = new DebugSlider(20, yPos += 30, 150, 20, (class_2561)new class_2585("Seconds till playing: "), (class_2561)new class_2585(""), 0.0, 120.0, (float)this.playingCooldown / 20.0f, 1.0, 0, true){

            @Override
            protected void method_25344() {
                InfoTab.this.playingCooldown = (int)(this.stepSize * (double)Math.round(class_3532.method_16436((double)this.field_22753, (double)this.minValue, (double)this.maxValue) / this.stepSize) * 20.0);
            }
        };
        this.climbingSlider = new DebugSlider(20, yPos += 30, 150, 20, (class_2561)new class_2585("Seconds till climbing: "), (class_2561)new class_2585(""), 0.0, 120.0, (float)this.climbingCooldown / 20.0f, 1.0, 0, true){

            @Override
            protected void method_25344() {
                InfoTab.this.climbingCooldown = (int)(this.stepSize * (double)Math.round(class_3532.method_16436((double)this.field_22753, (double)this.minValue, (double)this.maxValue) / this.stepSize) * 20.0);
            }
        };
        this.hungerSlider = new DebugSlider(20, yPos += 30, 150, 20, (class_2561)new class_2585("Hunger: "), (class_2561)new class_2585(""), 0.0, ((Prehistoric)this.entity).getMaxHunger(), this.hunger, 1.0, 0, true){

            @Override
            protected void method_25344() {
                InfoTab.this.hunger = (int)(this.stepSize * (double)Math.round(class_3532.method_16436((double)this.field_22753, (double)this.minValue, (double)this.maxValue) / this.stepSize));
            }
        };
        this.moodSlider = new DebugSlider(20, yPos += 30, 150, 20, (class_2561)new class_2585("Mood: "), (class_2561)new class_2585(""), -100.0, 100.0, this.mood, 1.0, 0, true){

            @Override
            protected void method_25344() {
                InfoTab.this.mood = (int)(this.stepSize * (double)Math.round(class_3532.method_16436((double)this.field_22753, (double)this.minValue, (double)this.maxValue) / this.stepSize));
            }
        };
        this.addWidget(this.ageSlider);
        this.addWidget(this.scaleSlider);
        this.addWidget(this.matingSlider);
        this.addWidget(this.playingSlider);
        this.addWidget(this.climbingSlider);
        this.addWidget(this.hungerSlider);
        this.addWidget(this.moodSlider);
        this.addWidget(class_4064.method_32523((String)"Gender", () -> Arrays.stream(Gender.values()).toList(), Gender::getName, options -> this.gender, (options, option, gender) -> {
            this.gender = gender;
        }).method_18520(class_310.method_1551().field_1690, 20, yPos += 30, 150));
        this.addWidget(new class_4185(20, yPos += 30, 150, 20, (class_2561)new class_2585("Set Info"), button -> {
            ((Prehistoric)this.entity).setGender(this.gender);
            ((Prehistoric)this.entity).setScaleOverride(-1.0f);
            MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new SyncDebugInfoMessage(((Prehistoric)this.entity).method_5628(), this.gender.name(), this.ageInTicks, this.matingCooldown, this.playingCooldown, this.climbingCooldown, this.hunger, this.mood));
        }, (button, poseStack, i, j) -> this.debugScreen.method_25424(poseStack, (class_2561)new class_2585("Set the info above on the server"), i, j)));
    }

    @Override
    protected void render(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        super.render(poseStack, mouseX, mouseY, partialTick);
        int yPos = 5;
        InfoTab.method_27535((class_4587)poseStack, (class_327)this.minecraft.field_1772, (class_2561)new class_2585("Age: " + ((Prehistoric)this.entity).method_5618()), (int)175, (int)(yPos += 30), (int)0xFFFFFF);
        InfoTab.method_27535((class_4587)poseStack, (class_327)this.minecraft.field_1772, (class_2561)new class_2585("Scale: " + ((Prehistoric)this.entity).method_17825()), (int)175, (int)(yPos += 30), (int)0xFFFFFF);
        InfoTab.method_27535((class_4587)poseStack, (class_327)this.minecraft.field_1772, (class_2561)new class_2585("Mate: " + ((Prehistoric)this.entity).getMatingCooldown() / 20), (int)175, (int)(yPos += 30), (int)0xFFFFFF);
        InfoTab.method_27535((class_4587)poseStack, (class_327)this.minecraft.field_1772, (class_2561)new class_2585("Play: " + ((Prehistoric)this.entity).moodSystem.getPlayingCooldown() / 20), (int)175, (int)(yPos += 30), (int)0xFFFFFF);
        InfoTab.method_27535((class_4587)poseStack, (class_327)this.minecraft.field_1772, (class_2561)new class_2585("Climb: " + ((Prehistoric)this.entity).getClimbingCooldown() / 20), (int)175, (int)(yPos += 30), (int)0xFFFFFF);
        InfoTab.method_27535((class_4587)poseStack, (class_327)this.minecraft.field_1772, (class_2561)new class_2585("Hunger: " + ((Prehistoric)this.entity).getHunger()), (int)175, (int)(yPos += 30), (int)0xFFFFFF);
        InfoTab.method_27535((class_4587)poseStack, (class_327)this.minecraft.field_1772, (class_2561)new class_2585("Mood: " + ((Prehistoric)this.entity).moodSystem.getMood()), (int)175, (int)(yPos += 30), (int)0xFFFFFF);
        InfoTab.method_27535((class_4587)poseStack, (class_327)this.minecraft.field_1772, (class_2561)new class_2585("Gender: " + ((Prehistoric)this.entity).getGender().name()), (int)175, (int)(yPos += 30), (int)0xFFFFFF);
    }
}

