/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugScreen;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugSlider;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugTab;
import com.github.teamfossilsarcheology.fossil.entity.PrehistoricSkeleton;
import com.github.teamfossilsarcheology.fossil.entity.data.EntityDataLoader;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.network.MessageHandler;
import com.github.teamfossilsarcheology.fossil.network.debug.SyncDebugInfoMessage;
import com.github.teamfossilsarcheology.fossil.util.TimePeriod;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_327;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_4587;
import net.minecraft.class_6379;
import org.jetbrains.annotations.NotNull;

public class SkeletonEditTab
extends DebugTab<PrehistoricSkeleton> {
    private final int maxAge;
    private int age;
    private PrehistoricEntityInfo info;

    protected SkeletonEditTab(DebugScreen debugScreen, PrehistoricSkeleton entity) {
        super(debugScreen, entity);
        this.maxAge = entity.data().adultAgeDays();
        this.age = entity.getAge();
        this.info = entity.info();
    }

    @Override
    protected void init(int width, int height) {
        super.init(width, height);
        DebugSlider ageSlider = new DebugSlider(20, 30, 150, 20, (class_2561)new class_2585("Age: "), (class_2561)new class_2585(""), 0.0, this.maxAge, this.age, 1.0, 0, true){

            @Override
            protected void method_25344() {
                SkeletonEditTab.this.age = (int)(this.stepSize * (double)Math.round(class_3532.method_16436((double)this.field_22753, (double)this.minValue, (double)this.maxValue) / this.stepSize));
            }
        };
        this.addWidget(ageSlider);
        this.addWidget(new ModelsList());
        this.addWidget(new class_4185(20, 210, 150, 20, (class_2561)new class_2585("Set Info"), button -> {
            MessageHandler.DEBUG_CHANNEL.sendToServer((Object)new SyncDebugInfoMessage(((PrehistoricSkeleton)this.entity).method_5628(), this.info.name(), this.age, 0, 0, 0, 0, 0));
            ageSlider.maxValue = EntityDataLoader.INSTANCE.getData(this.info.resourceName).adultAgeDays();
            this.age = (int)Math.min((double)this.age, ageSlider.maxValue);
            ageSlider.setValue(this.age);
        }));
    }

    @Override
    protected void render(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        super.render(poseStack, mouseX, mouseY, partialTick);
        SkeletonEditTab.method_27535((class_4587)poseStack, (class_327)this.minecraft.field_1772, (class_2561)new class_2585("Age: " + ((PrehistoricSkeleton)this.entity).getAge()), (int)175, (int)35, (int)0xFFFFFF);
        SkeletonEditTab.method_27535((class_4587)poseStack, (class_327)this.minecraft.field_1772, (class_2561)new class_2585("Type: " + ((PrehistoricSkeleton)this.entity).info().name()), (int)175, (int)185, (int)0xFFFFFF);
    }

    private class ModelsList
    extends class_4265<ModelEntry> {
        public ModelsList() {
            super(SkeletonEditTab.this.minecraft, 200, SkeletonEditTab.this.height, 60, SkeletonEditTab.this.height, 25);
            List<String> sortedModels = PrehistoricEntityInfo.entitiesWithSkeleton(TimePeriod.values()).stream().map(Enum::name).toList();
            for (String typeName : sortedModels) {
                this.method_25321((class_350.class_351)new ModelEntry(typeName));
            }
            this.method_31322(false);
            this.method_31323(false);
            this.field_19088 = SkeletonEditTab.this.width - SkeletonEditTab.this.width / 4;
            this.field_19087 = this.field_19088 + this.field_22742;
        }

        protected int method_25329() {
            return this.field_19088 + this.field_22742 - 6;
        }

        private class ModelEntry
        extends class_4265.class_4266<ModelEntry> {
            private final class_4185 changeButton;

            ModelEntry(String text) {
                this.changeButton = new class_4185(0, 0, 200, 20, (class_2561)new class_2585(text), button -> {
                    SkeletonEditTab.this.info = PrehistoricEntityInfo.valueOf(button.method_25369().method_10851());
                });
            }

            @NotNull
            public List<? extends class_6379> method_37025() {
                return ImmutableList.of((Object)this.changeButton);
            }

            public void method_25343(class_4587 poseStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                this.changeButton.field_22760 = left;
                this.changeButton.field_22761 = top;
                this.changeButton.method_25394(poseStack, mouseX, mouseY, partialTick);
            }

            @NotNull
            public List<? extends class_364> method_25396() {
                return ImmutableList.of((Object)this.changeButton);
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                return this.changeButton.method_25402(mouseX, mouseY, button);
            }

            public boolean method_25406(double mouseX, double mouseY, int button) {
                return this.changeButton.method_25406(mouseX, mouseY, button);
            }
        }
    }
}

