/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.filters;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.hooks.client.screen.ScreenAccess;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_918;

public class FilterTab {
    private static final class_2960 FILTER_TEXTURE = FossilMod.location("textures/gui/filters.png");
    private final List<FilterButton> buttons = new ArrayList<FilterButton>();

    public FilterTab(class_437 screen, List<Filter> filters) {
        int leftPos = (screen.field_22789 - 195) / 2;
        int rightPos = leftPos + 191;
        int topPos = (screen.field_22790 - 136) / 2;
        int x = leftPos - 28;
        int y = topPos + 6;
        for (int i = 0; i < filters.size(); ++i) {
            this.buttons.add(new FilterButton(screen, x, y, i <= 3, filters.get(i), button -> this.enableButton((FilterButton)button)));
            y += 30;
            if (i != 3) continue;
            x = rightPos;
            y = topPos + 6;
        }
    }

    public static FilterTab build(class_437 screen, List<Filter> filters, ScreenAccess access) {
        FilterTab tab = new FilterTab(screen, filters);
        tab.buttons.forEach(arg_0 -> ((ScreenAccess)access).addWidget(arg_0));
        return tab;
    }

    public List<class_1792> getItems() {
        Optional optional;
        List<class_1792> list = new ArrayList<class_1792>();
        Optional<FilterButton> enabledButton = this.buttons.stream().filter(button -> button.filter.enabled).findFirst();
        if (enabledButton.isPresent() && (optional = class_2378.field_11142.method_40266(enabledButton.get().filter.tag)).isPresent()) {
            list = ((class_6885.class_6888)optional.get()).method_40239().map(class_6880::comp_349).toList();
        }
        return list;
    }

    public Optional<class_6862<class_1792>> getTag() {
        Optional<FilterButton> enabledButton = this.buttons.stream().filter(button -> button.filter.enabled).findFirst();
        return enabledButton.map(filterButton -> filterButton.filter.tag);
    }

    public void renderButtons(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        this.buttons.forEach(button -> button.method_25394(poseStack, mouseX, mouseY, partialTicks));
    }

    private void enableButton(FilterButton button) {
        if (button.filter.enabled) {
            button.filter.enabled = false;
        } else {
            for (FilterButton filterButton : this.buttons) {
                filterButton.filter.enabled = false;
            }
            button.filter.enabled = true;
        }
    }

    public void enableButtons() {
        this.buttons.forEach(FilterButton::setActive);
    }

    public void disableButtons() {
        this.buttons.forEach(FilterButton::setInActive);
    }

    public static class FilterButton
    extends class_4185 {
        private final class_437 screen;
        private final Filter filter;
        private final boolean left;

        public FilterButton(class_437 screen, int i, int j, boolean left, Filter filter, class_4185.class_4241 onPress) {
            super(i, j, 32, 28, class_2585.field_24366, onPress);
            this.screen = screen;
            this.left = left;
            this.filter = filter;
            this.field_22763 = false;
        }

        protected void setInActive() {
            this.field_22763 = false;
        }

        protected void setActive() {
            this.field_22763 = true;
        }

        public void method_25359(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
            RenderSystem.setShaderTexture((int)0, (class_2960)FILTER_TEXTURE);
            class_918 itemRenderer = class_310.method_1551().method_1480();
            float j = this.left ? 0.0f : 64.0f;
            j = this.filter.enabled ? j + 32.0f : j;
            class_332.method_25291((class_4587)poseStack, (int)this.field_22760, (int)this.field_22761, (int)0, (float)j, (float)0.0f, (int)32, (int)28, (int)128, (int)128);
            itemRenderer.field_4730 = 100.0f;
            itemRenderer.method_4023(this.filter.icon, this.field_22760 + 8, this.field_22761 + 6);
            itemRenderer.field_4730 = 0.0f;
            if (mouseX > this.field_22760 && mouseY > this.field_22761 && mouseX < this.field_22760 + 32 && mouseY < this.field_22761 + 28) {
                this.screen.method_25424(poseStack, this.filter.tooltip, mouseX, mouseY);
            }
        }
    }

    public static class Filter {
        public final class_6862<class_1792> tag;
        private final class_1799 icon;
        private final class_2561 tooltip;
        private boolean enabled;

        public Filter(class_6862<class_1792> tag, class_1799 icon) {
            this.tag = tag;
            this.icon = icon;
            this.tooltip = new class_2588("filter.fossil." + tag.comp_327().method_12832());
        }
    }
}

