/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.renderer.entity;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.InstructionTab;
import com.github.teamfossilsarcheology.fossil.client.model.PrehistoricGeoModel;
import com.github.teamfossilsarcheology.fossil.client.renderer.entity.FixedGeoEntityRenderer;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.Arthropleura;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.util.Version;
import java.util.function.Function;
import net.minecraft.class_1160;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import software.bernie.geckolib3.core.util.Color;

public class PrehistoricGeoRenderer<T extends Prehistoric>
extends FixedGeoEntityRenderer<T> {
    private final Function<class_2960, class_1921> renderType;

    public PrehistoricGeoRenderer(class_5617.class_5618 renderManager, String model, String animation, Function<class_2960, class_1921> renderType) {
        super(renderManager, new PrehistoricGeoModel(model, animation));
        this.renderType = renderType;
    }

    public void render(T entity, float entityYaw, float partialTick, class_4587 poseStack, class_4597 buffer, int packedLight) {
        this.field_4673 = entity.method_17681() * 0.45f;
        poseStack.method_22903();
        if (((Prehistoric)entity).getClimbingDirection() != class_2350.field_11036 || ((Prehistoric)entity).prevClimbDirection != class_2350.field_11036 && ((Prehistoric)entity).climbTick > 0) {
            float progress = class_3532.method_16439((float)partialTick, (float)((Prehistoric)entity).prevClimbTick, (float)((Prehistoric)entity).climbTick) / 5.0f;
            class_2350 dir = ((Prehistoric)entity).getClimbingDirection() != class_2350.field_11036 ? ((Prehistoric)entity).getClimbingDirection() : ((Prehistoric)entity).prevClimbDirection;
            float offset = entity.method_17681() / 2.0f * progress;
            poseStack.method_22904((double)((float)dir.method_10148() * offset), 0.5 * (double)progress, (double)((float)dir.method_10165() * offset));
            class_2350 dirRot = dir.method_10170();
            poseStack.method_22907(new class_1160((float)dirRot.method_10148(), 0.0f, (float)dirRot.method_10165()).method_23214(90.0f * progress));
        }
        super.render(entity, entityYaw, partialTick, poseStack, buffer, packedLight);
        poseStack.method_22909();
    }

    public Color getRenderColor(T animatable, float partialTick, class_4587 poseStack, class_4597 bufferSource, class_4588 buffer, int packedLight) {
        Arthropleura arthropleura;
        if (Version.debugEnabled()) {
            if (InstructionTab.entityListHighlight != null && InstructionTab.entityListHighlight.method_5628() == animatable.method_5628()) {
                return Color.RED;
            }
            if (InstructionTab.highlightInstructionEntity != null && InstructionTab.highlightInstructionEntity.method_5628() == animatable.method_5628()) {
                return Color.RED;
            }
        }
        if (animatable instanceof Arthropleura && (arthropleura = (Arthropleura)animatable).isBee()) {
            return Color.YELLOW;
        }
        return super.getRenderColor(animatable, partialTick, poseStack, bufferSource, buffer, packedLight);
    }

    protected float getSwingMotionAnimThreshold() {
        return 0.08f;
    }

    public class_1921 getRenderType(T animatable, float partialTick, class_4587 poseStack, class_4597 bufferSource, class_4588 buffer, int packedLight, class_2960 texture) {
        return this.renderType.apply(texture);
    }

    protected void applyRotations(T animatable, class_4587 poseStack, float ageInTicks, float rotationYaw, float partialTick) {
        String name;
        poseStack.method_22907(class_1160.field_20705.method_23214(180.0f - rotationYaw));
        if (((Prehistoric)animatable).field_6213 > 0) {
            float deathRotation = ((float)((Prehistoric)animatable).field_6213 + partialTick - 1.0f) / 20.0f * 1.6f;
            poseStack.method_22907(class_1160.field_20707.method_23214(Math.min(class_3532.method_15355((float)deathRotation), 1.0f) * this.getDeathMaxRotation((class_1309)animatable)));
        } else if (animatable.method_16914() && (name = class_124.method_539((String)animatable.method_5477().getString())) != null && (name.equals("Dinnerbone") || name.equalsIgnoreCase("Grumm"))) {
            poseStack.method_22904(0.0, (double)(animatable.method_17682() + 0.1f), 0.0);
            poseStack.method_22907(class_1160.field_20707.method_23214(180.0f));
        }
    }

    public float getWidthScale(T animatable) {
        return ((Prehistoric)animatable).method_17825();
    }

    public float getHeightScale(T entity) {
        return ((Prehistoric)this.animatable).method_17825();
    }
}

