/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai.navigation;

import net.minecraft.class_10;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_7;
import net.minecraft.class_8;

public class NavUtil {
    static final float EPSILON = 1.0E-8f;

    public static boolean isNoCollisionOnPath(class_243 pathVec, class_243 minBounds, class_243 maxBounds, class_10 type, class_1308 mob, class_8 nodeEvaluator) {
        float pathLength = (float)pathVec.method_1033();
        if (pathLength < 1.0E-8f) {
            return true;
        }
        float[] trailingPositions = new float[3];
        int[] leadingEdges = new int[3];
        int[] trailingEdges = new int[3];
        int[] stepDirections = new int[3];
        float[] stepDelta = new float[3];
        float[] stepLength = new float[3];
        float[] normedAxis = new float[3];
        for (class_2350.class_2351 axis : class_2350.class_2351.values()) {
            float axisLength = NavUtil.chooseLengthForAxis(axis, pathVec);
            boolean stepDirection = axisLength >= 0.0f;
            int idx = axis.ordinal();
            stepDirections[idx] = stepDirection ? 1 : -1;
            float lead = NavUtil.chooseLengthForAxis(axis, stepDirection ? maxBounds : minBounds);
            trailingPositions[idx] = NavUtil.chooseLengthForAxis(axis, stepDirection ? minBounds : maxBounds);
            leadingEdges[idx] = NavUtil.leadEdgesToInt(lead, stepDirections[idx]);
            trailingEdges[idx] = NavUtil.trailEdgeToInt(trailingPositions[idx], stepDirections[idx]);
            normedAxis[idx] = axisLength / pathLength;
            stepDelta[idx] = class_3532.method_15379((float)(pathLength / axisLength));
            float dist = stepDirection ? (float)(leadingEdges[idx] + 1) - lead : lead - (float)leadingEdges[idx];
            stepLength[idx] = stepDelta[idx] < Float.POSITIVE_INFINITY ? stepDelta[idx] * dist : Float.POSITIVE_INFINITY;
        }
        class_2338.class_2339 pos = new class_2338.class_2339();
        float previousStepLength = 0.0f;
        do {
            class_2350.class_2351 axis = stepLength[0] < stepLength[1] ? (stepLength[0] < stepLength[2] ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11051) : (stepLength[1] < stepLength[2] ? class_2350.class_2351.field_11052 : class_2350.class_2351.field_11051);
            int idx = axis.ordinal();
            float dt = stepLength[idx] - previousStepLength;
            previousStepLength = stepLength[idx];
            int n = idx;
            leadingEdges[n] = leadingEdges[n] + stepDirections[idx];
            int n2 = idx;
            stepLength[n2] = stepLength[n2] + stepDelta[idx];
            for (class_2350.class_2351 axis2 : class_2350.class_2351.values()) {
                int i;
                int n3 = i = axis2.ordinal();
                trailingPositions[n3] = trailingPositions[n3] + dt * normedAxis[i];
                trailingEdges[i] = NavUtil.trailEdgeToInt(trailingPositions[i], stepDirections[i]);
            }
            int stepX = stepDirections[0];
            int minX = axis == class_2350.class_2351.field_11048 ? leadingEdges[0] : trailingEdges[0];
            int maxX = leadingEdges[0] + stepX;
            int stepY = stepDirections[1];
            int minY = axis == class_2350.class_2351.field_11052 ? leadingEdges[1] : trailingEdges[1];
            int maxY = leadingEdges[1] + stepY;
            int stepZ = stepDirections[2];
            int minZ = axis == class_2350.class_2351.field_11051 ? leadingEdges[2] : trailingEdges[2];
            int maxZ = leadingEdges[2] + stepZ;
            for (int x = minX; x != maxX; x += stepX) {
                for (int z = minZ; z != maxZ; z += stepZ) {
                    if (!NavUtil.isCollisionAtColumn(x, minY, z, maxY, stepY, type, mob, pos, nodeEvaluator)) continue;
                    return false;
                }
            }
        } while (previousStepLength <= pathLength);
        return true;
    }

    private static boolean isCollisionAtColumn(int x, int minY, int z, int maxY, int stepY, class_10 type, class_1308 mob, class_2338.class_2339 pos, class_8 nodeEvaluator) {
        class_7 in;
        float malus;
        if (type == class_10.field_48) {
            class_2680 block;
            int y;
            boolean anyWater = false;
            for (y = minY; y != maxY; y += stepY) {
                block = mob.field_6002.method_8320((class_2338)pos.method_10103(x, y, z));
                if (!block.method_26171((class_1922)mob.field_6002, (class_2338)pos, type)) continue;
                anyWater = true;
                break;
            }
            if (!anyWater) {
                return true;
            }
            for (y = minY; y != maxY; y += stepY) {
                block = mob.field_6002.method_8320((class_2338)pos.method_10103(x, y, z));
                if (block.method_26171((class_1922)mob.field_6002, (class_2338)pos, class_10.field_48) || block.method_26171((class_1922)mob.field_6002, (class_2338)pos, class_10.field_50)) continue;
                return true;
            }
        } else {
            for (int y = minY; y != maxY; y += stepY) {
                class_2680 block = mob.field_6002.method_8320((class_2338)pos.method_10103(x, y, z));
                if (block.method_26171((class_1922)mob.field_6002, (class_2338)pos, type)) continue;
                return true;
            }
        }
        if ((malus = mob.method_5944(in = nodeEvaluator.method_17((class_1922)mob.field_6002, x, minY, z))) < 0.0f || malus >= 8.0f) {
            return true;
        }
        if (type == class_10.field_50) {
            class_7 below = nodeEvaluator.method_17((class_1922)mob.field_6002, x, minY - 1, z);
            if (below == class_7.field_18 || below == class_7.field_14 || below == class_7.field_7) {
                return true;
            }
            if (in == class_7.field_3 || in == class_7.field_9 || in == class_7.field_17) {
                return true;
            }
        }
        return false;
    }

    private static float chooseLengthForAxis(class_2350.class_2351 axis, class_243 vec) {
        return (float)axis.method_10172(vec.field_1352, vec.field_1351, vec.field_1350);
    }

    private static int leadEdgesToInt(float coord, int step) {
        return class_3532.method_15375((float)(coord - (float)step * 1.0E-8f));
    }

    private static int trailEdgeToInt(float coord, int step) {
        return class_3532.method_15375((float)(coord + (float)step * 1.0E-8f));
    }

    public static boolean isAt(class_1297 mob, class_11 path, float threshold, float verticalThreshold) {
        class_243 pathPos = path.method_49(mob);
        return Math.abs(mob.method_23317() - pathPos.field_1352) < (double)threshold && Math.abs(mob.method_23321() - pathPos.field_1350) < (double)threshold && Math.abs(mob.method_23318() - pathPos.field_1351) <= (double)verticalThreshold;
    }

    public static boolean atElevationChange(class_1297 mob, class_11 path) {
        int curr = path.method_39();
        int end = Math.min(path.method_38(), curr + class_3532.method_15386((float)(mob.method_17681() * 0.5f)) + 1);
        int currY = path.method_40((int)curr).field_39;
        for (int i = curr + 1; i < end; ++i) {
            if (path.method_40((int)i).field_39 == currY) continue;
            return true;
        }
        return false;
    }
}

