/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.base;

import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.github.teamfossilsarcheology.fossil.entity.LaserPointEntity;
import com.github.teamfossilsarcheology.fossil.entity.ai.DelayedAttackGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoFollowOwnerGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoMatingGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoPanicGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoWanderGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.FlyingEatFromFeederGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.FlyingEatItemEntityGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.FlyingLandNearFoodGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.FlyingWanderGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.HuntingTargetGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.PlayGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.control.CustomFlightBodyRotationControl;
import com.github.teamfossilsarcheology.fossil.entity.ai.control.CustomFlightLookControl;
import com.github.teamfossilsarcheology.fossil.entity.ai.control.CustomFlightMoveControl;
import com.github.teamfossilsarcheology.fossil.entity.ai.navigation.FlightPathNavigation;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategory;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.animation.PausableAnimationController;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfoAI;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.FlyingSleepSystem;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.SleepSystem;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1330;
import net.minecraft.class_1335;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1400;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1432;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2902;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5493;
import net.minecraft.class_5534;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.manager.AnimationData;

public abstract class PrehistoricFlying
extends Prehistoric
implements class_1432 {
    private static final class_2940<Boolean> FLYING = class_2945.method_12791(PrehistoricFlying.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> TAKING_OFF = class_2945.method_12791(PrehistoricFlying.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> FLYING_UP = class_2945.method_12791(PrehistoricFlying.class, (class_2941)class_2943.field_13323);
    private int flyingTicks = 0;
    private int groundTicks = 0;
    private long takeOffStartTick = 0L;
    private boolean usingStuckNavigation;
    private boolean flyingDown;
    public float prevPitch;
    public float currentPitch;
    public float prevYaw;
    public float autoPitch;
    public float currentYaw;

    protected PrehistoricFlying(class_1299<? extends PrehistoricFlying> entityType, class_1937 level) {
        super(entityType, level);
        this.field_6207 = new CustomFlightMoveControl(this);
        this.field_6206 = new CustomFlightLookControl<PrehistoricFlying>(this);
    }

    @NotNull
    protected class_1330 method_5963() {
        return new CustomFlightBodyRotationControl<PrehistoricFlying>(this);
    }

    public static class_5132.class_5133 createAttributes() {
        return Prehistoric.createAttributes().method_26868(class_5134.field_23719, 0.1).method_26868(class_5134.field_23720, (double)0.4f);
    }

    @Override
    protected void method_5959() {
        this.matingGoal = new DinoMatingGoal(this, 1.0);
        this.field_6201.method_6277(1, (class_1352)new DinoPanicGoal(this, 1.5));
        this.field_6201.method_6277(2, (class_1352)new class_1347((class_1308)this));
        if (this.aiAttackType() != PrehistoricEntityInfoAI.Attacking.NONE && this.aiAttackType() != PrehistoricEntityInfoAI.Attacking.JUMP) {
            this.field_6201.method_6277(6, new DelayedAttackGoal<PrehistoricFlying>(this, this.attributes().sprintMod(), false));
        }
        this.field_6201.method_6277(12, (class_1352)this.matingGoal);
        this.field_6201.method_6277(15, (class_1352)new FlyingLandNearFoodGoal(this));
        this.field_6201.method_6277(16, (class_1352)new FlyingEatFromFeederGoal(this));
        this.field_6201.method_6277(17, (class_1352)new FlyingEatItemEntityGoal(this));
        this.field_6201.method_6277(18, (class_1352)new PlayGoal(this, 1.0));
        this.field_6201.method_6277(20, (class_1352)new DinoFollowOwnerGoal(this, this.attributes().sprintMod(), 7.0f, 2.0f, false));
        this.field_6201.method_6277(21, (class_1352)new FlyingWanderGoal(this));
        this.field_6201.method_6277(21, (class_1352)new DinoWanderGoal(this, 1.0));
        this.field_6201.method_6277(25, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(26, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(5, (class_1352)new HuntingTargetGoal(this));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, LaserPointEntity.class, true));
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(FLYING, (Object)false);
        this.field_6011.method_12784(TAKING_OFF, (Object)false);
        this.field_6011.method_12784(FLYING_UP, (Object)false);
    }

    @Override
    public void method_5674(class_2940<?> key) {
        if (FLYING.equals(key)) {
            this.method_36457(0.0f);
        }
        super.method_5674(key);
    }

    @Override
    @NotNull
    protected SleepSystem createSleepSystem() {
        return new FlyingSleepSystem(this);
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("Flying", this.method_6581());
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setFlying(compound.method_10577("Flying"));
    }

    @Override
    protected class_4050 getTargetPose() {
        return this.method_6581() ? class_4050.field_18077 : super.getTargetPose();
    }

    public boolean method_6581() {
        return (Boolean)this.field_6011.method_12789(FLYING);
    }

    public void setFlying(boolean flying) {
        this.field_6011.method_12778(FLYING, (Object)flying);
        this.updatePose();
    }

    public boolean isFlyingUp() {
        return (Boolean)this.field_6011.method_12789(FLYING_UP);
    }

    public void setFlyingUp(boolean flyingUp) {
        this.field_6011.method_12778(FLYING_UP, (Object)flyingUp);
    }

    public boolean isFlyingDown() {
        return this.flyingDown;
    }

    public void setFlyingDown(boolean flyingDown) {
        this.flyingDown = flyingDown;
    }

    public void doStuckNavigation(class_243 target) {
        this.switchNavigator(true);
        this.method_5942().method_6337(target.field_1352, target.field_1351, target.field_1350, 1.0);
    }

    public void switchNavigator(boolean fly) {
        this.usingStuckNavigation = fly;
        this.field_6189 = fly ? new FlightPathNavigation((class_1308)this, this.field_6002) : this.method_5965(this.field_6002);
    }

    public boolean isUsingStuckNavigation() {
        return this.usingStuckNavigation;
    }

    @Override
    public boolean method_6153() {
        return false;
    }

    @Override
    public void method_6091(class_243 travelVector) {
        if (!this.method_5956()) {
            super.method_6091(travelVector);
            return;
        }
        class_1309 rider = (class_1309)this.method_5642();
        this.method_36456(rider.method_36454());
        this.method_36457(rider.method_36455() * 0.5f);
        this.method_5710(this.method_36454(), this.method_36455());
        this.field_6283 = this.method_36454();
        this.field_6241 = this.method_36454();
        float newStrafeMovement = rider.field_6212 * 0.5f;
        float newForwardMovement = rider.field_6250;
        if (this.method_5787()) {
            this.method_6125((float)this.method_26825(class_5134.field_23719));
            class_243 newMovement = new class_243((double)newStrafeMovement, travelVector.field_1351, (double)newForwardMovement).method_1021(0.5);
            if (this.method_6581()) {
                this.steering.airTravel(newMovement);
            } else {
                super.method_6091(newMovement);
            }
        } else {
            this.method_18799(class_243.field_1353);
            this.method_29242((class_1309)this, true);
        }
    }

    @NotNull
    protected class_1297.class_5799 method_33570() {
        return !this.method_6581() ? super.method_33570() : class_1297.class_5799.field_28630;
    }

    @Override
    public void method_5773() {
        class_1297 rider;
        super.method_5773();
        if (this.field_6002.field_9236 && (rider = this.method_5642()) != null) {
            this.autoPitch = this.isFlyingUp() ? class_3532.method_15348((float)this.autoPitch, (float)-70.0f, (float)5.0f) : (this.isFlyingDown() ? class_3532.method_15348((float)this.autoPitch, (float)70.0f, (float)5.0f) : class_3532.method_15348((float)this.autoPitch, (float)0.0f, (float)2.0f));
            this.prevPitch = this.currentPitch;
            this.currentPitch = class_3532.method_15363((float)(rider.field_6004 + this.autoPitch), (float)-70.0f, (float)70.0f);
            this.prevYaw = this.currentYaw;
            float yawDiff = this.field_5982 - this.method_36454();
            this.currentYaw = yawDiff > 1.0f ? class_3532.method_15348((float)this.currentYaw, (float)10.0f, (float)3.0f) : (yawDiff < -1.0f ? class_3532.method_15348((float)this.currentYaw, (float)-10.0f, (float)3.0f) : class_3532.method_15348((float)this.currentYaw, (float)0.0f, (float)3.0f));
        }
    }

    @Override
    public void method_6007() {
        super.method_6007();
        if (!this.method_24828() && this.method_18798().field_1351 < 0.0 && !this.method_6581()) {
            this.method_18799(this.method_18798().method_18805(1.0, 0.6, 1.0));
        }
        if (!this.field_6002.field_9236) {
            boolean debug;
            class_1407 flyingPathNavigation;
            class_1408 class_14082;
            if (this.isTakingOff() && this.isTakeOffAnimationDone()) {
                this.finishTakeOff();
            }
            if ((class_14082 = this.method_5942()) instanceof class_1407 && ((flyingPathNavigation = (class_1407)class_14082).method_6357() || this.usingStuckNavigation && !this.method_6581())) {
                this.switchNavigator(false);
            }
            if (this.method_6581()) {
                ++this.flyingTicks;
            } else {
                this.groundTicks = 0;
                this.flyingTicks = 0;
            }
            if (this.flyingTicks > 80 && this.method_24828()) {
                ++this.groundTicks;
                if (this.groundTicks > 80) {
                    this.setFlying(false);
                }
            } else {
                this.groundTicks = 0;
            }
            if ((debug = false) || this.flyingTicks > this.getMaxExhaustion()) {
                this.moveTo(class_243.method_24953((class_2382)this.findLandPosition(true)), true, true);
            }
            if (!(!this.isFlyingUp() || this.method_6581() && this.method_5782())) {
                this.setFlyingUp(false);
            }
        }
    }

    @Override
    public boolean eatItem(class_1799 stack) {
        if (this.method_6581() || this.isTakingOff()) {
            return false;
        }
        return super.eatItem(stack);
    }

    @Nullable
    @Contract(value="true -> !null")
    public class_2338 findLandPosition(boolean force) {
        class_2338.class_2339 pos;
        class_243 vec3 = class_5534.method_31527((class_1314)this, (int)8, (int)15);
        if (vec3 == null) {
            int x = this.method_24515().method_10263() - 8 + this.field_5974.nextInt(16);
            int z = this.method_24515().method_10260() - 8 + this.field_5974.nextInt(16);
            int y = this.field_6002.method_8624(class_2902.class_2903.field_13197, x, z);
            pos = new class_2338.class_2339(x, y - 1, z);
        } else {
            pos = new class_2338(vec3).method_25503().method_10098(class_2350.field_11033);
        }
        if (force || class_5493.method_31523((class_1314)this, (class_2338)pos)) {
            class_3965 result = this.field_6002.method_17742(new class_3959(this.method_19538(), class_243.method_24953((class_2382)pos), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
            if (result.method_17783() != class_239.class_240.field_1333) {
                pos = result.method_17777().method_10093(result.method_17780()).method_25503();
                while (this.field_6002.method_22347((class_2338)pos) && pos.method_10264() > this.field_6002.method_31607()) {
                    pos.method_10100(0, -1, 0);
                }
            }
            return pos.method_10062();
        }
        return null;
    }

    private int getMaxExhaustion() {
        return 6000;
    }

    public void moveTo(class_243 pos, boolean shouldLand, boolean shouldFly) {
        class_1335 class_13352 = this.method_5962();
        if (!(class_13352 instanceof CustomFlightMoveControl)) {
            return;
        }
        CustomFlightMoveControl control = (CustomFlightMoveControl)class_13352;
        if (this.method_6581()) {
            control.setFlyingTarget(pos.field_1352, pos.field_1351, pos.field_1350, shouldLand);
            control.setOperation(class_1335.class_1336.field_6378);
        } else if (this.isTakingOff()) {
            control.setFlyingTarget(pos.field_1352, pos.field_1351, pos.field_1350, shouldLand);
            control.setOperation(class_1335.class_1336.field_6377);
        } else if (this.method_5707(pos) > 40.0 || shouldFly) {
            if (this.hasTakeOffAnimation()) {
                this.startTakeOff();
                control.setFlyingTarget(pos.field_1352, pos.field_1351, pos.field_1350, shouldLand);
                control.setOperation(class_1335.class_1336.field_6377);
            } else {
                this.setFlying(true);
                control.setFlyingTarget(pos.field_1352, pos.field_1351, pos.field_1350, shouldLand);
                control.setOperation(class_1335.class_1336.field_6378);
            }
        } else {
            this.method_5942().method_6337(pos.field_1352, pos.field_1351, pos.field_1350, 1.0);
        }
    }

    public boolean isTakingOff() {
        return (Boolean)this.field_6011.method_12789(TAKING_OFF);
    }

    public void startTakeOff() {
        this.field_6011.method_12778(TAKING_OFF, (Object)true);
        this.takeOffStartTick = this.field_6002.method_8510();
        this.getAnimationLogic().triggerAnimation("Movement/Idle", this.nextTakeOffAnimation(), AnimationCategory.NONE);
    }

    public void finishTakeOff() {
        this.field_6011.method_12778(TAKING_OFF, (Object)false);
        this.takeOffStartTick = -1L;
        this.setFlying(true);
        class_1335 class_13352 = this.method_5962();
        if (class_13352 instanceof CustomFlightMoveControl) {
            CustomFlightMoveControl control = (CustomFlightMoveControl)class_13352;
            control.setOperation(class_1335.class_1336.field_6378);
        }
    }

    public void cancelTakeOff() {
        this.field_6011.method_12778(TAKING_OFF, (Object)false);
        this.takeOffStartTick = -1L;
    }

    public boolean isTakeOffAnimationDone() {
        double flyDelay = this.getAnimationLogic().getActionDelay("Movement/Idle");
        return (double)this.field_6002.method_8510() > flyDelay + (double)this.takeOffStartTick;
    }

    public void onReachAirTarget(class_2338 target) {
    }

    @Nullable
    public class_2338 getBlockInView() {
        float radius = -((float)this.field_5974.nextInt(20) + 6.3f);
        float neg = this.field_5974.nextBoolean() ? 1.0f : -1.0f;
        float angle = (float)Math.PI / 180 * this.field_6283 + 3.15f + this.field_5974.nextFloat() * neg;
        double extraX = radius * class_3532.method_15374((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * class_3532.method_15362((float)angle);
        class_2338 radialPos = new class_2338(this.method_23317() + extraX, 0.0, this.method_23321() + extraZ);
        class_2338 ground = this.field_6002.method_8598(class_2902.class_2903.field_13197, radialPos);
        int distFromGround = (int)this.method_23318() - ground.method_10264();
        class_2338 newPos = radialPos.method_10086(distFromGround > 16 ? (int)Math.min((double)FossilConfig.getInt("flyingTargetMaxHeight"), this.method_23318() + (double)this.field_5974.nextInt(16) - 8.0) : (int)this.method_23318() + this.field_5974.nextInt(16) + 1);
        if (!this.isTargetBlocked(class_243.method_24953((class_2382)newPos)) && this.method_5707(class_243.method_24953((class_2382)newPos)) > 6.0) {
            return newPos;
        }
        return null;
    }

    public boolean isTargetBlocked(class_243 target) {
        if (target != null) {
            class_3965 hitResult = this.field_6002.method_17742(new class_3959(this.method_19538(), target, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
            return hitResult.method_17783() == class_239.class_240.field_1332;
        }
        return false;
    }

    @Nullable
    public class_243 generateAirTarget() {
        class_3965[] results = new class_3965[10];
        for (int i = 0; i < 10; ++i) {
            class_3965 result;
            float heightMod = (float)(this.method_23318() + 1.0) / (float)(this.field_6002.method_8624(class_2902.class_2903.field_13197, (int)this.method_23317(), (int)this.method_23321()) + 10);
            double targetX = this.method_23317() + (double)((this.field_5974.nextFloat() * 2.0f - 1.0f) * 16.0f);
            double targetY = this.method_23318() + (double)((this.field_5974.nextFloat() * 2.0f - heightMod) * 16.0f);
            double targetZ = this.method_23321() + (double)((this.field_5974.nextFloat() * 2.0f - 1.0f) * 16.0f);
            class_243 pos = new class_243(targetX, targetY, targetZ);
            results[i] = result = this.field_6002.method_17742(new class_3959(this.method_19538(), pos, class_3959.class_3960.field_17558, this.method_5799() ? class_3959.class_242.field_1348 : class_3959.class_242.field_1347, (class_1297)this));
            class_2338.class_2339 mutable = result.method_17777().method_25503();
            while (!this.field_6002.method_8316((class_2338)mutable).method_15769()) {
                mutable.method_10100(0, 1, 0);
            }
            results[i] = new class_3965(result.method_17784(), result.method_17780(), mutable.method_10062(), result.method_17781());
            if (result.method_17783() != class_239.class_240.field_1333) continue;
            return pos;
        }
        class_3965 furthest = null;
        double distance = 5.0;
        for (int i = 1; i < results.length; ++i) {
            double g = this.method_19538().method_1022(results[i].method_17784());
            if (!(g > distance)) continue;
            furthest = results[i];
            distance = g;
        }
        return furthest != null ? class_243.method_24953((class_2382)furthest.method_17777().method_10093(furthest.method_17780())) : null;
    }

    @Override
    public void registerControllers(AnimationData data) {
        PausableAnimationController<PrehistoricFlying> controller = new PausableAnimationController<PrehistoricFlying>(this, "Movement/Idle", 5.0f, this.getAnimationLogic()::flyingPredicate);
        this.registerEatingListeners(controller);
        data.addAnimationController(controller);
        data.addAnimationController(new PausableAnimationController<PrehistoricFlying>(this, "Attack", 0.0f, this.getAnimationLogic()::attackPredicate));
    }

    public boolean hasTakeOffAnimation() {
        return true;
    }

    @NotNull
    public abstract AnimationInfo nextTakeOffAnimation();
}

