/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.system;

import com.github.teamfossilsarcheology.fossil.entity.ToyBase;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricMoodType;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.AISystem;
import com.github.teamfossilsarcheology.fossil.tags.ModBlockTags;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class MoodSystem
extends AISystem {
    private int moodCheckCooldown = 100;
    private int playingCooldown;
    private ToyBase toyTarget;

    public MoodSystem(Prehistoric prehistoric) {
        super(prehistoric);
        this.playingCooldown = prehistoric.method_6051().nextInt(6000) + 6000;
    }

    public static boolean arePlantsNearby(class_1297 entity, int range) {
        for (int i = class_3532.method_15357((double)(entity.method_23317() - (double)range)); i < class_3532.method_15384((double)(entity.method_23317() + (double)range)); ++i) {
            for (int j = class_3532.method_15357((double)(entity.method_23318() - (double)range / 2.0)); j < class_3532.method_15384((double)(entity.method_23318() + (double)range / 2.0)); ++j) {
                for (int k = class_3532.method_15357((double)(entity.method_23321() - (double)range)); k < class_3532.method_15384((double)(entity.method_23321() + (double)range)); ++k) {
                    if (!((double)j <= (double)entity.field_6002.method_31605() + 1.0) || !MoodSystem.isPlantBlock(entity.field_6002.method_8320(new class_2338(i, j, k)))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isPlantBlock(class_2680 block) {
        return block.method_26164(ModBlockTags.MOOD_BONUS);
    }

    public PrehistoricMoodType getMoodFace() {
        int mood = this.getMood();
        if (mood >= 100) {
            return PrehistoricMoodType.HAPPY;
        }
        if (mood >= 50) {
            return PrehistoricMoodType.CONTENT;
        }
        if (mood <= -100) {
            return PrehistoricMoodType.ANGRY;
        }
        if (mood <= -50) {
            return PrehistoricMoodType.SAD;
        }
        return PrehistoricMoodType.CALM;
    }

    public int getMoodPosition() {
        return (int)(71.0 * -((double)this.getMood() * 0.01));
    }

    public int getMood() {
        return class_3532.method_15340((int)((Integer)this.mob.method_5841().method_12789(Prehistoric.MOOD)), (int)-100, (int)100);
    }

    public void setMood(int mood) {
        this.mob.method_5841().method_12778(Prehistoric.MOOD, (Object)class_3532.method_15340((int)mood, (int)-100, (int)100));
    }

    public void increaseMood(int mood) {
        this.setMood(this.getMood() + mood);
    }

    public void doMoodCheck() {
        int overallMoodAddition = 0;
        overallMoodAddition = MoodSystem.arePlantsNearby((class_1297)this.mob, 16) ? (overallMoodAddition += 50) : (overallMoodAddition -= 50);
        overallMoodAddition = this.mob.getNearbySpeciesMembers(40).size() < this.mob.data().maxPopulation() ? (overallMoodAddition += 50) : (overallMoodAddition -= 50);
        this.setMood(this.getMood() + overallMoodAddition);
    }

    public int getPlayingCooldown() {
        return this.playingCooldown;
    }

    public void setPlayingCooldown(int ticks) {
        this.playingCooldown = ticks;
    }

    public void useToy(int playBonus) {
        if (this.getPlayingCooldown() == 0) {
            this.setMood(this.getMood() + playBonus);
            this.mob.field_6002.method_8421((class_1297)this.mob, (byte)65);
            this.setPlayingCooldown(this.mob.method_6051().nextInt(600) + 600);
        }
    }

    @Override
    public void serverTick() {
        if (this.getMood() > 100) {
            this.setMood(100);
        }
        if (this.getMood() < -100) {
            this.setMood(-100);
        }
        if (this.mob.isDeadlyHungry() && this.getMood() > -50) {
            this.setMood(-50);
        }
        if (this.getPlayingCooldown() > 0) {
            this.setPlayingCooldown(this.getPlayingCooldown() - 1);
        }
        if (this.moodCheckCooldown <= 0) {
            this.doMoodCheck();
            this.moodCheckCooldown = 3000 + this.mob.method_6051().nextInt(5000);
        }
        --this.moodCheckCooldown;
    }

    public void setToyTarget(ToyBase toyTarget) {
        this.toyTarget = toyTarget;
    }

    public ToyBase getToyTarget() {
        return this.toyTarget;
    }

    @Override
    public void saveAdditional(class_2487 tag) {
        tag.method_10569("Mood", this.getMood());
        tag.method_10569("PlayingCooldown", this.getPlayingCooldown());
        tag.method_10569("MoodCheckCooldown", this.moodCheckCooldown);
    }

    @Override
    public void load(class_2487 tag) {
        if (tag.method_10545("Mood")) {
            this.setMood(tag.method_10550("Mood"));
        }
        if (tag.method_10545("PlayingCooldown")) {
            this.setPlayingCooldown(tag.method_10550("PlayingCooldown"));
        }
        if (tag.method_10545("MoodCheckCooldown")) {
            this.moodCheckCooldown = tag.method_10550("MoodCheckCooldown");
        }
    }
}

