/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.variant;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.entity.variant.Variant;
import com.github.teamfossilsarcheology.fossil.entity.variant.VariantCondition;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.jetbrains.annotations.NotNull;

public class EntityVariantLoader
extends class_4309 {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Variant.class, (Object)new Variant.Deserializer()).create();
    public static final EntityVariantLoader INSTANCE = new EntityVariantLoader(GSON);
    private Map<String, Map<String, Variant>> variants = ImmutableMap.of();
    private Map<String, Map<Class<? extends VariantCondition>, List<VariantCondition.WithVariant<VariantCondition>>>> variantsByCondition = ImmutableMap.of();

    public EntityVariantLoader(Gson gson) {
        super(gson, "variants");
    }

    protected void apply(Map<class_2960, JsonElement> jsons, class_3300 resourceManager, class_3695 profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        HashMap<String, ImmutableMap.Builder> innerBuilder = new HashMap<String, ImmutableMap.Builder>();
        for (Map.Entry<class_2960, JsonElement> entry2 : jsons.entrySet()) {
            JsonElement jsonElement = entry2.getValue();
            if (!(jsonElement instanceof JsonObject)) continue;
            JsonObject root = (JsonObject)jsonElement;
            if (!entry2.getKey().method_12836().equals("fossil")) continue;
            String filePath = entry2.getKey().method_12832();
            if (!filePath.contains("/")) {
                FossilMod.LOGGER.warn("Variant {} needs to be nested in a folder with the name of the entity", entry2);
                continue;
            }
            String entityName = filePath.split("/")[0];
            String variantId = filePath.split("/")[1];
            root.addProperty("variantId", variantId);
            Variant variant = (Variant)GSON.fromJson((JsonElement)root, Variant.class);
            innerBuilder.putIfAbsent(entityName, ImmutableMap.builder());
            ((ImmutableMap.Builder)innerBuilder.get(entityName)).put((Object)variantId, (Object)variant);
        }
        for (Map.Entry<Object, Object> entry3 : innerBuilder.entrySet()) {
            builder.put((Object)((String)entry3.getKey()), (Object)((ImmutableMap.Builder)entry3.getValue()).build());
        }
        this.variants = builder.build();
        this.variantsByCondition = this.variants.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, entry -> ((Map)entry.getValue()).values().stream().flatMap(variant -> Arrays.stream(variant.conditions()).map(condition -> VariantCondition.WithVariant.of(condition, variant)).collect(Collectors.toMap(pair -> pair.condition().getClass(), List::of, (list, list2) -> Stream.concat(list.stream(), list2.stream()).toList())).entrySet().stream()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue))));
        FossilMod.LOGGER.info("Loaded {} variants", (Object)this.variants.values().stream().map(Map::size).reduce(Integer::sum).orElse(0));
    }

    @NotNull
    public Map<String, Variant> getVariants(String entityName) {
        return this.variants.getOrDefault(entityName, Map.of());
    }

    public <T extends VariantCondition> List<VariantCondition.WithVariant<T>> getVariantsByCondition(Class<T> clazz, String entityName) {
        List temp = this.variantsByCondition.getOrDefault(entityName, Map.of()).getOrDefault(clazz, List.of());
        return temp.stream().map(pair -> VariantCondition.WithVariant.of(pair.condition(), pair.variant())).toList();
    }

    public Map<String, Map<String, Variant>> getVariants() {
        return this.variants;
    }

    public void replaceVariants(Map<String, Map<String, Variant>> variantsMap) {
        this.variants = ImmutableMap.copyOf(variantsMap);
        FossilMod.LOGGER.info("Replacing {} client variants", (Object)this.variants.size());
    }
}

