/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.event;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.advancements.ModTriggers;
import com.github.teamfossilsarcheology.fossil.block.ModBlocks;
import com.github.teamfossilsarcheology.fossil.capabilities.ModCapabilities;
import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.github.teamfossilsarcheology.fossil.entity.Quagga;
import com.github.teamfossilsarcheology.fossil.entity.ThrownBirdEgg;
import com.github.teamfossilsarcheology.fossil.entity.ai.AnimalFearGoal;
import com.github.teamfossilsarcheology.fossil.entity.monster.AnuBoss;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.EntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.VanillaEntityInfo;
import com.github.teamfossilsarcheology.fossil.food.FoodType;
import com.github.teamfossilsarcheology.fossil.item.MammalEmbryoItem;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import com.github.teamfossilsarcheology.fossil.recipe.ModRecipes;
import com.github.teamfossilsarcheology.fossil.sounds.ModSounds;
import com.github.teamfossilsarcheology.fossil.tags.ModEntityTypeTags;
import com.github.teamfossilsarcheology.fossil.world.dimension.ModDimensions;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import java.util.Locale;
import java.util.Random;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1429;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3468;
import net.minecraft.class_3481;
import net.minecraft.class_3730;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5633;
import org.jetbrains.annotations.NotNull;

public class ModEvents {
    private static final class_2561 ANU_BREAK_BLOCK = new class_2588("entity.fossil.anu.break_block");

    public static void init() {
        EntityEvent.ADD.register((entity, level) -> {
            class_1314 mob;
            if (entity instanceof class_1314 && ModEvents.isLivestock(mob = (class_1314)entity) && FossilConfig.isEnabled("animalsFearDinos")) {
                mob.field_6201.method_6277(1, (class_1352)new AnimalFearGoal(mob, Prehistoric.class, 12.0f, 1.15, 1.25, living -> {
                    Prehistoric prehistoric;
                    return living instanceof Prehistoric && (prehistoric = (Prehistoric)living).data().diet().canEat(FoodType.MEAT);
                }));
            }
            return EventResult.pass();
        });
        BlockEvent.BREAK.register((level, pos, state, player, xp) -> {
            if (level.method_27983() == ModDimensions.ANU_LAIR && level instanceof class_3218) {
                AnuBoss.AnuLair anuLair;
                class_3218 serverLevel = (class_3218)level;
                if (!(ModEvents.isBreakableInAnuLair(state) || player.method_7337() || serverLevel.method_8503().method_3835(player.method_7334()) >= serverLevel.method_8503().method_3798() || (anuLair = (AnuBoss.AnuLair)serverLevel.method_17983().method_20786(c -> new AnuBoss.AnuLair(), "anu_lair")) != null && anuLair.isAnuKilled())) {
                    player.method_7353(ANU_BREAK_BLOCK, true);
                    return EventResult.interruptFalse();
                }
            }
            return EventResult.pass();
        });
        LifecycleEvent.SETUP.register(() -> {
            ModRecipes.initRecipes();
            for (PrehistoricEntityInfo prehistoricEntityInfo : PrehistoricEntityInfo.values()) {
                if (prehistoricEntityInfo.birdEggItem != null) {
                    class_2315.method_10009((class_1935)prehistoricEntityInfo.birdEggItem, (class_2357)ThrownBirdEgg.getProjectile(prehistoricEntityInfo, false));
                }
                if (prehistoricEntityInfo.cultivatedBirdEggItem == null) continue;
                class_2315.method_10009((class_1935)prehistoricEntityInfo.cultivatedBirdEggItem, (class_2357)ThrownBirdEgg.getProjectile(prehistoricEntityInfo, true));
            }
            for (Enum enum_ : VanillaEntityInfo.values()) {
                if (((VanillaEntityInfo)enum_).cultivatedBirdEggItem == null) continue;
                class_2315.method_10009((class_1935)((VanillaEntityInfo)enum_).cultivatedBirdEggItem, (class_2357)ThrownBirdEgg.getProjectile((EntityInfo)((Object)enum_), true));
            }
            class_2315.method_10009((class_1935)((class_1935)ModItems.TAR_BUCKET.get()), (class_2357)new class_2347(){
                private final class_2347 defaultDispenseItemBehavior = new class_2347();

                @NotNull
                public class_1799 method_10135(class_2342 source, class_1799 stack) {
                    class_5633 dispensibleContainerItem = (class_5633)ModItems.TAR_BUCKET.get();
                    class_2338 blockPos = source.method_10122().method_10093((class_2350)source.method_10120().method_11654((class_2769)class_2315.field_10918));
                    if (dispensibleContainerItem.method_7731(null, (class_1937)source.method_10207(), blockPos, null)) {
                        dispensibleContainerItem.method_7728(null, (class_1937)source.method_10207(), stack, blockPos);
                        return new class_1799((class_1935)class_1802.field_8550);
                    }
                    return this.defaultDispenseItemBehavior.dispense(source, stack);
                }
            });
        });
        InteractionEvent.INTERACT_ENTITY.register((player, entity, hand) -> {
            class_1799 stack = player.method_5998(hand);
            class_1792 patt6478$temp = stack.method_7909();
            if (patt6478$temp instanceof MammalEmbryoItem) {
                class_1429 animal;
                MammalEmbryoItem embryoItem = (MammalEmbryoItem)patt6478$temp;
                if (entity instanceof class_1429 && PrehistoricEntityInfo.isMammal((class_1308)(animal = (class_1429)entity)) && !animal.method_6109()) {
                    if (ModCapabilities.hasEmbryo(animal)) {
                        return EventResult.interruptFalse();
                    }
                    if (player instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)player;
                        ModTriggers.IMPLANT_EMBRYO_TRIGGER.trigger(serverPlayer, stack);
                        ModCapabilities.startPregnancy(animal, embryoItem.getInfo());
                        if (!player.method_31549().field_7477) {
                            stack.method_7934(1);
                        }
                    } else {
                        Random random = player.method_6051();
                        for (int i = 0; i < 7; ++i) {
                            double x = animal.method_23317() + (double)(random.nextFloat() * animal.method_17681() * 2.0f) - (double)animal.method_17681();
                            double y = animal.method_23318() + 0.5 + (double)(random.nextFloat() * animal.method_17682());
                            double z = animal.method_23321() + (double)(random.nextFloat() * animal.method_17681() * 2.0f) - (double)animal.method_17681();
                            player.field_6002.method_8406((class_2394)class_2398.field_11251, x, y, z, random.nextGaussian() * 0.02, random.nextGaussian() * 0.02, random.nextGaussian() * 0.02);
                        }
                    }
                    return EventResult.interruptTrue();
                }
            } else if (stack.method_31574((class_1792)ModItems.WHIP.get())) {
                if (!player.field_6002.field_9236 && player.method_5765() && player.method_5854() == entity) {
                    stack.method_7956(1, (class_1309)player, p -> p.method_20236(hand));
                    player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
                    player.method_5783((class_3414)ModSounds.WHIP.get(), 1.0f, 1.0f);
                    return EventResult.interruptTrue();
                }
                player.method_5783((class_3414)ModSounds.WHIP.get(), 1.0f, 1.0f);
                return EventResult.pass();
            }
            return EventResult.pass();
        });
    }

    private static boolean isBreakableInAnuLair(class_2680 state) {
        return state.method_26204().method_9539().toLowerCase(Locale.ROOT).contains("grave") || state.method_27852((class_2248)ModBlocks.FAKE_OBSIDIAN.get()) || state.method_26164(class_3481.field_21952);
    }

    private static boolean isLivestock(class_1314 mob) {
        if (mob.method_5864().method_20210(ModEntityTypeTags.LIVESTOCK)) {
            return true;
        }
        String className = "";
        try {
            className = mob.getClass().getSimpleName();
        }
        catch (Exception e) {
            FossilMod.LOGGER.debug(e.getMessage());
        }
        return !className.isEmpty() && (className.contains("Cow") || className.contains("Sheep") || className.contains("Pig") && !className.contains("piglin") || className.contains("Chicken") || className.contains("Rabbit") || className.contains("Peacock") || className.contains("Goat") || className.contains("Ferret") || className.contains("Hedgehog") || className.contains("Peahen") || className.contains("Peafowl") || className.contains("Sow") || className.contains("Hog"));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void growEntity(EntityInfo embryo, class_1309 parent) {
        class_1297 newEntity;
        class_3218 level;
        block17: {
            block15: {
                class_1496 newHorse;
                block16: {
                    Random random = parent.field_6002.field_9229;
                    if (parent.field_6002.field_9236) {
                        int i = 0;
                        while (true) {
                            if (i >= 7) {
                                return;
                            }
                            double d = random.nextGaussian() * 0.02;
                            double e = random.nextGaussian() * 0.02;
                            double f = random.nextGaussian() * 0.02;
                            parent.field_6002.method_8406((class_2394)class_2398.field_11201, parent.method_23322(1.0), parent.method_23319() + 0.5, parent.method_23325(1.0), d, e, f);
                            ++i;
                        }
                    }
                    level = (class_3218)parent.field_6002;
                    newEntity = embryo.entityType().method_5883((class_1937)level);
                    int result = random.nextInt(100);
                    if (!(newEntity instanceof class_1496)) break block15;
                    newHorse = (class_1496)newEntity;
                    if (!(parent instanceof class_1496)) break block16;
                    class_1496 parentHorse = (class_1496)parent;
                    if (!parent.getClass().equals(newEntity.getClass())) break block16;
                    if (result < 10) {
                        if (parentHorse.method_6768() != null) {
                            newHorse.method_6732(parentHorse.method_6768());
                            newHorse.method_6766(true);
                        }
                        break block17;
                    } else {
                        newEntity = parentHorse.method_5613(level, (class_1296)parentHorse);
                    }
                    break block17;
                }
                newHorse.method_5943((class_5425)level, level.method_8404(newHorse.method_24515()), class_3730.field_16466, null, null);
                break block17;
            }
            if (newEntity instanceof Quagga) {
                Quagga newQuagga = (Quagga)newEntity;
                double health = parent.method_5996(class_5134.field_23716).method_6201() + newQuagga.method_5996(class_5134.field_23716).method_6201() + newQuagga.method_5996(class_5134.field_23716).method_6201();
                newQuagga.method_5996(class_5134.field_23716).method_6192(health / 3.0);
                double speed = parent.method_5996(class_5134.field_23719).method_6201() + newQuagga.method_5996(class_5134.field_23719).method_6201() + newQuagga.method_5996(class_5134.field_23719).method_6201();
                newQuagga.method_5996(class_5134.field_23719).method_6192(speed / 3.0);
            } else if (newEntity instanceof class_1296) {
                class_1296 ageableMob = (class_1296)newEntity;
                if (parent.getClass().equals(newEntity.getClass())) {
                    newEntity = ((class_1296)parent).method_5613(level, (class_1296)parent);
                } else {
                    ageableMob.method_5943((class_5425)level, level.method_8404(parent.method_24515()), class_3730.field_16466, null, null);
                }
            }
        }
        if (newEntity instanceof Prehistoric) {
            Prehistoric prehistoric = (Prehistoric)newEntity;
            class_1657 player = level.method_18460((class_1297)parent, 15.0);
            if (player != null) {
                prehistoric.method_6170(player);
            }
            prehistoric.setAgeInDays(0);
        } else if (newEntity instanceof class_1429) {
            ((class_1429)newEntity).method_7217(true);
        }
        newEntity.method_5808(parent.method_23317(), parent.method_23318(), parent.method_23321(), parent.method_36454(), parent.method_36455());
        level.method_8649(newEntity);
    }
}

