/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.block.entity;

import com.github.teamfossilsarcheology.fossil.block.ModBlocks;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.AnuBarrierFaceBlock;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.AnuBarrierOriginBlock;
import com.github.teamfossilsarcheology.fossil.block.entity.ModBlockEntities;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnuBarrierBlockEntity
extends class_2586 {
    public static final int MAX_SIZE = 20;
    public static final int STATE_DISABLED = 0;
    public static final int STATE_ENABLED = 1;
    public static final int STATE_GROWING = 2;
    public static final int STATE_SHRINKING = 3;
    public static final float DURATION = 60.0f;
    public int radius = 1;
    public int height = 1;
    private int state = 0;
    private int barrierTimer;

    public AnuBarrierBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)ModBlockEntities.ANU_BARRIER.get(), blockPos, blockState);
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, AnuBarrierBlockEntity blockEntity) {
        AnuBarrierBlockEntity.tick(blockEntity);
    }

    public static void clientTick(class_1937 level, class_2338 pos, class_2680 state, AnuBarrierBlockEntity blockEntity) {
        AnuBarrierBlockEntity.tick(blockEntity);
    }

    private static void tick(AnuBarrierBlockEntity blockEntity) {
        if (blockEntity.state == 2) {
            ++blockEntity.barrierTimer;
            if ((float)blockEntity.barrierTimer > 60.0f) {
                blockEntity.state = 1;
                blockEntity.method_5431();
            }
        } else if (blockEntity.state == 3) {
            --blockEntity.barrierTimer;
            if (blockEntity.barrierTimer < 0) {
                blockEntity.state = 0;
                blockEntity.method_5431();
            }
        }
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("Height", this.height);
        tag.method_10569("Radius", this.radius);
        tag.method_10569("State", this.state);
        tag.method_10569("Timer", this.barrierTimer);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.height = tag.method_10550("Height");
        this.radius = tag.method_10550("Radius");
        this.state = tag.method_10550("State");
        this.barrierTimer = tag.method_10550("Timer");
    }

    @NotNull
    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    private void spawnBarrier(class_2338 pos, class_2680 state) {
        class_2338 pos1;
        class_2350 direction = ((class_2350)state.method_11654((class_2769)AnuBarrierOriginBlock.FACING)).method_10170();
        this.radius = 0;
        this.height = 1;
        while (this.radius < 20 && !this.field_11863.method_8320(pos1 = pos.method_10079(direction, this.radius + 1)).method_26216((class_1922)this.field_11863, pos1)) {
            ++this.radius;
        }
        while (this.height < 20 && this.field_11863.method_22347(pos.method_10086(this.height))) {
            ++this.height;
        }
        class_2338.class_2339 mutable = pos.method_25503();
        for (int y = 0; y < this.height; ++y) {
            for (int x = -this.radius; x <= this.radius; ++x) {
                if (!this.field_11863.method_22347((class_2338)mutable.method_10103(pos.method_10263() + direction.method_10148() * x, pos.method_10264() + y, pos.method_10260() + direction.method_10165() * x))) continue;
                this.field_11863.method_8652((class_2338)mutable, ((AnuBarrierFaceBlock)((Object)ModBlocks.ANU_BARRIER_FACE.get())).method_34725(state), 18);
            }
        }
    }

    private void destroyBarrier(class_2338 pos, class_2680 state) {
        class_2350 direction = ((class_2350)state.method_11654((class_2769)AnuBarrierOriginBlock.FACING)).method_10170();
        class_2338.class_2339 mutable = pos.method_25503();
        for (int y = 0; y < this.height; ++y) {
            for (int x = -this.radius; x <= this.radius; ++x) {
                class_2680 barrierState = this.field_11863.method_8320((class_2338)mutable.method_10103(pos.method_10263() + direction.method_10148() * x, pos.method_10264() + y, pos.method_10260() + direction.method_10165() * x));
                if (!barrierState.method_27852((class_2248)ModBlocks.ANU_BARRIER_FACE.get())) continue;
                this.field_11863.method_8652((class_2338)mutable, class_2246.field_10124.method_9564(), 18);
            }
        }
    }

    public boolean isEnabled() {
        return this.state == 2 || this.state == 1;
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public void enable() {
        if (!this.isEnabled()) {
            this.spawnBarrier(this.method_11016(), this.method_11010());
        }
        this.state = 2;
        this.barrierTimer = 0;
        this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 18);
    }

    public void disable() {
        this.state = 3;
        this.destroyBarrier(this.method_11016(), this.method_11010());
        this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 18);
    }

    public int getState() {
        return this.state;
    }

    public int getBarrierTimer() {
        return this.barrierTimer;
    }
}

