/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug.instruction;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.InstructionTab;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.instruction.Instruction;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import software.bernie.geckolib3.core.util.Color;

public class InstructionRenderUtil {
    public static void renderTextBatch(class_4587 poseStack, class_310 minecraft, List<Pair<class_243, Instruction>> positions) {
        RenderSystem.enableTexture();
        RenderSystem.depthMask((boolean)true);
        class_4597.class_4598 bufferSource = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        poseStack.method_22903();
        for (int i = 0; i < positions.size(); ++i) {
            String string;
            class_243 pos = (class_243)positions.get(i).left();
            Instruction instruction = (Instruction)positions.get(i).right();
            poseStack.method_22903();
            poseStack.method_22904(pos.field_1352, pos.field_1351, pos.field_1350);
            poseStack.method_34425(new class_1159(minecraft.field_1773.method_19418().method_23767()));
            poseStack.method_22905(0.02f, -0.02f, 0.02f);
            poseStack.method_22905(-1.0f, 1.0f, 1.0f);
            if (instruction instanceof Instruction.Idle) {
                Instruction.Idle idle = (Instruction.Idle)instruction;
                string = String.format("%s: %s (%s seconds)", new Object[]{i, instruction.type, idle.duration / 20});
            } else if (instruction instanceof Instruction.AttachTo) {
                Instruction.AttachTo attachTo = (Instruction.AttachTo)instruction;
                string = String.format("%s: %s %s", new Object[]{i, instruction.type, attachTo.direction});
            } else {
                string = String.format("%s: %s", new Object[]{i, instruction.type});
            }
            float g = (float)(-minecraft.field_1772.method_1727(string)) / 2.0f;
            int color = -1;
            if (InstructionTab.highlightInstruction == instruction) {
                color = Color.RED.hashCode();
            }
            minecraft.field_1772.method_27521(string, g, 0.0f, color, false, poseStack.method_23760().method_23761(), (class_4597)bufferSource, true, 0, 0xF000F0);
            poseStack.method_22909();
        }
        bufferSource.method_22993();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableDepthTest();
        poseStack.method_22909();
    }

    public static void renderFloatingText(class_4587 poseStack, class_310 minecraft, String text, class_243 pos) {
        RenderSystem.enableTexture();
        RenderSystem.depthMask((boolean)true);
        class_4597.class_4598 bufferSource = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        poseStack.method_22903();
        poseStack.method_22904(pos.field_1352, pos.field_1351, pos.field_1350);
        poseStack.method_34425(new class_1159(minecraft.field_1773.method_19418().method_23767()));
        poseStack.method_22905(0.02f, -0.02f, 0.02f);
        poseStack.method_22905(-1.0f, 1.0f, 1.0f);
        float g = (float)(-minecraft.field_1772.method_1727(text)) / 2.0f;
        int color = -1;
        minecraft.field_1772.method_27521(text, g, 0.0f, color, false, poseStack.method_23760().method_23761(), (class_4597)bufferSource, true, 0, 0xF000F0);
        bufferSource.method_22993();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableDepthTest();
        poseStack.method_22909();
    }

    private static float nanoToPulse(long finishNanoTime) {
        return 0.1f + 0.5f * Math.abs(class_3532.method_15374((float)((float)finishNanoTime / 5.0E8f)));
    }

    public static void renderWholeBox(class_4587 poseStack, class_2338 pos, Color color, long finishNanoTime) {
        InstructionRenderUtil.renderWholeBox(poseStack, pos, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, InstructionRenderUtil.nanoToPulse(finishNanoTime));
    }

    public static void renderWholeBox(class_4587 poseStack, class_2338 pos, float r, float g, float b, float a) {
        poseStack.method_22903();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        poseStack.method_22904((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
        class_1159 matrix4f = poseStack.method_23760().method_23761();
        class_289 tesselator = class_289.method_1348();
        class_287 bufferBuilder = tesselator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27380, class_290.field_1576);
        float maxX = 1.0f;
        float maxY = 1.0f;
        float maxZ = 1.0f;
        bufferBuilder.method_22918(matrix4f, 0.0f, 0.0f, 0.0f).method_22915(r * 0.7f, g * 0.7f, b * 0.7f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, 0.0f, 0.0f, maxZ).method_22915(r * 0.7f, g * 0.7f, b * 0.7f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, 0.0f, maxY, 0.0f).method_22915(r * 0.7f, g * 0.7f, b * 0.7f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, 0.0f, maxY, maxZ).method_22915(r * 0.7f, g * 0.7f, b * 0.7f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, maxX, maxY, maxZ).method_22915(r * 0.7f, g * 0.7f, b * 0.7f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, 0.0f, 0.0f, maxZ).method_22915(r * 0.7f, g * 0.7f, b * 0.7f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, maxX, 0.0f, maxZ).method_22915(r * 0.7f, g * 0.7f, b * 0.7f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, 0.0f, 0.0f, 0.0f).method_22915(r * 0.7f, g * 0.7f, b * 0.7f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, maxX, 0.0f, 0.0f).method_22915(r * 0.7f, g * 0.7f, b * 0.7f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, 0.0f, maxY, 0.0f).method_22915(r * 0.7f, g * 0.7f, b * 0.7f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, maxX, maxY, 0.0f).method_22915(r * 0.7f, g * 0.7f, b * 0.7f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, maxX, maxY, maxZ).method_22915(r * 0.7f, g * 0.7f, b * 0.7f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, maxX, 0.0f, 0.0f).method_22915(r * 0.7f, g * 0.7f, b * 0.7f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, maxX, 0.0f, maxZ).method_22915(r * 0.7f, g * 0.7f, b * 0.7f, a).method_1344();
        tesselator.method_1350();
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        poseStack.method_22909();
    }

    public static void renderDownArrow(class_4587 poseStack, class_243 pos, Color color, float scale, long finishNanoTime) {
        float seconds = (float)finishNanoTime / 1.0E9f;
        InstructionRenderUtil.renderArrow(poseStack, pos, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f, true, scale, seconds * 120.0f % 360.0f, class_3532.method_15374((float)seconds) * 0.25f);
    }

    public static void renderArrow(class_4587 poseStack, class_243 pos, Color color, float yRot) {
        InstructionRenderUtil.renderArrow(poseStack, pos, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f, false, 1.0f, yRot, 0.0f);
    }

    public static void renderArrow(class_4587 poseStack, class_243 pos, float r, float g, float b, float a, boolean down, float scale, float yRot, float bounce) {
        poseStack.method_22903();
        poseStack.method_22904(pos.method_10216(), pos.method_10214() + (double)bounce, pos.method_10215());
        poseStack.method_22907(class_1160.field_20705.method_23214(yRot));
        poseStack.method_22905(scale, scale, scale);
        if (!down) {
            float i = 0.3f;
            float o = -0.2f;
            poseStack.method_22904(0.0, (double)i, (double)o);
            poseStack.method_22907(class_1160.field_20703.method_23214(90.0f));
            poseStack.method_22905(0.5f, 0.5f, 0.5f);
            poseStack.method_22904(0.0, (double)(-i), (double)(-o));
        }
        class_1159 matrix4f = poseStack.method_23760().method_23761();
        class_289 tesselator = class_289.method_1348();
        class_287 bufferBuilder = tesselator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
        float min = -0.25f;
        float max = 0.25f;
        bufferBuilder.method_22918(matrix4f, 0.0f, min, 0.0f).method_22915(r * 0.6f, g * 0.6f, b * 0.6f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, max, max, max).method_22915(r * 0.7f, g * 0.7f, b * 0.7f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, min, max, max).method_22915(r * 0.7f, g * 0.7f, b * 0.7f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, min, max, min).method_22915(r * 0.7f, g * 0.7f, b * 0.7f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, max, max, min).method_22915(r * 0.7f, g * 0.7f, b * 0.7f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, max, max, max).method_22915(r * 0.7f, g * 0.7f, b * 0.7f, a).method_1344();
        tesselator.method_1350();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22918(matrix4f, max, max, min).method_22915(r * 0.6f, g * 0.6f, b * 0.6f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, min, max, min).method_22915(r * 0.6f, g * 0.6f, b * 0.6f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, min, max, max).method_22915(r * 0.6f, g * 0.6f, b * 0.6f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, max, max, max).method_22915(r * 0.6f, g * 0.6f, b * 0.6f, a).method_1344();
        tesselator.method_1350();
        float minY = max;
        float maxY = minY + 0.5f;
        float minU = (min /= 2.0f) - 0.05f;
        float maxU = (max /= 2.0f) + 0.05f;
        bufferBuilder.method_1328(class_293.class_5596.field_27380, class_290.field_1576);
        bufferBuilder.method_22918(matrix4f, min, minY, min).method_22915(r * 0.6f, g * 0.6f, b * 0.6f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, min, minY, max).method_22915(r * 0.6f, g * 0.6f, b * 0.6f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, minU, maxY, minU).method_22915(r * 0.85f, g * 0.85f, b * 0.85f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, minU, maxY, maxU).method_22915(r * 0.85f, g * 0.85f, b * 0.85f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, maxU, maxY, maxU).method_22915(r * 0.85f, g * 0.85f, b * 0.85f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, min, minY, max).method_22915(r * 0.6f, g * 0.6f, b * 0.6f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, max, minY, max).method_22915(r * 0.6f, g * 0.6f, b * 0.6f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, min, minY, min).method_22915(r * 0.6f, g * 0.6f, b * 0.6f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, max, minY, min).method_22915(r * 0.6f, g * 0.6f, b * 0.6f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, minU, maxY, minU).method_22915(r * 0.85f, g * 0.85f, b * 0.85f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, maxU, maxY, minU).method_22915(r * 0.85f, g * 0.85f, b * 0.85f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, maxU, maxY, maxU).method_22915(r * 0.85f, g * 0.85f, b * 0.85f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, max, minY, min).method_22915(r * 0.6f, g * 0.6f, b * 0.6f, a).method_1344();
        bufferBuilder.method_22918(matrix4f, max, minY, max).method_22915(r * 0.6f, g * 0.6f, b * 0.6f, a).method_1344();
        tesselator.method_1350();
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        poseStack.method_22909();
    }
}

