/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai;

import com.github.teamfossilsarcheology.fossil.block.entity.FeederBlockEntity;
import com.github.teamfossilsarcheology.fossil.entity.ai.MoveToFoodGoal;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategory;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.util.Util;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_4538;

public class EatFromFeederGoal
extends MoveToFoodGoal {
    private final int chunkRadius;

    public EatFromFeederGoal(Prehistoric entity) {
        super(entity, 0.75, 32);
        this.chunkRadius = 2;
    }

    public EatFromFeederGoal(Prehistoric entity, int chunkRadius) {
        super(entity, 0.75, 32);
        this.chunkRadius = chunkRadius;
    }

    @Override
    public void method_6268() {
        class_2586 class_25862;
        super.method_6268();
        if (this.isReachedTarget() && (class_25862 = this.entity.field_6002.method_8321(this.targetPos)) instanceof FeederBlockEntity) {
            FeederBlockEntity feeder = (FeederBlockEntity)class_25862;
            if (Math.abs(this.entity.field_6225) <= 0.08f) {
                ++this.feedingTicks;
                if (this.entity.getHunger() < this.entity.getMaxHunger()) {
                    feeder.feedDinosaur(this.entity);
                }
                this.entity.method_6025(0.1f);
                if (this.entity.field_6002.method_8510() > this.animEndTick) {
                    AnimationInfo animationInfo = this.entity.nextEatingAnimation();
                    this.entity.getAnimationLogic().triggerAnimation("Movement/Idle", animationInfo, AnimationCategory.EAT);
                    this.animEndTick = (long)((double)this.entity.field_6002.method_8510() + animationInfo.animation.animationLength);
                }
            }
        }
    }

    @Override
    protected boolean isValidTarget(class_4538 level, class_2338 pos) {
        return this.isValidTarget(pos, level.method_8321(pos));
    }

    protected boolean isValidTarget(class_2338 pos, class_2586 blockEntity) {
        FeederBlockEntity feeder;
        if (this.avoidCache.contains(pos.method_10063())) {
            return false;
        }
        if (!(blockEntity instanceof FeederBlockEntity) || (feeder = (FeederBlockEntity)blockEntity).isEmpty(this.entity.data().diet())) {
            return false;
        }
        return Util.canSeeFood(this.entity, pos) || (double)this.entity.getHunger() < (double)this.entity.getMaxHunger() * 0.5;
    }

    @Override
    protected boolean findNearestBlock() {
        class_2338 mobPos = this.entity.method_24515();
        Optional<class_2338> target = class_1923.method_19280((class_1923)new class_1923(mobPos), (int)this.chunkRadius).flatMap(chunkPos -> this.entity.field_6002.method_8497(chunkPos.field_9181, chunkPos.field_9180).method_12214().entrySet().stream()).filter(entry -> this.isValidTarget((class_2338)entry.getKey(), (class_2586)entry.getValue())).map(Map.Entry::getKey).min(Comparator.comparingInt(pos -> pos.method_19455((class_2382)mobPos)));
        if (target.isPresent()) {
            this.setTargetPos(target.get());
            return true;
        }
        this.clearTicks = !this.avoidCache.isEmpty() ? 400 : 0;
        return false;
    }
}

