/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.animation;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public record AnimationCategory(String name, @Nullable AnimationCategory backup, float chance, int transitionLength, Predicate<String> predicate) {
    public static final List<AnimationCategory> CATEGORIES = new ArrayList<AnimationCategory>();
    public static final AnimationCategory NONE = AnimationCategory.register("none", null, s -> s.contains("placeholder"));
    public static final AnimationCategory IDLE = AnimationCategory.register("idle", null);
    public static final AnimationCategory FALL = AnimationCategory.register("fall", IDLE);
    public static final AnimationCategory ATTACK = AnimationCategory.register("attack", IDLE);
    public static final AnimationCategory EAT = AnimationCategory.register("eat", IDLE);
    public static final AnimationCategory BEACHED = AnimationCategory.register("beached", IDLE, 0.0f, 5);
    public static final AnimationCategory SLEEP = AnimationCategory.register("sleep", IDLE, 0.05f, 20);
    public static final AnimationCategory SIT = AnimationCategory.register("sit", SLEEP, 0.2f, 20);
    public static final AnimationCategory KNOCKOUT = AnimationCategory.register("knockout", SLEEP, 0.0f, 15);
    public static final AnimationCategory FLY = AnimationCategory.register("fly", IDLE, s -> s.contains("fly") && !s.contains("fast"));
    public static final AnimationCategory FLY_FAST = AnimationCategory.register("fly_fast", FLY, s -> s.contains("fly") && s.contains("fast"));
    public static final AnimationCategory WALK = AnimationCategory.register("walk", IDLE);
    public static final AnimationCategory SPRINT = AnimationCategory.register("sprint", WALK, s -> s.contains("sprint") || s.contains("run"));
    public static final AnimationCategory CLIMB = AnimationCategory.register("climb", WALK);
    public static final AnimationCategory SWIM = AnimationCategory.register("swim", WALK, s -> s.contains("swim") && !s.contains("fast"));
    public static final AnimationCategory SWIM_FAST = AnimationCategory.register("swim_fast", SWIM, s -> s.contains("swim") && s.contains("fast"));

    public boolean canMapAnimation(String key) {
        return this.predicate.test(key) && !key.contains("!") && !key.contains("demo");
    }

    public static AnimationCategory register(String name, @Nullable AnimationCategory backup) {
        return AnimationCategory.register(name, backup, 1.0f, 5, s -> s.contains(name));
    }

    public static AnimationCategory register(String name, @Nullable AnimationCategory backup, Predicate<String> test) {
        return AnimationCategory.register(name, backup, 1.0f, 5, test);
    }

    public static AnimationCategory register(String name, @Nullable AnimationCategory backup, float chance, int transitionLength) {
        return AnimationCategory.register(name, backup, chance, transitionLength, s -> s.contains(name));
    }

    public static AnimationCategory register(String name, @Nullable AnimationCategory backup, float chance, int transitionLength, Predicate<String> test) {
        AnimationCategory animationCategory = new AnimationCategory(name, backup, chance, transitionLength, test);
        CATEGORIES.add(animationCategory);
        return animationCategory;
    }
}

