/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.system;

import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.OrderType;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfoAI;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFlying;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricSwimming;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.SleepSystem;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_3481;
import org.jetbrains.annotations.Nullable;

public class FlyingSleepSystem
extends SleepSystem {
    private final PrehistoricFlying mob;
    private class_2338 landingPos;
    private long nextTryTick = -1L;

    public FlyingSleepSystem(PrehistoricFlying mob) {
        super(mob);
        this.mob = mob;
    }

    @Override
    protected void trySleeping() {
        if (this.nextTryTick == -1L) {
            if (!this.mob.method_6581() && !this.mob.isTakingOff()) {
                super.trySleeping();
                return;
            }
            if (this.mob.aiActivityType() == PrehistoricEntityInfoAI.Activity.BOTH) {
                if (this.mob.method_6051().method_43048(1200) == 0 && this.wantsToSleep() && this.canSleep()) {
                    this.trySleepingOrLanding();
                }
            } else if (this.mob.aiActivityType() != PrehistoricEntityInfoAI.Activity.NO_SLEEP && this.mob.method_6051().method_43048(200) == 0 && this.wantsToSleep() && this.canSleep()) {
                this.trySleepingOrLanding();
            }
        } else if (this.nextTryTick == this.mob.field_6002.method_8510()) {
            this.trySleepingOrLanding();
        }
    }

    private void trySleepingOrLanding() {
        if (this.mob.method_6581() || this.mob.isTakingOff()) {
            this.landingPos = this.findGroundTarget();
            if (this.landingPos != null) {
                this.mob.moveTo(class_243.method_24953((class_2382)this.landingPos), true, true);
                this.nextTryTick = this.mob.field_6002.method_8510() + 100L;
            } else {
                this.nextTryTick = this.mob.field_6002.method_8510() + 20L;
            }
        } else {
            this.setSleeping(true);
            this.nextTryTick = -1L;
        }
    }

    @Override
    protected boolean canSleep() {
        if (PrehistoricSwimming.isOverWater((class_1309)this.mob)) {
            return false;
        }
        if (this.isDisabled() || this.mob.hasTarget() || this.mob.method_6065() != null || this.mob.getCurrentOrder() == OrderType.FOLLOW || this.mob.method_5782()) {
            return false;
        }
        if (this.mob.isDeadlyHungry()) {
            return false;
        }
        return !this.mob.method_5799();
    }

    @Override
    public void serverTick() {
        super.serverTick();
        if (this.landingPos != null) {
            if (this.mob.method_6581()) {
                this.mob.moveTo(class_243.method_24953((class_2382)this.landingPos), true, true);
            } else {
                this.landingPos = null;
            }
        }
    }

    @Override
    public void setSleeping(boolean sleeping) {
        super.setSleeping(sleeping);
        if (sleeping) {
            this.landingPos = null;
        }
    }

    private class_2338 findGroundTarget() {
        if (!this.mob.field_6002.method_22347(this.mob.method_24515().method_10074())) {
            return this.mob.method_24515().method_10074();
        }
        if (!this.mob.field_6002.method_22347(this.mob.method_24515().method_10087(2))) {
            return this.mob.method_24515().method_10087(2);
        }
        class_2338 sleepPos = this.findTreePosition(16);
        if (sleepPos == null) {
            sleepPos = this.mob.findLandPosition(false);
        }
        return sleepPos;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    private class_2338 findTreePosition(int radius) {
        dx = 0;
        dz = -1;
        mutable = new class_2338.class_2339();
        mutable2 = new class_2338.class_2339();
        i = 0;
        x = 0;
        z = 0;
        while ((double)i < Math.pow(radius * 2, 2.0)) {
            if (-radius < x && x <= radius && -radius < z && z <= radius) {
                bX = x + this.mob.method_24515().method_10263();
                bZ = z + this.mob.method_24515().method_10260();
                height = this.mob.field_6002.method_8624(class_2902.class_2903.field_13197, bX, bZ);
                leaves = this.mob.field_6002.method_8624(class_2902.class_2903.field_13203, bX, bZ);
                if (!((double)height > this.mob.method_23318())) {
                    mutable.method_10103(bX, height - 1, bZ);
                    if (this.mob.field_6002.method_8320((class_2338)mutable).method_26164(class_3481.field_15503)) {
                        if (height > leaves + 3) {
                            return mutable.method_10062();
                        }
                        if (this.mob.field_6002.method_8320((class_2338)mutable2.method_10103(bX, leaves, bZ)).method_26164(class_3481.field_15475)) {
                            for (class_2350 dir : class_2350.class_2353.field_11062) {
                                if (this.mob.field_6002.method_8624(class_2902.class_2903.field_13197, bX + dir.method_10148(), bZ + dir.method_10165()) >= height) continue;
                                return mutable.method_10062();
                            }
                        } else {
                            ** GOTO lbl-1000
                        }
                    } else {
                        ** GOTO lbl-1000
                    }
                }
            } else lbl-1000:
            // 6 sources

            {
                if (x == z || x < 0 && x == -z || x > 0 && x == 1 - z) {
                    t = dx;
                    dx = -dz;
                    dz = t;
                }
                x += dx;
                z += dz;
            }
            ++i;
        }
        return null;
    }
}

