/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.food;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.client.ResourceLoader;
import com.github.teamfossilsarcheology.fossil.food.Diet;
import com.github.teamfossilsarcheology.fossil.food.FoodType;
import com.github.teamfossilsarcheology.fossil.network.S2CSyncFoodMappingsMessage;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public class FoodMappingsManager
extends ResourceLoader<MapPair> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final FoodMappingsManager INSTANCE = new FoodMappingsManager();
    private Map<FoodType, Set<class_6862<class_1792>>> itemTags = ImmutableMap.of();
    private Map<FoodType, Set<class_6862<class_1299<?>>>> entityTags = ImmutableMap.of();
    private Map<FoodType, Map<class_1792, Integer>> itemValues = ImmutableMap.of();
    private Map<FoodType, Map<class_1299<?>, Integer>> entityValues = ImmutableMap.of();
    private Map<Diet, TreeSet<class_1792>> items;
    private Set<class_1299<?>> entities = ImmutableSet.of();
    private final List<Consumer<FoodMappingsManager>> listeners = new ArrayList<Consumer<FoodMappingsManager>>();

    public FoodMappingsManager() {
        super(class_3264.field_14190, "food", "json");
    }

    @NotNull
    protected MapPair prepare(class_3300 resourceManager, class_3695 profiler) {
        ImmutableMap.Builder itemTagsBuilder = new ImmutableMap.Builder();
        ImmutableMap.Builder entityTagsBuilder = new ImmutableMap.Builder();
        ImmutableMap.Builder itemBuilder = new ImmutableMap.Builder();
        ImmutableMap.Builder entityBuilder = new ImmutableMap.Builder();
        ImmutableSet.Builder setBuilder = new ImmutableSet.Builder();
        for (FoodType type : FoodType.values()) {
            ObjectOpenHashSet itemTags = new ObjectOpenHashSet();
            ObjectOpenHashSet entityTags = new ObjectOpenHashSet();
            Object2IntOpenHashMap innerItemBuilder = new Object2IntOpenHashMap();
            Object2IntOpenHashMap innerEntityBuilder = new Object2IntOpenHashMap();
            for (class_2960 resourceLocation : this.listResources(resourceManager, type.name().toLowerCase() + ".json")) {
                Optional opt = resourceManager.method_14486(resourceLocation);
                if (opt.isEmpty()) continue;
                try {
                    InputStream inputStream = ((class_3298)opt.get()).method_14482();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                        JsonObject object;
                        JsonArray entries;
                        JsonElement jsonElement = (JsonElement)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonElement.class);
                        if (jsonElement == null) continue;
                        JsonObject root = jsonElement.getAsJsonObject();
                        if (root.has("items")) {
                            entries = root.get("items").getAsJsonArray();
                            for (JsonElement entry : entries) {
                                object = entry.getAsJsonObject();
                                if (object.has("item")) {
                                    class_2378.field_11142.method_17966(new class_2960(object.get("item").getAsString())).ifPresent(arg_0 -> FoodMappingsManager.lambda$prepare$0(object, (Map)innerItemBuilder, type, arg_0));
                                    continue;
                                }
                                if (!object.has("tag")) continue;
                                itemTags.add(class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)new class_2960(object.get("tag").getAsString())));
                            }
                        }
                        if (!root.has("entities")) continue;
                        entries = root.get("entities").getAsJsonArray();
                        for (JsonElement entry : entries) {
                            object = entry.getAsJsonObject();
                            if (object.has("entity")) {
                                class_2378.field_11145.method_17966(new class_2960(object.get("entity").getAsString())).ifPresent(arg_0 -> FoodMappingsManager.lambda$prepare$1(setBuilder, object, (Map)innerEntityBuilder, arg_0));
                                continue;
                            }
                            if (!object.has("tag")) continue;
                            entityTags.add(class_6862.method_40092((class_5321)class_2378.field_25107, (class_2960)new class_2960(object.get("tag").getAsString())));
                        }
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    FossilMod.LOGGER.error("Failed to load food values in {}: {}", (Object)resourceLocation, (Object)e);
                    throw new RuntimeException(e);
                }
            }
            itemTagsBuilder.put((Object)type, (Object)itemTags);
            entityTagsBuilder.put((Object)type, (Object)entityTags);
            itemBuilder.put((Object)type, (Object)innerItemBuilder);
            entityBuilder.put((Object)type, (Object)innerEntityBuilder);
        }
        return new MapPair((Map<FoodType, Map<class_1792, Integer>>)itemBuilder.build(), (Map<FoodType, Map<class_1299<?>, Integer>>)entityBuilder.build(), (Set<class_1299<?>>)setBuilder.build(), (Map<FoodType, Set<class_6862<class_1792>>>)itemTagsBuilder.build(), (Map<FoodType, Set<class_6862<class_1299<?>>>>)entityTagsBuilder.build());
    }

    protected void apply(MapPair mapPair, class_3300 resourceManager, class_3695 profiler) {
        this.itemValues = mapPair.items;
        this.entityValues = mapPair.entities;
        this.entities = mapPair.allEntities;
        this.itemTags = mapPair.itemTags;
        this.entityTags = mapPair.entityTags;
        Function<Map, Integer> f = map -> map.values().stream().map(m -> m.keySet().size()).reduce(Integer::sum).orElse(0);
        FossilMod.LOGGER.info("Loaded food values: (items: {}) (entities: {}, {}) (Tags: {}, {})", (Object)this.itemValues.values().stream().mapToInt(m -> m.keySet().size()).sum(), (Object)this.entityValues.values().stream().mapToInt(m -> m.keySet().size()).sum(), (Object)this.entities.size(), (Object)this.itemTags.values().stream().mapToInt(Collection::size).sum(), (Object)this.entityTags.values().stream().mapToInt(Collection::size).sum());
        this.listeners.forEach(listener -> listener.accept(this));
        this.generateCache();
    }

    public void listen(Consumer<FoodMappingsManager> listener) {
        this.listeners.add(listener);
    }

    public void replaceValues(Map<FoodType, Map<class_1792, Integer>> itemValues, Map<FoodType, Map<class_1299<?>, Integer>> entityValues, Set<class_1299<?>> entities) {
        FossilMod.LOGGER.info("Replacing client food values: (items: {}) (entities: {}, {})", (Object)itemValues.values().stream().mapToInt(m -> m.keySet().size()).sum(), (Object)entityValues.values().stream().mapToInt(m -> m.keySet().size()).sum(), (Object)entities.size());
        this.itemValues = itemValues;
        this.entityValues = entityValues;
        this.entities = entities;
        this.generateCache();
    }

    private void generateCache() {
        Comparator<class_1792> byId = Comparator.comparingInt(item -> class_1792.method_7880((class_1792)item.method_8389()));
        Supplier<TreeSet> set = () -> new TreeSet(byId);
        this.items = Arrays.stream(Diet.values()).collect(Collectors.toMap(Function.identity(), diet -> (TreeSet)diet.flags().stream().flatMap(type -> this.itemValues.get(type).keySet().stream()).collect(Collectors.toCollection(set))));
    }

    public Map<class_1792, Integer> getItemValues(FoodType type) {
        return this.itemValues.get((Object)type);
    }

    public Map<class_1299<?>, Integer> getEntityValues(FoodType type) {
        return this.entityValues.get((Object)type);
    }

    public boolean hasEntityEntry(class_1299<?> entityType) {
        return this.entities.contains(entityType);
    }

    public void addItem(FoodType type, class_1792 item, int value) {
        this.itemValues.get((Object)type).put(item, value);
    }

    public void addEntity(FoodType type, class_1299<?> entityType, int value) {
        this.entityValues.get((Object)type).put(entityType, value);
    }

    public Map<Diet, TreeSet<class_1792>> getItemCache() {
        if (this.items == null) {
            this.generateCache();
        }
        return this.items;
    }

    public void addMeat(class_1299<?> entity, int food) {
        this.addEntity(FoodType.MEAT, entity, food);
    }

    public void addMeat(class_1935 itemLike) {
        int food = itemLike.method_8389().method_19264() != null ? itemLike.method_8389().method_19264().method_19230() * 7 : 20;
        this.addMeat(itemLike, food);
    }

    public void addMeat(class_1935 itemLike, int food) {
        this.addItem(FoodType.MEAT, itemLike.method_8389(), food);
    }

    public void addFish(class_1299<?> entity, int food) {
        this.addEntity(FoodType.FISH, entity, food);
    }

    public void addFish(class_1792 item) {
        int food = item.method_19264() != null ? item.method_19264().method_19230() * 7 : 10;
        this.addFish(item, food);
    }

    public void addFish(class_1792 item, int food) {
        this.addItem(FoodType.FISH, item, food);
    }

    public void addEgg(class_1792 item) {
        int food = item.method_19264() != null ? item.method_19264().method_19230() * 7 : 10;
        this.addEgg(item, food);
    }

    public void addEgg(class_1792 item, int food) {
        this.addItem(FoodType.EGG, item, food);
    }

    public void addPlant(class_2248 block, int food) {
        this.addItem(FoodType.PLANT, block.method_8389(), food);
    }

    public void addPlant(class_1792 item) {
        int food = item.method_19264() != null ? item.method_19264().method_19230() * 5 : 17;
        this.addPlant(item, food);
    }

    public void addPlant(class_1792 item, int food) {
        this.addItem(FoodType.PLANT, item, food);
    }

    private void loadTags() {
        ImmutableMap.Builder itemBuilder = new ImmutableMap.Builder();
        ImmutableMap.Builder entityBuilder = new ImmutableMap.Builder();
        ImmutableSet.Builder setBuilder = new ImmutableSet.Builder();
        setBuilder.addAll(this.entities);
        for (FoodType type : FoodType.values()) {
            Object2IntOpenHashMap innerItemBuilder = new Object2IntOpenHashMap();
            Object2IntOpenHashMap innerEntityBuilder = new Object2IntOpenHashMap();
            innerItemBuilder.putAll(this.itemValues.get((Object)type));
            innerEntityBuilder.putAll(this.entityValues.get((Object)type));
            for (class_6862<class_1792> class_68622 : this.itemTags.get((Object)type)) {
                for (class_6880 itemHolder : class_2378.field_11142.method_40286(class_68622)) {
                    class_1792 item = (class_1792)itemHolder.comp_349();
                    if (item.method_19264() != null) {
                        innerItemBuilder.put(item, item.method_19264().method_19230() * type.multiplier());
                        continue;
                    }
                    innerItemBuilder.put(item, type.fallback());
                }
            }
            for (class_6862<class_1792> class_68623 : this.entityTags.get((Object)type)) {
                for (class_6880 entityHolder : class_2378.field_11145.method_40286(class_68623)) {
                    class_1299 entityType = (class_1299)entityHolder.comp_349();
                    setBuilder.add((Object)entityType);
                    innerEntityBuilder.put(entityType, 0);
                }
            }
            itemBuilder.put((Object)type, (Object)innerItemBuilder);
            entityBuilder.put((Object)type, (Object)innerEntityBuilder);
        }
        this.itemValues = itemBuilder.build();
        this.entityValues = entityBuilder.build();
        this.entities = setBuilder.build();
        this.generateCache();
    }

    public S2CSyncFoodMappingsMessage message() {
        this.loadTags();
        return new S2CSyncFoodMappingsMessage(this.itemValues, this.entityValues, this.entities);
    }

    private static /* synthetic */ void lambda$prepare$1(ImmutableSet.Builder setBuilder, JsonObject object, Map innerEntityBuilder, class_1299 entityType) {
        setBuilder.add((Object)entityType);
        if (object.has("value")) {
            innerEntityBuilder.put(entityType, object.get("value").getAsInt());
        } else {
            innerEntityBuilder.put(entityType, 0);
        }
    }

    private static /* synthetic */ void lambda$prepare$0(JsonObject object, Map innerItemBuilder, FoodType type, class_1792 item) {
        if (object.has("value")) {
            innerItemBuilder.put(item, object.get("value").getAsInt());
        } else if (item.method_19264() != null) {
            innerItemBuilder.put(item, item.method_19264().method_19230() * type.multiplier());
        } else {
            innerItemBuilder.put(item, type.fallback());
        }
    }

    protected record MapPair(Map<FoodType, Map<class_1792, Integer>> items, Map<FoodType, Map<class_1299<?>, Integer>> entities, Set<class_1299<?>> allEntities, Map<FoodType, Set<class_6862<class_1792>>> itemTags, Map<FoodType, Set<class_6862<class_1299<?>>>> entityTags) {
    }
}

