/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.network;

import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategory;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationLogic;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricAnimatable;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_2540;

public class S2CSyncActiveAnimationMessage {
    private final int entityId;
    private final String controller;
    private final String animationName;
    private final AnimationCategory category;
    private final double ticks;
    private final double speed;
    private final boolean loop;

    public S2CSyncActiveAnimationMessage(class_2540 buf) {
        this.entityId = buf.readInt();
        this.controller = buf.method_19772();
        this.animationName = buf.method_19772();
        String name = buf.method_19772();
        this.category = AnimationCategory.CATEGORIES.stream().filter(category1 -> category1.name().equals(name)).findFirst().orElse(AnimationCategory.NONE);
        this.ticks = buf.readDouble();
        this.speed = buf.readDouble();
        this.loop = buf.readBoolean();
    }

    public S2CSyncActiveAnimationMessage(class_1297 entity, String controller, AnimationLogic.ActiveAnimationInfo activeAnimationInfo) {
        this.entityId = entity.method_5628();
        this.controller = controller;
        this.animationName = activeAnimationInfo.animationName();
        this.category = activeAnimationInfo.category();
        this.ticks = activeAnimationInfo.transitionLength();
        this.speed = activeAnimationInfo.speed();
        this.loop = activeAnimationInfo.loop();
    }

    public void write(class_2540 buf) {
        buf.writeInt(this.entityId);
        buf.method_10814(this.controller);
        buf.method_10814(this.animationName);
        buf.method_10814(this.category.name());
        buf.writeDouble(this.ticks);
        buf.writeDouble(this.speed);
        buf.writeBoolean(this.loop);
    }

    public void apply(Supplier<NetworkManager.PacketContext> contextSupplier) {
        if (contextSupplier.get().getEnvironment() == Env.SERVER) {
            return;
        }
        contextSupplier.get().queue(() -> {
            PrehistoricAnimatable prehistoric;
            if (((NetworkManager.PacketContext)contextSupplier.get()).getPlayer() == null) {
                return;
            }
            class_1297 entity = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().field_6002.method_8469(this.entityId);
            if (entity instanceof PrehistoricAnimatable && (prehistoric = (PrehistoricAnimatable)entity).getAllAnimations().containsKey(this.animationName)) {
                double endTick = (double)entity.field_6002.method_8510() + prehistoric.getAnimation((String)this.animationName).animation.animationLength;
                AnimationLogic.ActiveAnimationInfo activeAnimationInfo = new AnimationLogic.Builder(this.animationName, endTick, this.category).forced().transitionLength(this.ticks).speed(this.speed).loop(this.loop).build();
                prehistoric.getAnimationLogic().addNextAnimation(this.controller, activeAnimationInfo);
            }
        });
    }
}

