/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.jetbrains.annotations.NotNull;

public abstract class WithFuelRecipe
implements class_1860<ContainerWithAnyFuel> {
    private final class_2960 location;
    private final class_1856 input;
    private final class_1856 fuel;
    private final class_1799 result;
    private final int duration;

    protected WithFuelRecipe(class_2960 location, class_1856 input, class_1856 fuel, class_1799 result, int duration) {
        this.location = location;
        this.input = input;
        this.fuel = fuel;
        this.result = result;
        this.duration = duration;
    }

    public boolean matches(ContainerWithAnyFuel container, class_1937 level) {
        return this.input.method_8093(container.method_5438(0)) && (container.anyFuel || this.fuel.method_8093(container.method_5438(1)));
    }

    @NotNull
    public class_1799 assemble(ContainerWithAnyFuel container) {
        class_1799 itemStack = this.result.method_7972();
        class_2487 compoundTag = container.method_5438(0).method_7969();
        if (compoundTag != null) {
            itemStack.method_7980(compoundTag.method_10553());
        }
        return itemStack;
    }

    public boolean method_8113(int width, int height) {
        return false;
    }

    @NotNull
    public class_1799 method_8110() {
        return this.result.method_7972();
    }

    @NotNull
    public class_2371<class_1856> method_8117() {
        class_2371 nonNullList = class_2371.method_10211();
        nonNullList.add((Object)this.input);
        return nonNullList;
    }

    public boolean method_8118() {
        return true;
    }

    @NotNull
    public class_2960 method_8114() {
        return this.location;
    }

    public boolean isFuel(class_1799 itemStack) {
        return this.fuel.method_8093(itemStack);
    }

    public class_1856 getInput() {
        return this.input;
    }

    public class_1856 getFuel() {
        return this.fuel;
    }

    public int getDuration() {
        return this.duration;
    }

    public static class ContainerWithAnyFuel
    extends class_1277 {
        public final boolean anyFuel;

        public ContainerWithAnyFuel(boolean anyFuel, class_1799 ... items) {
            super(items);
            this.anyFuel = anyFuel;
        }

        public ContainerWithAnyFuel(class_1799 input, class_1799 fuel) {
            super(new class_1799[]{input, fuel});
            this.anyFuel = false;
        }
    }

    public static class WithFuelRecipeSerializer<T extends WithFuelRecipe>
    implements class_1865<T> {
        protected final Constructor<T> constructor;

        protected WithFuelRecipeSerializer(Constructor<T> constructor) {
            this.constructor = constructor;
        }

        @NotNull
        public T fromJson(class_2960 recipeId, JsonObject serializedRecipe) {
            JsonObject jsonElement = class_3518.method_15296((JsonObject)serializedRecipe, (String)"input");
            class_1856 input = class_1856.method_8102((JsonElement)jsonElement);
            jsonElement = class_3518.method_15296((JsonObject)serializedRecipe, (String)"fuel");
            class_1856 fuel = class_1856.method_8102((JsonElement)jsonElement);
            String result = class_3518.method_15265((JsonObject)serializedRecipe, (String)"result");
            class_1799 output = new class_1799((class_1935)class_2378.field_11142.method_17966(new class_2960(result)).orElseThrow(() -> new IllegalStateException("Item: " + result + " does not exist")));
            int duration = class_3518.method_15282((JsonObject)serializedRecipe, (String)"duration", (int)300);
            return (T)((WithFuelRecipe)this.constructor.construct(recipeId, input, fuel, output, duration));
        }

        @NotNull
        public T fromNetwork(class_2960 recipeId, class_2540 buffer) {
            class_1856 input = class_1856.method_8086((class_2540)buffer);
            class_1856 fuel = class_1856.method_8086((class_2540)buffer);
            class_1799 output = buffer.method_10819();
            int duration = buffer.readInt();
            return (T)((WithFuelRecipe)this.constructor.construct(recipeId, input, fuel, output, duration));
        }

        public void toNetwork(class_2540 buffer, WithFuelRecipe recipe) {
            recipe.input.method_8088(buffer);
            recipe.fuel.method_8088(buffer);
            buffer.method_10793(recipe.result);
            buffer.writeInt(recipe.duration);
        }

        @FunctionalInterface
        public static interface Constructor<R> {
            public R construct(class_2960 var1, class_1856 var2, class_1856 var3, class_1799 var4, int var5);
        }
    }
}

