/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.block.entity;

import com.github.teamfossilsarcheology.fossil.block.custom_blocks.SarcophagusBlock;
import com.github.teamfossilsarcheology.fossil.block.entity.ModBlockEntities;
import com.github.teamfossilsarcheology.fossil.entity.ModEntities;
import com.github.teamfossilsarcheology.fossil.entity.monster.AnuBoss;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SarcophagusBlockEntity
extends BlockEntity {
    public static final int STATE_LOCKED = 0;
    public static final int STATE_UNLOCKED = 1;
    public static final int STATE_OPENING = 2;
    public static final int STATE_CLOSING = 3;
    public static final int STATE_EVENT = 1;
    private int state;
    private int doorTimer;

    public SarcophagusBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.SARCOPHAGUS.get(), blockPos, blockState);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("State", this.state);
        tag.m_128405_("Timer", this.doorTimer);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.state = tag.m_128451_("State");
        this.doorTimer = tag.m_128451_("Timer");
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public boolean m_7531_(int id, int type) {
        if (id == 1) {
            this.state = type;
            if (type == 2) {
                this.doorTimer = 1;
            }
            return true;
        }
        return super.m_7531_(id, type);
    }

    private static void tick(Level level, BlockPos pos, BlockState state, SarcophagusBlockEntity blockEntity) {
        if ((Integer)state.m_61143_((Property)SarcophagusBlock.LAYER) != 0) {
            return;
        }
        if (blockEntity.state != 3) {
            if (blockEntity.doorTimer > 0) {
                ++blockEntity.doorTimer;
            }
            if (blockEntity.doorTimer >= 91) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)SarcophagusBlock.LIT, (Comparable)Boolean.valueOf(false)));
                level.m_46597_(pos.m_7494_(), (BlockState)level.m_8055_(pos.m_7494_()).m_61124_((Property)SarcophagusBlock.LIT, (Comparable)Boolean.valueOf(false)));
                level.m_46597_(pos.m_6630_(2), (BlockState)level.m_8055_(pos.m_6630_(2)).m_61124_((Property)SarcophagusBlock.LIT, (Comparable)Boolean.valueOf(false)));
                blockEntity.setState(3);
                if (!level.f_46443_) {
                    AnuBoss anuBoss = (AnuBoss)((EntityType)ModEntities.ANU_BOSS.get()).m_20615_(level);
                    BlockPos anuPos = pos.m_142300_((Direction)state.m_61143_((Property)SarcophagusBlock.FACING));
                    anuBoss.m_20035_(anuPos, ((Direction)state.m_61143_((Property)SarcophagusBlock.FACING)).m_122435_(), 0.0f);
                    anuBoss.f_20885_ = ((Direction)state.m_61143_((Property)SarcophagusBlock.FACING)).m_122435_();
                    anuBoss.m_6518_((ServerLevelAccessor)level, level.m_6436_(pos), MobSpawnType.NATURAL, null, null);
                    Vec3 spawn = anuBoss.m_20182_();
                    AABB arenaBounds = new AABB(spawn.f_82479_ - 25.0, spawn.f_82480_ - 10.0, spawn.f_82481_ - 25.0, spawn.f_82479_ + 25.0, spawn.f_82480_ + 10.0, spawn.f_82481_ + 25.0);
                    List players = level.m_45955_(TargetingConditions.f_26872_, (LivingEntity)anuBoss, arenaBounds);
                    players.forEach(player -> player.m_5661_(AnuBoss.getRandomGreeting(level.f_46441_), false));
                    level.m_7967_((Entity)anuBoss);
                }
            }
        } else {
            if (blockEntity.doorTimer > 0) {
                --blockEntity.doorTimer;
            }
            if (blockEntity.doorTimer == 0) {
                blockEntity.setState(0);
            }
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, SarcophagusBlockEntity blockEntity) {
        if ((Integer)state.m_61143_((Property)SarcophagusBlock.LAYER) == 0) {
            SarcophagusBlockEntity.tick(level, pos, state, blockEntity);
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, SarcophagusBlockEntity blockEntity) {
        if ((Integer)state.m_61143_((Property)SarcophagusBlock.LAYER) == 0) {
            SarcophagusBlockEntity.tick(level, pos, state, blockEntity);
        }
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getDoorTimer() {
        return this.doorTimer;
    }

    public void setDoorTimer(int doorTimer) {
        this.doorTimer = doorTimer;
    }
}

