/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.block.entity;

import com.github.teamfossilsarcheology.fossil.block.custom_blocks.CustomEntityBlock;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.WorktableBlock;
import com.github.teamfossilsarcheology.fossil.block.entity.MachineContainerBlockEntity;
import com.github.teamfossilsarcheology.fossil.block.entity.ModBlockEntities;
import com.github.teamfossilsarcheology.fossil.inventory.WorktableMenu;
import com.github.teamfossilsarcheology.fossil.recipe.ModRecipes;
import com.github.teamfossilsarcheology.fossil.recipe.WithFuelRecipe;
import com.github.teamfossilsarcheology.fossil.recipe.WorktableRecipe;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorktableBlockEntity
extends MachineContainerBlockEntity {
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_SIDES = new int[]{0, 1};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2};
    private final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return WorktableBlockEntity.this.litTime;
                }
                case 1: {
                    return WorktableBlockEntity.this.litDuration;
                }
                case 2: {
                    return WorktableBlockEntity.this.cookingProgress;
                }
                case 3: {
                    return WorktableBlockEntity.this.cookingTotalTime;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    WorktableBlockEntity.this.litTime = value;
                    break;
                }
                case 1: {
                    WorktableBlockEntity.this.litDuration = value;
                    break;
                }
                case 2: {
                    WorktableBlockEntity.this.cookingProgress = value;
                    break;
                }
                case 3: {
                    WorktableBlockEntity.this.cookingTotalTime = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    private ItemStack fuel = ItemStack.f_41583_;

    public WorktableBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.WORKTABLE.get(), blockPos, blockState);
    }

    public static int getItemFuelTime(ItemStack stack) {
        return ModRecipes.getWorktableFuelValue((ItemLike)stack.m_41720_());
    }

    @Override
    public ContainerData getDataAccess() {
        return this.dataAccess;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, WorktableBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        boolean wasProcessing = this.cookingProgress > 0;
        boolean dirty = false;
        if (this.litTime > 0) {
            --this.litTime;
        }
        if (this.canProcess() && (this.litTime == 0 || this.litTime > 0 && !this.canProcess(this.fuel))) {
            ItemStack fuelStack = (ItemStack)this.items.get(1);
            this.litDuration = this.litTime = WorktableBlockEntity.getItemFuelTime(fuelStack);
            this.cookingTotalTime = this.timeToSmelt((ItemStack)this.items.get(0), fuelStack);
            this.fuel = fuelStack.m_41777_();
            if (this.litTime > 0) {
                dirty = true;
                fuelStack.m_41774_(1);
                if (fuelStack.m_41619_() && fuelStack.m_41720_().m_41470_()) {
                    this.items.set(1, (Object)new ItemStack((ItemLike)fuelStack.m_41720_().m_41469_()));
                }
            }
        }
        if (this.litTime > 0 && this.canProcess(this.fuel)) {
            ++this.cookingProgress;
            if (this.cookingProgress >= this.cookingTotalTime) {
                this.cookingProgress = 0;
                this.createItem();
                dirty = true;
            }
        }
        if (this.litTime == 0 && this.cookingProgress > 0 || this.litTime > 0 && this.cookingProgress > 0 && !this.canProcess(this.fuel)) {
            this.cookingProgress = Mth.m_14045_((int)(this.cookingProgress - 2), (int)0, (int)this.cookingTotalTime);
        }
        if (wasProcessing != this.cookingProgress > 0) {
            dirty = true;
            state = (BlockState)state.m_61124_((Property)WorktableBlock.ACTIVE, (Comparable)Boolean.valueOf(this.cookingProgress > 0));
            level.m_7731_(pos, state, 3);
        }
        if (dirty) {
            WorktableBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private ItemStack checkSmelt(ItemStack input, ItemStack fuel) {
        WorktableRecipe recipeWorktable = ModRecipes.getWorktableRecipeForItem(new WithFuelRecipe.ContainerWithAnyFuel(input, fuel), this.f_58857_);
        if (recipeWorktable != null) {
            return recipeWorktable.m_8043_();
        }
        return ItemStack.f_41583_;
    }

    protected boolean canProcess(ItemStack fuelStack) {
        if (((ItemStack)this.items.get(0)).m_41619_()) {
            return false;
        }
        ItemStack result = this.checkSmelt((ItemStack)this.items.get(0), fuelStack);
        return !result.m_41619_() && (((ItemStack)this.items.get(2)).m_41619_() || ((ItemStack)this.items.get(2)).m_41656_(result) && (((ItemStack)this.items.get(2)).m_41613_() < 64 && ((ItemStack)this.items.get(2)).m_41613_() < ((ItemStack)this.items.get(2)).m_41741_() || ((ItemStack)this.items.get(2)).m_41613_() < result.m_41741_()));
    }

    @Override
    protected boolean canProcess() {
        return this.canProcess((ItemStack)this.items.get(1));
    }

    @Override
    protected void createItem() {
        if (this.canProcess(this.fuel)) {
            ItemStack result = this.checkSmelt((ItemStack)this.items.get(0), this.fuel);
            ItemStack input = (ItemStack)this.items.get(0);
            if (((ItemStack)this.items.get(2)).m_41619_()) {
                this.items.set(2, (Object)result.m_41777_());
                EnchantmentHelper.m_44865_((Map)EnchantmentHelper.m_44831_((ItemStack)input), (ItemStack)((ItemStack)this.items.get(2)));
            } else if (((ItemStack)this.items.get(2)).m_41720_() == result.m_41720_()) {
                ((ItemStack)this.items.get(2)).m_41769_(result.m_41613_());
            }
            if (input.m_41720_().m_41470_()) {
                this.items.set(0, (Object)new ItemStack((ItemLike)input.m_41720_().m_41469_()));
            } else {
                input.m_41774_(1);
            }
            if (input.m_41613_() <= 0) {
                this.items.set(0, (Object)ItemStack.f_41583_);
            }
        }
    }

    public int timeToSmelt(ItemStack input, ItemStack fuel) {
        WorktableRecipe recipe = ModRecipes.getWorktableRecipeForItem(new WithFuelRecipe.ContainerWithAnyFuel(input, fuel), this.f_58857_);
        if (recipe != null) {
            return recipe.getDuration();
        }
        return 300;
    }

    @Override
    @NotNull
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @NotNull
    protected Component m_6820_() {
        return new TranslatableComponent("container.fossil.worktable");
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int containerId, @NotNull Inventory inventory) {
        return new WorktableMenu(containerId, inventory, this, this.dataAccess);
    }

    public void m_6836_(int slot, ItemStack stack) {
        ItemStack itemStack = (ItemStack)this.items.get(slot);
        boolean sameItem = !stack.m_41619_() && stack.m_41656_(itemStack) && ItemStack.m_41658_((ItemStack)stack, (ItemStack)itemStack);
        this.items.set(slot, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        if (slot == 0 && !sameItem) {
            this.cookingProgress = 0;
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)CustomEntityBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
        }
        this.m_6596_();
    }

    public boolean m_7013_(int slot, @NotNull ItemStack stack) {
        if (slot == 2) {
            return false;
        }
        if (slot == 1) {
            return ModRecipes.isWorktableFuel((ItemLike)stack.m_41720_());
        }
        return ModRecipes.getWorktableRecipeForItem(new WithFuelRecipe.ContainerWithAnyFuel(true, stack), this.m_58904_()) != null;
    }

    public int @NotNull [] m_7071_(@NotNull Direction side) {
        return side == Direction.DOWN ? SLOTS_FOR_DOWN : (side == Direction.UP ? SLOTS_FOR_UP : SLOTS_FOR_SIDES);
    }

    public boolean m_7155_(int slot, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        return this.m_7013_(slot, itemStack);
    }

    public boolean m_7157_(int slot, @NotNull ItemStack stack, @NotNull Direction direction) {
        return direction != Direction.UP && slot == 2;
    }
}

