/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.DebugSelectionList;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractAnimationList
extends DebugSelectionList<AnimationEntry> {
    private final Consumer<AnimationObject> consumer;
    protected String currentControllerName;
    protected double speed = 1.0;
    protected double transitionLength = 5.0;
    protected boolean loop;

    public AbstractAnimationList(int x0, int height, int itemHeight, int yOffset, Map<String, ? extends AnimationInfo> animations, Minecraft minecraft, Consumer<AnimationObject> function) {
        super(minecraft, 100, 215, height, yOffset, height + 60, itemHeight);
        this.f_93393_ = x0;
        this.f_93392_ = x0 + this.f_93388_;
        List<String> sortedAnimations = animations.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getKey).toList();
        sortedAnimations.forEach(animation -> this.m_7085_((AbstractSelectionList.Entry)new AnimationEntry((String)animation)));
        this.m_93488_(false);
        this.m_93496_(false);
        this.consumer = function;
    }

    @Nullable
    protected AnimationEntry getEntryAtPosition(double mouseX, double mouseY) {
        int x1 = this.getEntryLeftPos() + this.m_5759_();
        int m = Mth.m_14107_((double)(mouseY - (double)this.f_93390_)) - this.f_93395_ + (int)this.m_93517_() - 4;
        int n = m / this.f_93387_;
        if (mouseX < (double)this.m_5756_() && mouseX >= (double)this.f_93393_ && mouseX <= (double)x1 && n >= 0 && m >= 0 && n < this.m_5773_()) {
            return (AnimationEntry)((Object)this.m_6702_().get(n));
        }
        return null;
    }

    protected int getEntryLeftPos() {
        return this.f_93393_;
    }

    protected int m_5756_() {
        return this.f_93393_ + this.rowWidth + 6;
    }

    protected class AnimationEntry
    extends ContainerObjectSelectionList.Entry<AnimationEntry> {
        private final Button changeButton;

        AnimationEntry(String animation) {
            String[] split = animation.split("\\.");
            TextComponent display = new TextComponent(split.length > 0 ? StringUtils.capitalize((String)split[split.length - 1]) : "");
            this.changeButton = new Button(0, 0, 100, 20, (Component)display, button -> AbstractAnimationList.this.consumer.accept(new AnimationObject(animation, AbstractAnimationList.this.currentControllerName, AbstractAnimationList.this.speed, AbstractAnimationList.this.transitionLength, AbstractAnimationList.this.loop)));
        }

        @NotNull
        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)this.changeButton);
        }

        public void m_6311_(PoseStack poseStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            this.changeButton.f_93620_ = AbstractAnimationList.this.getEntryLeftPos();
            this.changeButton.f_93621_ = top;
            this.changeButton.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }

        @NotNull
        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.changeButton);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            return this.changeButton.m_6375_(mouseX, mouseY, button);
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            return this.changeButton.m_6348_(mouseX, mouseY, button);
        }
    }

    public record AnimationObject(String name, String controller, double speed, double transitionLength, boolean loop) {
    }
}

