/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug.instruction;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.StringUtils;

public abstract class Instruction {
    public final Type type;

    private Instruction(Type type) {
        this.type = type;
    }

    public static void encodeBuffer(List<Instruction> instructions, FriendlyByteBuf buf) {
        for (Instruction instruction : instructions) {
            buf.m_130079_(instruction.encodeTag());
        }
    }

    public CompoundTag encodeTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Type", this.type.name());
        return tag;
    }

    public static Instruction decodeFromTag(CompoundTag tag) {
        try {
            Type type = Type.valueOf(tag.m_128461_("Type"));
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case Type.MOVE_TO -> MoveTo.decodeTag(tag);
                case Type.FLY_TO -> FlyTo.decodeTag(tag);
                case Type.FLY_LAND -> FlyLand.decodeTag(tag);
                case Type.TELEPORT_TO -> TeleportTo.decodeTag(tag);
                case Type.ATTACH_TO -> AttachTo.decodeTag(tag);
                case Type.LEAP_ATTACK -> LeapAttack.decodeTag(tag);
                case Type.LEAP_LAND -> LeapLand.decodeTag(tag);
                case Type.PLAY_ANIM -> PlayAnim.decodeTag(tag);
                case Type.IDLE -> Idle.decodeTag(tag);
                case Type.SLEEP -> Sleep.decodeTag(tag);
            };
        }
        catch (RuntimeException e) {
            FossilMod.LOGGER.error("Could not read Instruction enum from tag: ", (Throwable)e);
            return new Idle(0);
        }
    }

    public static List<Instruction> decodeBuffer(FriendlyByteBuf buf) {
        ArrayList<Instruction> list = new ArrayList<Instruction>();
        while (buf.isReadable()) {
            try {
                CompoundTag tag = buf.m_130260_();
                if (tag == null) continue;
                list.add(Instruction.decodeFromTag(tag));
            }
            catch (RuntimeException e) {
                FossilMod.LOGGER.error("Could not read Instruction enum from buffer: ", (Throwable)e);
                return List.of();
            }
        }
        return list;
    }

    public static enum Type {
        MOVE_TO,
        FLY_TO,
        FLY_LAND,
        PLAY_ANIM,
        IDLE,
        TELEPORT_TO,
        LEAP_ATTACK,
        LEAP_LAND,
        ATTACH_TO,
        SLEEP;

    }

    public static class MoveTo
    extends Instruction {
        public final BlockPos target;

        public MoveTo(BlockPos target) {
            super(Type.MOVE_TO);
            this.target = target;
        }

        @Override
        public CompoundTag encodeTag() {
            CompoundTag tag = super.encodeTag();
            tag.m_128365_("Target", (Tag)NbtUtils.m_129224_((BlockPos)this.target));
            return tag;
        }

        protected static Instruction decodeTag(CompoundTag tag) {
            return new MoveTo(NbtUtils.m_129239_((CompoundTag)tag.m_128469_("Target")));
        }

        public String toString() {
            return this.type.name() + ": " + this.target.m_123341_() + " " + this.target.m_123342_() + " " + this.target.m_123343_();
        }
    }

    public static class FlyTo
    extends Instruction {
        public final BlockPos target;

        public FlyTo(BlockPos target) {
            super(Type.FLY_TO);
            this.target = target;
        }

        @Override
        public CompoundTag encodeTag() {
            CompoundTag tag = super.encodeTag();
            tag.m_128365_("Target", (Tag)NbtUtils.m_129224_((BlockPos)this.target));
            return tag;
        }

        protected static Instruction decodeTag(CompoundTag tag) {
            return new FlyTo(NbtUtils.m_129239_((CompoundTag)tag.m_128469_("Target")));
        }

        public String toString() {
            return this.type.name() + ": " + this.target.m_123341_() + " " + this.target.m_123342_() + " " + this.target.m_123343_();
        }
    }

    public static class FlyLand
    extends Instruction {
        public final BlockPos target;

        public FlyLand(BlockPos target) {
            super(Type.FLY_LAND);
            this.target = target;
        }

        @Override
        public CompoundTag encodeTag() {
            CompoundTag tag = super.encodeTag();
            tag.m_128365_("Target", (Tag)NbtUtils.m_129224_((BlockPos)this.target));
            return tag;
        }

        protected static Instruction decodeTag(CompoundTag tag) {
            return new FlyLand(NbtUtils.m_129239_((CompoundTag)tag.m_128469_("Target")));
        }

        public String toString() {
            return this.type.name() + ": " + this.target.m_123341_() + " " + this.target.m_123342_() + " " + this.target.m_123343_();
        }
    }

    public static class TeleportTo
    extends Instruction {
        public final BlockPos target;
        public final int rotation;

        public TeleportTo(BlockPos target, int rotation) {
            super(Type.TELEPORT_TO);
            this.target = target;
            this.rotation = rotation;
        }

        @Override
        public CompoundTag encodeTag() {
            CompoundTag tag = super.encodeTag();
            tag.m_128365_("Target", (Tag)NbtUtils.m_129224_((BlockPos)this.target));
            tag.m_128405_("Rotation", this.rotation);
            return tag;
        }

        protected static Instruction decodeTag(CompoundTag tag) {
            return new TeleportTo(NbtUtils.m_129239_((CompoundTag)tag.m_128469_("Target")), tag.m_128451_("Rotation"));
        }

        public String toString() {
            return this.type.name() + ": " + this.target.m_123341_() + " " + this.target.m_123342_() + " " + this.target.m_123343_();
        }
    }

    public static class AttachTo
    extends Instruction {
        public final BlockPos target;
        public final Direction direction;
        public final Vec3 location;

        public AttachTo(BlockPos target, Direction direction, Vec3 location) {
            super(Type.ATTACH_TO);
            this.target = target;
            this.direction = direction;
            this.location = location;
        }

        @Override
        public CompoundTag encodeTag() {
            CompoundTag tag = super.encodeTag();
            tag.m_128365_("Target", (Tag)NbtUtils.m_129224_((BlockPos)this.target));
            tag.m_128405_("Direction", this.direction.ordinal());
            tag.m_128347_("LocationX", this.location.f_82479_);
            tag.m_128347_("LocationY", this.location.f_82480_);
            tag.m_128347_("LocationZ", this.location.f_82481_);
            return tag;
        }

        protected static Instruction decodeTag(CompoundTag tag) {
            return new AttachTo(NbtUtils.m_129239_((CompoundTag)tag.m_128469_("Target")), Direction.values()[tag.m_128451_("Direction")], new Vec3(tag.m_128459_("LocationX"), tag.m_128459_("LocationY"), tag.m_128459_("LocationZ")));
        }

        public String toString() {
            return this.type.name() + ": " + this.target.m_123341_() + " " + this.target.m_123342_() + " " + this.target.m_123343_() + " " + this.direction.name();
        }
    }

    public static class LeapAttack
    extends Instruction {
        public final int targetId;

        public LeapAttack(int targetId) {
            super(Type.LEAP_ATTACK);
            this.targetId = targetId;
        }

        @Override
        public CompoundTag encodeTag() {
            CompoundTag tag = super.encodeTag();
            tag.m_128405_("TargetId", this.targetId);
            return tag;
        }

        protected static Instruction decodeTag(CompoundTag tag) {
            return new LeapAttack(tag.m_128451_("TargetId"));
        }

        public String toString() {
            return this.type.name() + ": " + this.targetId;
        }
    }

    public static class LeapLand
    extends Instruction {
        public final Vec3 location;
        public final Vec3 locationAbove;

        public LeapLand(Vec3 location, Vec3 locationAbove) {
            super(Type.LEAP_LAND);
            this.location = location;
            this.locationAbove = locationAbove;
        }

        @Override
        public CompoundTag encodeTag() {
            CompoundTag tag = super.encodeTag();
            tag.m_128347_("LocationX", this.location.f_82479_);
            tag.m_128347_("LocationY", this.location.f_82480_);
            tag.m_128347_("LocationZ", this.location.f_82481_);
            tag.m_128347_("LocationAboveX", this.locationAbove.f_82479_);
            tag.m_128347_("LocationAboveY", this.locationAbove.f_82480_);
            tag.m_128347_("LocationAboveZ", this.locationAbove.f_82481_);
            return tag;
        }

        protected static Instruction decodeTag(CompoundTag tag) {
            return new LeapLand(new Vec3(tag.m_128459_("LocationX"), tag.m_128459_("LocationY"), tag.m_128459_("LocationZ")), new Vec3(tag.m_128459_("LocationAboveX"), tag.m_128459_("LocationAboveY"), tag.m_128459_("LocationAboveZ")));
        }

        public String toString() {
            return this.type.name() + ": " + this.location;
        }
    }

    public static class PlayAnim
    extends Instruction {
        public final String name;
        public final String controller;
        public final boolean timeBased;
        public final int count;
        private final String displayName;

        public PlayAnim(String name, String controller, boolean timeBased, int count) {
            super(Type.PLAY_ANIM);
            this.name = name;
            this.controller = controller;
            this.timeBased = timeBased;
            this.count = count;
            String[] split = name.split("\\.");
            this.displayName = split.length > 0 ? StringUtils.capitalize((String)split[split.length - 1]) : "";
        }

        @Override
        public CompoundTag encodeTag() {
            CompoundTag tag = super.encodeTag();
            tag.m_128359_("Name", this.name);
            tag.m_128359_("Controller", this.controller);
            tag.m_128379_("TimeBased", this.timeBased);
            tag.m_128405_("Count", this.count);
            return tag;
        }

        protected static Instruction decodeTag(CompoundTag tag) {
            return new PlayAnim(tag.m_128461_("Name"), tag.m_128461_("Controller"), tag.m_128471_("TimeBased"), tag.m_128451_("Count"));
        }

        public String toString() {
            return this.type.name() + ": " + this.displayName + " " + this.timeBased + " " + this.count;
        }
    }

    public static class Idle
    extends Instruction {
        public final int duration;

        public Idle(int duration) {
            super(Type.IDLE);
            this.duration = duration;
        }

        @Override
        public CompoundTag encodeTag() {
            CompoundTag tag = super.encodeTag();
            tag.m_128405_("Duration", this.duration);
            return tag;
        }

        protected static Instruction decodeTag(CompoundTag tag) {
            return new Idle(tag.m_128451_("Duration"));
        }

        public String toString() {
            return this.type.name() + ": " + (float)this.duration / 20.0f;
        }
    }

    public static class Sleep
    extends Instruction {
        public final int duration;

        public Sleep(int duration) {
            super(Type.SLEEP);
            this.duration = duration;
        }

        @Override
        public CompoundTag encodeTag() {
            CompoundTag tag = super.encodeTag();
            tag.m_128405_("Duration", this.duration);
            return tag;
        }

        protected static Instruction decodeTag(CompoundTag tag) {
            return new Sleep(tag.m_128451_("Duration"));
        }

        public String toString() {
            return this.type.name() + ": " + (float)this.duration / 20.0f;
        }
    }
}

