/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.model;

import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.DinosaurEgg;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class DinosaurEggModel
extends EntityModel<DinosaurEgg> {
    private final ModelPart model = DinosaurEggModel.createBodyLayer().m_171564_();
    private final float defaultYRot;
    private final float defaultZRot;
    private final float defaultY;

    public DinosaurEggModel() {
        this.defaultYRot = this.model.m_171324_((String)"Egg1").f_104204_;
        this.defaultZRot = this.model.m_171324_((String)"Egg1").f_104205_;
        this.defaultY = this.model.m_171324_((String)"Egg1").f_104201_;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition root = meshDefinition.m_171576_();
        PartDefinition egg1 = root.m_171599_("Egg1", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171481_(-3.0f, -2.8f, -3.0f, 6.0f, 6.0f, 6.0f), PartPose.m_171419_((float)0.0f, (float)19.6f, (float)0.0f));
        egg1.m_171599_("Egg2", CubeListBuilder.m_171558_().m_171514_(28, 16).m_171481_(-2.0f, -4.8f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)-0.9f, (float)0.0f));
        PartDefinition egg3 = egg1.m_171599_("Egg3", CubeListBuilder.m_171558_().m_171514_(22, 2).m_171481_(-2.5f, -0.6f, -2.5f, 5.0f, 5.0f, 5.0f), PartPose.f_171404_);
        egg3.m_171599_("Egg4", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.5f, -4.6f, -2.5f, 5.0f, 5.0f, 5.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public void setupAnim(DinosaurEgg entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ModelPart egg1 = this.model.m_171324_("Egg1");
        egg1.f_104204_ = this.defaultYRot;
        egg1.f_104205_ = this.defaultZRot;
        egg1.f_104201_ = this.defaultY;
        if (!entity.isTooCold() && (double)entity.getHatchingTime() > (double)entity.getTotalHatchingTime() * 0.9) {
            egg1.f_104204_ += this.calcRotation(0.3f, 0.5f, false, 0.25f, 0.0f, ageInTicks, 1.0f);
            egg1.f_104205_ += this.calcRotation(0.3f, 0.5f, true, 0.25f, 0.0f, ageInTicks, 1.0f);
            egg1.f_104201_ += this.calcBob(0.3f, 0.9f, true, ageInTicks, 1.0f);
        }
    }

    private float calcRotation(float speed, float degree, boolean invert, float offset, float weight, float ageInTicks, float amount) {
        float rotation = Mth.m_14089_((float)(ageInTicks * speed + offset)) * degree * amount + weight * amount;
        return invert ? -rotation : rotation;
    }

    private float calcBob(float speed, float degree, boolean bounce, float ageInTicks, float amount) {
        return bounce ? -Mth.m_14154_((float)(Mth.m_14031_((float)(ageInTicks * speed)) * amount * degree)) : Mth.m_14031_((float)(ageInTicks * speed)) * degree * amount - amount * degree;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float r, float g, float b, float alpha) {
        this.model.m_104306_(poseStack, buffer, packedLight, packedOverlay, r, g, b, alpha);
    }
}

