/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.renderer.entity;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.InstructionTab;
import com.github.teamfossilsarcheology.fossil.client.model.PrehistoricGeoModel;
import com.github.teamfossilsarcheology.fossil.client.renderer.entity.FixedGeoEntityRenderer;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.Arthropleura;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.util.Version;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import software.bernie.geckolib3.core.util.Color;

public class PrehistoricGeoRenderer<T extends Prehistoric>
extends FixedGeoEntityRenderer<T> {
    private final Function<ResourceLocation, RenderType> renderType;

    public PrehistoricGeoRenderer(EntityRendererProvider.Context renderManager, String model, String animation, Function<ResourceLocation, RenderType> renderType) {
        super(renderManager, new PrehistoricGeoModel(model, animation));
        this.renderType = renderType;
    }

    public void render(T entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        this.f_114477_ = entity.m_20205_() * 0.45f;
        poseStack.m_85836_();
        if (((Prehistoric)entity).getClimbingDirection() != Direction.UP || ((Prehistoric)entity).prevClimbDirection != Direction.UP && ((Prehistoric)entity).climbTick > 0) {
            float progress = Mth.m_14179_((float)partialTick, (float)((Prehistoric)entity).prevClimbTick, (float)((Prehistoric)entity).climbTick) / 5.0f;
            Direction dir = ((Prehistoric)entity).getClimbingDirection() != Direction.UP ? ((Prehistoric)entity).getClimbingDirection() : ((Prehistoric)entity).prevClimbDirection;
            float offset = entity.m_20205_() / 2.0f * progress;
            poseStack.m_85837_((double)((float)dir.m_122429_() * offset), 0.5 * (double)progress, (double)((float)dir.m_122431_() * offset));
            Direction dirRot = dir.m_122427_();
            poseStack.m_85845_(new Vector3f((float)dirRot.m_122429_(), 0.0f, (float)dirRot.m_122431_()).m_122240_(90.0f * progress));
        }
        super.render(entity, entityYaw, partialTick, poseStack, buffer, packedLight);
        poseStack.m_85849_();
    }

    public Color getRenderColor(T animatable, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, VertexConsumer buffer, int packedLight) {
        Arthropleura arthropleura;
        if (Version.debugEnabled()) {
            if (InstructionTab.entityListHighlight != null && InstructionTab.entityListHighlight.m_142049_() == animatable.m_142049_()) {
                return Color.RED;
            }
            if (InstructionTab.highlightInstructionEntity != null && InstructionTab.highlightInstructionEntity.m_142049_() == animatable.m_142049_()) {
                return Color.RED;
            }
        }
        if (animatable instanceof Arthropleura && (arthropleura = (Arthropleura)animatable).isBee()) {
            return Color.YELLOW;
        }
        return super.getRenderColor(animatable, partialTick, poseStack, bufferSource, buffer, packedLight);
    }

    protected float getSwingMotionAnimThreshold() {
        return 0.08f;
    }

    public RenderType getRenderType(T animatable, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, VertexConsumer buffer, int packedLight, ResourceLocation texture) {
        return this.renderType.apply(texture);
    }

    protected void applyRotations(T animatable, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick) {
        String name;
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - rotationYaw));
        if (((Prehistoric)animatable).f_20919_ > 0) {
            float deathRotation = ((float)((Prehistoric)animatable).f_20919_ + partialTick - 1.0f) / 20.0f * 1.6f;
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(Math.min(Mth.m_14116_((float)deathRotation), 1.0f) * this.getDeathMaxRotation((LivingEntity)animatable)));
        } else if (animatable.m_8077_() && (name = ChatFormatting.m_126649_((String)animatable.m_7755_().getString())) != null && (name.equals("Dinnerbone") || name.equalsIgnoreCase("Grumm"))) {
            poseStack.m_85837_(0.0, (double)(animatable.m_20206_() + 0.1f), 0.0);
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        }
    }

    public float getWidthScale(T animatable) {
        return ((Prehistoric)animatable).m_6134_();
    }

    public float getHeightScale(T entity) {
        return ((Prehistoric)this.animatable).m_6134_();
    }
}

