/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.compat.geckolib;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import software.bernie.geckolib3.core.ConstantValue;
import software.bernie.geckolib3.core.builder.Animation;
import software.bernie.geckolib3.core.keyframe.AnimationPoint;
import software.bernie.geckolib3.core.keyframe.BoneAnimationQueue;
import software.bernie.geckolib3.core.keyframe.KeyFrame;
import software.bernie.geckolib3.core.keyframe.KeyFrameLocation;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.core.snapshot.BoneSnapshot;
import software.bernie.shadowed.eliotlash.mclib.math.IValue;

public class AnimationControllerOverride {
    private static final KeyFrame<IValue> ZERO_KEYFRAME = new KeyFrame(Double.valueOf(0.0), (Object)new ConstantValue(0.0), (Object)new ConstantValue(0.0));

    public static void fixTransitions(List<IBone> modelRendererList, Animation currentAnimation, Map<String, BoneSnapshot> boneSnapshots, double adjustedTick, boolean firstTick, Map<String, Pair<IBone, BoneSnapshot>> boneSnapshotCollection, double transitionLengthTicks, Map<String, BoneAnimationQueue> boneAnimationQueues) {
        HashSet<String> previousBones = new HashSet<String>(boneSnapshots.keySet());
        Set newBones = currentAnimation.boneAnimations.stream().map(boneAnimation -> boneAnimation.boneName).collect(Collectors.toSet());
        previousBones.removeAll(newBones);
        if (firstTick) {
            for (String previousBone : previousBones) {
                boneSnapshots.put(previousBone, new BoneSnapshot((BoneSnapshot)boneSnapshotCollection.get(previousBone).getRight()));
            }
        }
        for (String boneName : previousBones) {
            BoneSnapshot boneSnapshot = boneSnapshots.get(boneName);
            Optional<Object> first = Optional.empty();
            for (IBone bone : modelRendererList) {
                if (!bone.getName().equals(boneName)) continue;
                first = Optional.of(bone);
                break;
            }
            if (first.isEmpty()) continue;
            BoneSnapshot initialSnapshot = ((IBone)first.get()).getInitialSnapshot();
            assert (boneSnapshot != null) : "Bone snapshot was null";
            BoneSnapshot boneAnimation2 = boneSnapshots.get(boneName);
            BoneAnimationQueue boneAnimationQueue = boneAnimationQueues.get(boneName);
            KeyFrameLocation location = new KeyFrameLocation(ZERO_KEYFRAME, 0.0);
            AnimationPoint point = new AnimationPoint(location.currentFrame, location.currentTick, 0.0, 0.0, 0.0);
            if (boneAnimation2.positionOffsetX != 0.0f || boneAnimation2.positionOffsetY != 0.0f || boneAnimation2.positionOffsetZ != 0.0f) {
                boneAnimationQueue.positionXQueue().add((Object)new AnimationPoint(null, adjustedTick, transitionLengthTicks, (double)(boneSnapshot.positionOffsetX - initialSnapshot.positionOffsetX), point.animationStartValue));
                boneAnimationQueue.positionYQueue().add((Object)new AnimationPoint(null, adjustedTick, transitionLengthTicks, (double)(boneSnapshot.positionOffsetY - initialSnapshot.positionOffsetY), point.animationStartValue));
                boneAnimationQueue.positionZQueue().add((Object)new AnimationPoint(null, adjustedTick, transitionLengthTicks, (double)(boneSnapshot.positionOffsetZ - initialSnapshot.positionOffsetZ), point.animationStartValue));
            }
            if (boneAnimation2.rotationValueX != 0.0f || boneAnimation2.rotationValueY != 0.0f || boneAnimation2.rotationValueZ != 0.0f) {
                boneAnimationQueue.rotationXQueue().add((Object)new AnimationPoint(null, adjustedTick, transitionLengthTicks, (double)(boneSnapshot.rotationValueX - initialSnapshot.rotationValueX), point.animationStartValue));
                boneAnimationQueue.rotationYQueue().add((Object)new AnimationPoint(null, adjustedTick, transitionLengthTicks, (double)(boneSnapshot.rotationValueY - initialSnapshot.rotationValueY), point.animationStartValue));
                boneAnimationQueue.rotationZQueue().add((Object)new AnimationPoint(null, adjustedTick, transitionLengthTicks, (double)(boneSnapshot.rotationValueY - initialSnapshot.rotationValueY), point.animationStartValue));
            }
            if (boneAnimation2.scaleValueX == 1.0f && boneAnimation2.scaleValueY == 1.0f && boneAnimation2.scaleValueZ == 1.0f) continue;
            boneAnimationQueue.scaleXQueue().add((Object)new AnimationPoint(null, adjustedTick, transitionLengthTicks, (double)(boneSnapshot.scaleValueX - initialSnapshot.scaleValueX), point.animationStartValue));
            boneAnimationQueue.scaleXQueue().add((Object)new AnimationPoint(null, adjustedTick, transitionLengthTicks, (double)(boneSnapshot.scaleValueY - initialSnapshot.scaleValueY), point.animationStartValue));
            boneAnimationQueue.scaleXQueue().add((Object)new AnimationPoint(null, adjustedTick, transitionLengthTicks, (double)(boneSnapshot.scaleValueZ - initialSnapshot.scaleValueZ), point.animationStartValue));
        }
    }
}

