/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity;

import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.util.Version;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public abstract class ToyBase
extends Entity {
    public final int moodBonus;
    protected final SoundEvent attackNoise;

    protected ToyBase(EntityType<? extends ToyBase> type, Level level, int moodBonus, SoundEvent attackNoise) {
        super(type, level);
        this.moodBonus = moodBonus;
        this.attackNoise = attackNoise;
    }

    protected boolean skipAI() {
        return true;
    }

    public void m_6075_() {
        if (!this.skipAI()) {
            super.m_6075_();
        }
    }

    public void m_8119_() {
        if (!this.skipAI()) {
            super.m_8119_();
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7639_() != null) {
            Entity entity = source.m_7640_();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (player.m_150110_().f_35937_) {
                    this.m_146870_();
                    return true;
                }
                if (!player.m_150110_().f_35938_) {
                    return false;
                }
                Block.m_49840_((Level)this.f_19853_, (BlockPos)this.m_142538_(), (ItemStack)this.m_142340_());
                this.m_146870_();
                this.m_5496_(this.attackNoise, 1.0f, this.getVoicePitch());
                return true;
            }
            entity = source.m_7639_();
            if (entity instanceof Prehistoric) {
                Prehistoric prehistoric = (Prehistoric)entity;
                prehistoric.moodSystem.useToy(this.moodBonus);
                this.m_5496_(this.attackNoise, 1.0f, this.getVoicePitch());
                return false;
            }
            if (source == DamageSource.f_19311_ || source.m_19384_()) {
                Block.m_49840_((Level)this.f_19853_, (BlockPos)this.m_142538_(), (ItemStack)this.m_142340_());
                this.m_146870_();
            }
        }
        return source != DamageSource.f_19317_;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (Version.debugEnabled() && reason == Entity.RemovalReason.KILLED) {
            return;
        }
        super.m_142687_(reason);
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6087_() {
        return !this.m_146910_();
    }

    public float getVoicePitch() {
        return (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f;
    }

    @NotNull
    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

