/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai;

import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.OrderType;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.NodeEvaluator;

public class DinoFollowOwnerGoal
extends Goal {
    private final Prehistoric dino;
    private final double speedModifier;
    private final double sprintModifier;
    private final float startDistanceSqr;
    private final float sprintDistanceSqr;
    private final float stopDistanceSqr;
    private final float teleportDistanceSqr;
    private final boolean canFly;
    private boolean shouldSprint;
    private LivingEntity owner;
    private float oldWaterCost;
    private int timeToRecalcPath;

    public DinoFollowOwnerGoal(Prehistoric dino, double sprintModifier, float startDistance, float stopDistance, boolean canFly) {
        this(dino, sprintModifier, startDistance, stopDistance, 18.0f, canFly);
    }

    public DinoFollowOwnerGoal(Prehistoric dino, double sprintModifier, float startDistance, float stopDistance, float teleportDistance, boolean canFly) {
        this.dino = dino;
        this.speedModifier = 1.0;
        this.sprintModifier = sprintModifier;
        this.startDistanceSqr = startDistance * startDistance;
        this.sprintDistanceSqr = this.startDistanceSqr + 3.0f;
        this.stopDistanceSqr = stopDistance * stopDistance;
        this.teleportDistanceSqr = teleportDistance * teleportDistance;
        this.canFly = canFly;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity currentOwner = this.dino.m_142480_();
        if (currentOwner == null || currentOwner.m_5833_()) {
            return false;
        }
        if (this.dino.getCurrentOrder() != OrderType.FOLLOW) {
            return false;
        }
        if (this.dino.m_20280_((Entity)currentOwner) < (double)this.startDistanceSqr) {
            return false;
        }
        this.owner = currentOwner;
        return true;
    }

    public boolean m_8045_() {
        if (this.dino.m_21573_().m_26571_() || this.dino.getCurrentOrder() != OrderType.FOLLOW) {
            return false;
        }
        return this.dino.m_20280_((Entity)this.owner) > (double)this.stopDistanceSqr;
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.dino.m_21439_(BlockPathTypes.WATER);
        this.dino.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.shouldSprint = this.dino.m_20280_((Entity)this.owner) >= (double)this.sprintDistanceSqr;
    }

    public void m_8041_() {
        this.owner = null;
        this.dino.m_21573_().m_26573_();
        this.dino.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        this.dino.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.dino.m_8132_());
        --this.timeToRecalcPath;
        if (this.timeToRecalcPath > 0) {
            return;
        }
        this.timeToRecalcPath = this.m_183277_(10);
        if (this.dino.m_20280_((Entity)this.owner) >= (double)this.sprintDistanceSqr) {
            this.shouldSprint = true;
        }
        if (!this.dino.m_21523_() && this.dino.m_20280_((Entity)this.owner) >= (double)this.teleportDistanceSqr) {
            this.teleportToOwner();
            return;
        }
        this.dino.m_21573_().m_5624_((Entity)this.owner, this.shouldSprint ? this.sprintModifier : this.speedModifier);
    }

    private void teleportToOwner() {
        BlockPos ownerBlockPos = this.owner.m_142538_();
        for (int i = 0; i < 10; ++i) {
            int z;
            int y;
            int x = ownerBlockPos.m_123341_() + this.randomIntInclusive(-3, 3);
            if (!this.maybeTeleportTo(x, y = ownerBlockPos.m_123342_() + this.randomIntInclusive(-1, 1), z = ownerBlockPos.m_123343_() + this.randomIntInclusive(-3, 3))) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.m_20185_()) < 2.0 && Math.abs((double)z - this.owner.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(x, y, z))) {
            return false;
        }
        this.dino.m_7678_((double)x + 0.5, y, (double)z + 0.5, this.dino.m_146908_(), this.dino.m_146909_());
        this.dino.m_21573_().m_26573_();
        return true;
    }

    private boolean canTeleportTo(BlockPos teleportPos) {
        Level level = this.dino.m_183503_();
        NodeEvaluator nodeEvaluator = this.dino.m_21573_().m_26575_();
        BlockPathTypes type = nodeEvaluator.m_8086_((BlockGetter)level, teleportPos.m_123341_(), teleportPos.m_123342_(), teleportPos.m_123343_());
        if (type == BlockPathTypes.WATER && this.dino.m_21439_(type) == 0.0f) {
            return level.m_45756_((Entity)this.dino, this.dino.m_142469_().m_82338_(teleportPos.m_141950_((Vec3i)this.dino.m_142538_())));
        }
        if (type != BlockPathTypes.WALKABLE) {
            return false;
        }
        if (!this.canFly && level.m_8055_(teleportPos).m_60734_() instanceof LeavesBlock) {
            return false;
        }
        return level.m_45756_((Entity)this.dino, this.dino.m_142469_().m_82338_(teleportPos.m_141950_((Vec3i)this.dino.m_142538_())));
    }

    private int randomIntInclusive(int min, int max) {
        return this.dino.m_21187_().nextInt(max - min + 1) + min;
    }
}

