/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai;

import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.util.Gender;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import org.jetbrains.annotations.Nullable;

public class DinoMatingGoal
extends Goal {
    private final double speedModifier;
    private final Prehistoric male;
    private Prehistoric female;

    public DinoMatingGoal(Prehistoric dinosaur, double speed) {
        this.male = dinosaur;
        this.speedModifier = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!FossilConfig.isEnabled("breedingDinos")) {
            return false;
        }
        if (this.male.getGender() != Gender.MALE || !this.male.isAdult() || this.male.getMatingCooldown() > 0 || this.male.moodSystem.getMood() <= 50) {
            return false;
        }
        List<? extends Prehistoric> sameTypes = this.male.getNearbySpeciesMembers(64);
        if (sameTypes.size() + 1 >= this.male.data().maxPopulation()) {
            this.male.setMatingCooldown(this.male.m_21187_().nextInt(5000) + 5000);
            return false;
        }
        double shortestDistance = Double.MAX_VALUE;
        for (Prehistoric prehistoric : sameTypes) {
            if (!this.male.m_7848_((Animal)prehistoric) || this.male.m_20280_((Entity)prehistoric) > shortestDistance) continue;
            this.female = prehistoric;
            shortestDistance = this.male.m_20280_((Entity)this.female);
        }
        return this.female != null;
    }

    public boolean m_8045_() {
        return this.female.m_6084_() && this.male.m_7848_((Animal)this.female);
    }

    public void m_8041_() {
        this.female = null;
    }

    public void m_8037_() {
        this.male.m_21563_().m_24960_((Entity)this.female, 10.0f, (float)this.male.m_8132_());
        this.male.m_21573_().m_5624_((Entity)this.female, this.speedModifier);
        if (this.male.m_19950_((Entity)this.female, (double)this.male.m_20205_() * 1.5)) {
            this.female.procreate(this.male);
            this.male.procreate(this.female);
            this.male.setMatingCooldown(this.male.m_21187_().nextInt(6000) + 6000);
            this.female.setMatingCooldown(this.male.m_21187_().nextInt(12000) + 24000);
        }
    }

    @Nullable
    public Prehistoric getPartner() {
        return this.female;
    }
}

