/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai.navigation;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PathingDebug;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.SwimmingAnimal;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.Target;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrehistoricAmphibiousNodeEvaluator
extends WalkNodeEvaluator {
    @NotNull
    public Node m_7171_() {
        BlockPos blockPos;
        SwimmingAnimal swimmingAnimal;
        Mob mob;
        if (this.f_77313_.m_20069_() || (mob = this.f_77313_) instanceof SwimmingAnimal && !(swimmingAnimal = (SwimmingAnimal)mob).isAmphibious()) {
            return super.m_5676_(Mth.m_14107_((double)this.f_77313_.m_142469_().f_82288_), Mth.m_14107_((double)(this.f_77313_.m_142469_().f_82289_ + 0.5)), Mth.m_14107_((double)this.f_77313_.m_142469_().f_82290_));
        }
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int i = this.f_77313_.m_146904_();
        BlockState blockState = this.f_77312_.m_8055_((BlockPos)mutableBlockPos.m_122169_(this.f_77313_.m_20185_(), (double)i, this.f_77313_.m_20189_()));
        if (!this.f_77313_.m_203441_(blockState.m_60819_())) {
            if (this.f_77313_.m_20096_()) {
                i = Mth.m_14107_((double)(this.f_77313_.m_20186_() + 0.5));
            } else {
                blockPos = this.f_77313_.m_142538_();
                while ((this.f_77312_.m_8055_(blockPos).m_60795_() || this.f_77312_.m_8055_(blockPos).m_60647_((BlockGetter)this.f_77312_, blockPos, PathComputationType.LAND)) && blockPos.m_123342_() > this.f_77313_.f_19853_.m_141937_()) {
                    blockPos = blockPos.m_7495_();
                }
                i = blockPos.m_7494_().m_123342_();
            }
        } else {
            while (this.f_77313_.m_203441_(blockState.m_60819_())) {
                blockState = this.f_77312_.m_8055_((BlockPos)mutableBlockPos.m_122169_(this.f_77313_.m_20185_(), (double)(++i), this.f_77313_.m_20189_()));
            }
            --i;
        }
        blockPos = this.f_77313_.m_142538_();
        BlockPathTypes blockPathTypes = this.m_77567_(this.f_77313_, blockPos.m_123341_(), i, blockPos.m_123343_());
        if (this.f_77313_.m_21439_(blockPathTypes) < 0.0f) {
            AABB aABB = this.f_77313_.m_142469_();
            if (this.m_77646_((BlockPos)mutableBlockPos.m_122169_(aABB.f_82288_, (double)i, aABB.f_82290_)) || this.m_77646_((BlockPos)mutableBlockPos.m_122169_(aABB.f_82288_, (double)i, aABB.f_82293_)) || this.m_77646_((BlockPos)mutableBlockPos.m_122169_(aABB.f_82291_, (double)i, aABB.f_82290_)) || this.m_77646_((BlockPos)mutableBlockPos.m_122169_(aABB.f_82291_, (double)i, aABB.f_82293_))) {
                Node node = this.m_77349_((BlockPos)mutableBlockPos);
                BlockPos nodePos = node.m_77288_();
                node.f_77282_ = this.m_77567_(this.f_77313_, nodePos.m_123341_(), nodePos.m_123342_(), nodePos.m_123343_());
                node.f_77281_ = this.f_77313_.m_21439_(node.f_77282_);
                return node;
            }
        }
        Node node2 = this.m_5676_(blockPos.m_123341_(), i, blockPos.m_123343_());
        BlockPos node2Pos = node2.m_77288_();
        node2.f_77282_ = this.m_77567_(this.f_77313_, node2Pos.m_123341_(), node2Pos.m_123342_(), node2Pos.m_123343_());
        node2.f_77281_ = this.f_77313_.m_21439_(node2.f_77282_);
        return node2;
    }

    @NotNull
    public Target m_7568_(double x, double y, double z) {
        return new Target(super.m_5676_(Mth.m_14107_((double)x), Mth.m_14107_((double)(y + 0.5)), Mth.m_14107_((double)z)));
    }

    @Nullable
    protected Node m_5676_(int x, int y, int z) {
        if (this.m_141974_()) {
            return super.m_5676_(x, y, z);
        }
        Node node = null;
        BlockPathTypes blockPathTypes = this.m_77567_(this.f_77313_, x, y, z);
        if (blockPathTypes == BlockPathTypes.WATER || blockPathTypes == BlockPathTypes.WATER_BORDER) {
            float f;
            float f2 = PathingDebug.getPathfindingMalus(blockPathTypes);
            if (f >= 0.0f) {
                node = super.m_5676_(x, y, z);
                node.f_77282_ = blockPathTypes;
                node.f_77281_ = Math.max(node.f_77281_, f2);
                if (this.f_77312_.m_6425_(new BlockPos(x, y, z)).m_76178_()) {
                    node.f_77281_ += 8.0f;
                }
            }
        }
        return node;
    }

    public int m_6065_(Node[] nodes, Node node) {
        int x = node.f_77271_;
        int y = node.f_77272_;
        int z = node.f_77273_;
        BlockPathTypes type = this.m_77567_(this.f_77313_, x, y, z);
        if (type == BlockPathTypes.WATER || type == BlockPathTypes.WATER_BORDER) {
            int i = 0;
            EnumMap map = Maps.newEnumMap(Direction.class);
            for (Direction direction : Direction.values()) {
                Node faceNode = this.m_5676_(x + direction.m_122429_(), y + direction.m_122430_(), z + direction.m_122431_());
                map.put(direction, faceNode);
                if (!this.isNodeValid(faceNode)) continue;
                nodes[i++] = faceNode;
            }
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                Direction direction2 = direction.m_122427_();
                Node diagonalNode = this.m_5676_(x + direction.m_122429_() + direction2.m_122429_(), y, z + direction.m_122431_() + direction2.m_122431_());
                if (!this.isDiagonalNodeValid(diagonalNode, (Node)map.get(direction), (Node)map.get(direction2))) continue;
                nodes[i++] = diagonalNode;
            }
            return i;
        }
        int i = super.m_6065_(nodes, node);
        BlockPathTypes typeAbove = this.m_77567_(this.f_77313_, x, y + 1, z);
        int j = this.f_77313_.m_21439_(type) > 0.0f && typeAbove != BlockPathTypes.STICKY_HONEY ? Mth.m_14143_((float)Math.max(1.0f, this.f_77313_.f_19793_)) : 0;
        double floorLevel = this.m_142213_(new BlockPos(x, y, z));
        Node nodeAbove = this.m_164725_(x, y + 1, z, Math.max(0, j - 1), floorLevel, Direction.UP, type);
        Node nodeBelow = this.m_164725_(x, y - 1, z, j, floorLevel, Direction.DOWN, type);
        if (this.m_77626_(nodeAbove, node)) {
            nodes[i++] = nodeAbove;
        }
        if (this.m_77626_(nodeBelow, node) && type != BlockPathTypes.TRAPDOOR) {
            nodes[i++] = nodeBelow;
        }
        return i;
    }

    protected boolean isNodeValid(@Nullable Node node) {
        return node != null && !node.f_77279_ && this.m_8086_((BlockGetter)this.f_77312_, node.f_77271_, node.f_77272_, node.f_77273_) != BlockPathTypes.BLOCKED;
    }

    protected boolean isDiagonalNodeValid(@Nullable Node diagonal, @Nullable Node node1, @Nullable Node node2) {
        return this.isNodeValid(diagonal) && node1 != null && node1.f_77281_ >= 0.0f && node2 != null && node2.f_77281_ >= 0.0f;
    }

    protected boolean isVerticalDiagonalNodeValid(@Nullable Node diagonal, @Nullable Node node1, @Nullable Node node2) {
        return this.isNodeValid(diagonal) && node1 != null && node1.f_77281_ >= 0.0f && node2 != null && node2.f_77281_ >= 0.0f;
    }

    protected boolean m_141974_() {
        Mob mob = this.f_77313_;
        if (mob instanceof SwimmingAnimal) {
            SwimmingAnimal swimmingAnimal = (SwimmingAnimal)mob;
            return swimmingAnimal.isAmphibious();
        }
        return true;
    }

    @NotNull
    public BlockPathTypes m_8086_(BlockGetter level, int x, int y, int z) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        BlockPathTypes type = PrehistoricAmphibiousNodeEvaluator.m_77643_((BlockGetter)level, (BlockPos)mutableBlockPos.m_122178_(x, y, z));
        if (type == BlockPathTypes.WATER) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPathTypes neighbourType = PrehistoricAmphibiousNodeEvaluator.m_77643_((BlockGetter)level, (BlockPos)mutableBlockPos.m_122178_(x, y, z).m_122173_(direction));
                if (neighbourType != BlockPathTypes.BLOCKED) continue;
                return BlockPathTypes.WATER_BORDER;
            }
            return BlockPathTypes.WATER;
        }
        if (!this.m_141974_()) {
            return BlockPathTypes.BLOCKED;
        }
        return PrehistoricAmphibiousNodeEvaluator.m_77604_((BlockGetter)level, (BlockPos.MutableBlockPos)mutableBlockPos);
    }
}

