/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai.navigation;

import com.github.teamfossilsarcheology.fossil.entity.ai.navigation.PrehistoricPathFinder;
import java.util.Set;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Target;

public class WaterPathFinder
extends PrehistoricPathFinder {
    private static final int FACE = 10;
    private static final int EDGE = 14;
    private static final int CORNER = 17;

    public WaterPathFinder(NodeEvaluator nodeEvaluator, int maxVisitedNodes, Mob mob) {
        super(nodeEvaluator, maxVisitedNodes, mob);
    }

    @Override
    protected float getBestH(Node node, Set<Target> targets, boolean fudge) {
        float f = Float.MAX_VALUE;
        for (Target target : targets) {
            float g = this.dist(node, (Node)target);
            target.m_77503_(g, node);
            f = Math.min(g, f);
        }
        return f;
    }

    public float dist(Node f, Node l) {
        float xDiff = Math.abs(l.f_77271_ - f.f_77271_);
        float yDiff = Math.abs(l.f_77272_ - f.f_77272_);
        float zDiff = Math.abs(l.f_77273_ - f.f_77273_);
        float min = Math.min(Math.min(xDiff, yDiff), zDiff);
        float max = Math.max(Math.max(xDiff, yDiff), zDiff);
        float tripleAxis = min;
        float doubleAxis = xDiff + yDiff + zDiff - max - 2.0f * min;
        float singleAxis = max - doubleAxis - tripleAxis;
        return 10.0f * singleAxis + 14.0f * doubleAxis + 17.0f * tripleAxis;
    }
}

