/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.animation;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategory;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationHolder;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.animation.BakedAnimationInfo;
import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public class AnimationCategoryLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final AnimationHolder EMPTY = new AnimationHolder();
    private ImmutableMap<ResourceLocation, Map<AnimationCategory, AnimationHolder>> animations = ImmutableMap.of();
    public static final AnimationCategoryLoader CLIENT = new AnimationCategoryLoader();
    public static final AnimationCategoryLoader SERVER = new AnimationCategoryLoader();

    protected void apply(Map<ResourceLocation, ? extends BakedAnimationInfo<? extends AnimationInfo>> allAnimations) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<ResourceLocation, ? extends BakedAnimationInfo<? extends AnimationInfo>> fileEntry : allAnimations.entrySet()) {
            Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
            AnimationCategory backup = null;
            for (AnimationCategory category : AnimationCategory.CATEGORIES) {
                for (Map.Entry<String, ? extends AnimationInfo> entry : fileEntry.getValue().animations().entrySet()) {
                    if (!category.canMapAnimation(entry.getKey())) continue;
                    map.computeIfAbsent(category, cat -> new AnimationHolder()).add(entry.getValue());
                    backup = category;
                }
            }
            if (backup == null) {
                LOGGER.error("Mob has no animations that match any of our categories in {}", (Object)fileEntry.getKey());
                throw new RuntimeException("Mob has no animations that match any of our categories in " + fileEntry.getKey());
            }
            for (AnimationCategory category : AnimationCategory.CATEGORIES) {
                if (map.containsKey(category)) continue;
                map.put(category, map.containsKey(category.backup()) ? (AnimationHolder)map.get(category.backup()) : (AnimationHolder)map.get(backup));
            }
            builder.put((Object)fileEntry.getKey(), (Object)map);
        }
        this.animations = builder.build();
        FossilMod.LOGGER.info("Loaded {} animation category entries for {} entities", (Object)this.animations.values().stream().map(Map::size).reduce(Integer::sum).orElse(0), (Object)this.animations.size());
    }

    public Map<AnimationCategory, AnimationHolder> getAnimations(ResourceLocation path) {
        return (Map)this.animations.get((Object)path);
    }

    public AnimationHolder getAnimations(ResourceLocation path, AnimationCategory animationCategory) {
        if (this.animations.containsKey((Object)path)) {
            return (AnimationHolder)((Map)this.animations.get((Object)path)).get(animationCategory);
        }
        return EMPTY;
    }
}

