/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric;

import com.github.teamfossilsarcheology.fossil.entity.ai.FleeBattleGoal;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategory;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.util.Util;
import com.github.teamfossilsarcheology.fossil.sounds.ModSounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Ankylosaurus
extends Prehistoric {
    public static final String ATTACK_FRONT_RIGHT = "animation.ankylosaurus.attack_strong_right";
    public static final String ATTACK_FRONT_LEFT = "animation.ankylosaurus.attack_strong_left";

    public Ankylosaurus(EntityType<Ankylosaurus> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(3, (Goal)new FleeBattleGoal(this, 1.0));
    }

    @Override
    @NotNull
    public EntityDimensions m_6972_(Pose poseIn) {
        if (poseIn == Pose.SLEEPING) {
            return super.m_6972_(poseIn).m_20390_(1.0f, 0.7f);
        }
        return super.m_6972_(poseIn);
    }

    @Override
    public PrehistoricEntityInfo info() {
        return PrehistoricEntityInfo.ANKYLOSAURUS;
    }

    @Override
    public Item getOrderItem() {
        return Items.f_42500_;
    }

    @Override
    public AnimationInfo getAnimation(AnimationCategory category) {
        if (category == AnimationCategory.ATTACK && this.m_5448_() != null) {
            double x = this.m_5448_().m_20185_() - this.m_20185_();
            double z = this.m_5448_().m_20189_() - this.m_20189_();
            double yawDiff = Mth.m_14136_((double)z, (double)x) * 57.2957763671875;
            float yRotD = Mth.m_14118_((float)this.f_20883_, (float)Util.yawToYRot(yawDiff));
            return this.getAllAnimations().get(yRotD < 0.0f ? ATTACK_FRONT_RIGHT : ATTACK_FRONT_LEFT);
        }
        return super.getAnimation(category);
    }

    @Override
    @NotNull
    public AnimationInfo nextAttackAnimation() {
        if (this.m_5448_() != null) {
            double x = this.m_5448_().m_20185_() - this.m_20185_();
            double z = this.m_5448_().m_20189_() - this.m_20189_();
            double yawDiff = Mth.m_14136_((double)z, (double)x) * 57.2957763671875;
            float yRotD = Mth.m_14118_((float)this.f_20883_, (float)Util.yawToYRot(yawDiff));
            return this.getAllAnimations().get(yRotD < 0.0f ? ATTACK_FRONT_RIGHT : ATTACK_FRONT_LEFT);
        }
        return this.getAllAnimations().get(ATTACK_FRONT_RIGHT);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.ANKYLOSAURUS_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSounds.ANKYLOSAURUS_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.ANKYLOSAURUS_DEATH.get();
    }
}

