/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.entity.ai.FleeBattleGoal;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricShearable;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import com.github.teamfossilsarcheology.fossil.sounds.ModSounds;
import com.github.teamfossilsarcheology.fossil.util.Gender;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Elasmotherium
extends Prehistoric
implements PrehistoricShearable {
    private static final EntityDataAccessor<Boolean> SHEARED = SynchedEntityData.m_135353_(Elasmotherium.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int woolRegenTicks;

    public Elasmotherium(EntityType<Elasmotherium> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(3, (Goal)new FleeBattleGoal(this, 1.0));
    }

    @Override
    public void refreshTexturePath() {
        if (!this.f_19853_.f_46443_) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("textures/entity/elasmotherium/elasmotherium");
        if (this.m_6162_()) {
            builder.append("_baby");
        }
        if (this.isTeen() || this.isAdult()) {
            if (this.getGender() == Gender.MALE) {
                builder.append("_male");
            } else {
                builder.append("_female");
            }
        }
        if (this.m_5803_()) {
            builder.append("_sleeping");
        }
        if (this.isSheared()) {
            builder.append("_shaved");
        }
        builder.append(".png");
        this.textureLocation = FossilMod.location(builder.toString());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHEARED, (Object)false);
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> key) {
        if (SHEARED.equals(key)) {
            this.refreshTexturePath();
        }
        super.m_7350_(key);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Sheared", this.isSheared());
        compound.m_128405_("WoolRegenTicks", this.woolRegenTicks);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSheared(compound.m_128471_("Sheared"));
        this.woolRegenTicks = compound.m_128451_("WoolRegenTicks");
    }

    @Override
    public PrehistoricEntityInfo info() {
        return PrehistoricEntityInfo.ELASMOTHERIUM;
    }

    @Override
    public void feed(int foodAmount) {
        super.feed(foodAmount);
        if (this.isSheared()) {
            this.woolRegenTicks += foodAmount;
            if (this.woolRegenTicks >= 125) {
                this.setSheared(false);
                this.woolRegenTicks = 0;
            }
        }
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_(Items.f_42574_) && this.m_6220_()) {
            this.m_5851_(SoundSource.PLAYERS);
            this.m_146852_(GameEvent.f_157781_, (Entity)player);
            if (!this.f_19853_.f_46443_) {
                itemStack.m_41622_(1, (LivingEntity)player, player2 -> player2.m_21190_(hand));
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public void m_5851_(SoundSource source) {
        this.f_19853_.m_6269_(null, (Entity)this, SoundEvents.f_12344_, source, 1.0f, 1.0f);
        this.setSheared(true);
        int maxWool = 1 + this.f_19796_.nextInt(10);
        for (int i = 0; i < maxWool; ++i) {
            ItemEntity itemEntity = this.m_20000_((ItemLike)ModItems.ELASMOTHERIUM_FUR.get(), 1);
            if (itemEntity == null) continue;
            itemEntity.m_20256_(itemEntity.m_20184_().m_82520_((double)(this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.1, (double)this.f_19796_.nextFloat() * 0.05, (double)(this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.1));
        }
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor levelIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        SpawnGroupData data = super.m_6518_(levelIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (this.m_6162_()) {
            this.setSheared(true);
        }
        return data;
    }

    public boolean m_6220_() {
        return !this.isSheared() && !this.m_6162_();
    }

    @Override
    public boolean isSheared() {
        return (Boolean)this.f_19804_.m_135370_(SHEARED);
    }

    @Override
    public void setSheared(boolean sheared) {
        this.f_19804_.m_135381_(SHEARED, (Object)sheared);
    }

    @Override
    public Item getOrderItem() {
        return Items.f_42398_;
    }

    @Override
    public double m_20204_() {
        return 0.35 * (double)this.m_20206_();
    }

    @Override
    public float getGenderedScale() {
        return this.getGender() == Gender.MALE ? 1.2f : super.getGenderedScale();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.ELASMOTHERIUM_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSounds.ELASMOTHERIUM_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.ELASMOTHERIUM_DEATH.get();
    }
}

