/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric;

import com.github.teamfossilsarcheology.fossil.entity.ai.FleeBattleGoal;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.OrderType;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfoAI;
import com.github.teamfossilsarcheology.fossil.sounds.ModSounds;
import com.github.teamfossilsarcheology.fossil.util.Gender;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class Megaloceros
extends Prehistoric {
    private Megaloceros lastMate;

    public Megaloceros(EntityType<Megaloceros> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(3, (Goal)new FleeBattleGoal(this, 1.0));
        this.f_21346_.m_25352_(4, (Goal)new LastMateHurtByTargetGoal(this));
    }

    @Override
    public void procreate(Prehistoric other) {
        super.procreate(other);
        if (other instanceof Megaloceros) {
            Megaloceros megaloceros;
            this.lastMate = megaloceros = (Megaloceros)other;
        }
    }

    @Override
    public PrehistoricEntityInfo info() {
        return PrehistoricEntityInfo.MEGALOCEROS;
    }

    @Override
    public Item getOrderItem() {
        return Items.f_42398_;
    }

    @Override
    public double m_6048_() {
        return super.m_6048_() - 0.35;
    }

    @Override
    public float getGenderedScale() {
        return this.getGender() == Gender.MALE ? 1.2f : super.getGenderedScale();
    }

    @Override
    public PrehistoricEntityInfoAI.Response aiResponseType() {
        return this.getGender() == Gender.MALE && !this.m_6162_() ? PrehistoricEntityInfoAI.Response.TERRITORIAL : PrehistoricEntityInfoAI.Response.SCARED;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.MEGALOCEROS_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSounds.MEGALOCEROS_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.MEGALOCEROS_DEATH.get();
    }

    static class LastMateHurtByTargetGoal
    extends TargetGoal {
        private final Megaloceros megaloceros;
        private int timestamp;

        public LastMateHurtByTargetGoal(Megaloceros megaloceros) {
            super((Mob)megaloceros, false);
            this.megaloceros = megaloceros;
        }

        public boolean m_8036_() {
            if (this.megaloceros.aiResponseType() == PrehistoricEntityInfoAI.Response.SCARED || this.megaloceros.getCurrentOrder() != OrderType.WANDER) {
                return false;
            }
            if (this.megaloceros.lastMate == null) {
                return false;
            }
            this.f_26137_ = this.megaloceros.lastMate.m_142581_();
            int i = this.megaloceros.lastMate.m_21213_();
            return i != this.timestamp && this.m_26150_(this.f_26137_, TargetingConditions.f_26872_);
        }

        public void m_8056_() {
            super.m_8056_();
            this.megaloceros.m_6710_(this.f_26137_);
            this.timestamp = this.megaloceros.lastMate.m_21213_();
        }
    }
}

